/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.slurry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.providers.ISlurryProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class SlurryStack
extends ChemicalStack<Slurry> {
    public static final SlurryStack EMPTY = new SlurryStack(null);
    public static final Codec<Slurry> SLURRY_NON_EMPTY_CODEC = SlurryStack.chemicalNonEmptyCodec(MekanismAPI.SLURRY_REGISTRY);
    public static final Codec<Holder<Slurry>> SLURRY_NON_EMPTY_HOLDER_CODEC = SlurryStack.chemicalNonEmptyHolderCodec(MekanismAPI.SLURRY_REGISTRY);
    public static final MapCodec<SlurryStack> MAP_CODEC = SlurryStack.codec(SLURRY_NON_EMPTY_CODEC, SlurryStack::new);
    public static final Codec<SlurryStack> CODEC = MAP_CODEC.codec();
    public static final Codec<SlurryStack> OPTIONAL_CODEC = SlurryStack.optionalCodec(CODEC, EMPTY);
    public static final StreamCodec<RegistryFriendlyByteBuf, SlurryStack> OPTIONAL_STREAM_CODEC = SlurryStack.optionalStreamCodec(MekanismAPI.SLURRY_REGISTRY_NAME, SlurryStack::new, EMPTY);
    public static final StreamCodec<RegistryFriendlyByteBuf, SlurryStack> STREAM_CODEC = SlurryStack.streamCodec(OPTIONAL_STREAM_CODEC);

    public static Codec<SlurryStack> fixedAmountCodec(int amount) {
        return SlurryStack.fixedAmountCodec(SLURRY_NON_EMPTY_CODEC, SlurryStack::new, amount);
    }

    public SlurryStack(ISlurryProvider slurryProvider, long amount) {
        super((Slurry)slurryProvider.getChemical(), amount);
    }

    public SlurryStack(Holder<Slurry> slurryHolder, long amount) {
        super(slurryHolder, amount);
    }

    private SlurryStack(@Nullable Void unused) {
        super(unused);
    }

    public static Optional<SlurryStack> parse(HolderLookup.Provider lookupProvider, Tag tag) {
        return CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(error -> MekanismAPI.logger.error("Tried to load invalid gas: '{}'", error));
    }

    public static SlurryStack parseOptional(HolderLookup.Provider lookupProvider, CompoundTag tag) {
        return tag.isEmpty() ? EMPTY : SlurryStack.parse(lookupProvider, (Tag)tag).orElse(EMPTY);
    }

    @Override
    protected Slurry getEmptyChemical() {
        return MekanismAPI.EMPTY_SLURRY;
    }

    public SlurryStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new SlurryStack((ISlurryProvider)this.getChemical(), this.getAmount());
    }

    public SlurryStack copyWithAmount(long amount) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new SlurryStack((ISlurryProvider)this.getChemical(), amount);
    }

    public SlurryStack split(long amount) {
        long i = Math.min(amount, this.getAmount());
        SlurryStack stack = this.copyWithAmount(i);
        this.shrink(i);
        return stack;
    }

    public SlurryStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        SlurryStack stack = this.copy();
        this.setAmount(0L);
        return stack;
    }

    @Override
    public Tag save(HolderLookup.Provider lookupProvider, Tag prefix) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty SlurryStack");
        }
        return (Tag)CODEC.encode((Object)this, (DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)prefix).getOrThrow();
    }

    @Override
    public Tag save(HolderLookup.Provider lookupProvider) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty SlurryStack");
        }
        return (Tag)CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }
}

