/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.merged;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.merged.BoxedChemical;
import mekanism.api.text.IHasTextComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public class BoxedChemicalStack
implements IHasTextComponent {
    public static final BoxedChemicalStack EMPTY = new BoxedChemicalStack(ChemicalType.GAS, GasStack.EMPTY);
    public static final Codec<BoxedChemicalStack> CODEC = ChemicalStack.BOXED_CODEC.xmap(BoxedChemicalStack::box, BoxedChemicalStack::getChemicalStack);
    public static final Codec<BoxedChemicalStack> OPTIONAL_CODEC = ChemicalStack.BOXED_OPTIONAL_CODEC.xmap(BoxedChemicalStack::box, BoxedChemicalStack::getChemicalStack);
    public static final StreamCodec<RegistryFriendlyByteBuf, BoxedChemicalStack> STREAM_CODEC = ChemicalStack.BOXED_STREAM_CODEC.map(BoxedChemicalStack::box, BoxedChemicalStack::getChemicalStack);
    public static final StreamCodec<RegistryFriendlyByteBuf, BoxedChemicalStack> OPTIONAL_STREAM_CODEC = ChemicalStack.BOXED_OPTIONAL_STREAM_CODEC.map(BoxedChemicalStack::box, BoxedChemicalStack::getChemicalStack);
    private final ChemicalType chemicalType;
    private final ChemicalStack<?> chemicalStack;

    public static BoxedChemicalStack box(ChemicalStack<?> chemicalStack) {
        if (chemicalStack.isEmpty()) {
            return EMPTY;
        }
        return new BoxedChemicalStack(ChemicalType.getTypeFor(chemicalStack), chemicalStack);
    }

    public static Optional<BoxedChemicalStack> parse(HolderLookup.Provider lookupProvider, Tag tag) {
        return CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(error -> MekanismAPI.logger.error("Tried to load invalid boxed chemical: '{}'", error));
    }

    public static BoxedChemicalStack parseOptional(HolderLookup.Provider lookupProvider, CompoundTag tag) {
        return tag.isEmpty() ? EMPTY : BoxedChemicalStack.parse(lookupProvider, (Tag)tag).orElse(EMPTY);
    }

    private BoxedChemicalStack(ChemicalType chemicalType, ChemicalStack<?> chemicalStack) {
        this.chemicalType = chemicalType;
        this.chemicalStack = chemicalStack;
    }

    public BoxedChemical getType() {
        if (this.isEmpty()) {
            return BoxedChemical.EMPTY;
        }
        return new BoxedChemical(this.chemicalType, (Chemical<?>)this.chemicalStack.getChemical());
    }

    public ChemicalType getChemicalType() {
        return this.chemicalType;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.chemicalStack.isEmpty();
    }

    public Tag save(HolderLookup.Provider lookupProvider, Tag prefix) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty BoxedChemicalStack");
        }
        return (Tag)CODEC.encode((Object)this, (DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)prefix).getOrThrow();
    }

    public Tag save(HolderLookup.Provider lookupProvider) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty BoxedChemicalStack");
        }
        return (Tag)CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    public Tag saveOptional(HolderLookup.Provider lookupProvider) {
        return this.isEmpty() ? new CompoundTag() : this.save(lookupProvider);
    }

    public ChemicalStack<?> getChemicalStack() {
        return this.chemicalStack;
    }

    @Override
    @NotNull
    public Component getTextComponent() {
        return this.chemicalStack.getTextComponent();
    }

    public BoxedChemicalStack copy() {
        return new BoxedChemicalStack(this.chemicalType, this.chemicalStack.copy());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxedChemicalStack other = (BoxedChemicalStack)o;
        return this.chemicalType == other.chemicalType && this.chemicalStack.equals(other.chemicalStack);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chemicalType, this.chemicalStack});
    }
}

