/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.merged;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.text.IHasTextComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;

@NothingNullByDefault
public class BoxedChemical
implements IHasTextComponent {
    public static final BoxedChemical EMPTY = new BoxedChemical(ChemicalType.GAS, MekanismAPI.EMPTY_GAS);
    public static final Codec<BoxedChemical> CODEC = Chemical.BOXED_CODEC.xmap(BoxedChemical::box, BoxedChemical::getChemical);
    public static final Codec<BoxedChemical> OPTIONAL_CODEC = Chemical.BOXED_OPTIONAL_CODEC.xmap(BoxedChemical::box, BoxedChemical::getChemical);
    public static final StreamCodec<RegistryFriendlyByteBuf, BoxedChemical> STREAM_CODEC = Chemical.BOXED_STREAM_CODEC.map(BoxedChemical::box, BoxedChemical::getChemical);
    public static final StreamCodec<RegistryFriendlyByteBuf, BoxedChemical> OPTIONAL_STREAM_CODEC = Chemical.BOXED_OPTIONAL_STREAM_CODEC.map(BoxedChemical::box, BoxedChemical::getChemical);
    private final ChemicalType chemicalType;
    private final Chemical<?> chemical;

    public static BoxedChemical box(Chemical<?> chemical) {
        if (chemical.isEmptyType()) {
            return EMPTY;
        }
        return new BoxedChemical(ChemicalType.getTypeFor(chemical), chemical);
    }

    public static Optional<BoxedChemical> parse(HolderLookup.Provider lookupProvider, Tag tag) {
        return CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(error -> MekanismAPI.logger.error("Tried to load invalid boxed chemical: '{}'", error));
    }

    public static BoxedChemical parseOptional(HolderLookup.Provider lookupProvider, CompoundTag tag) {
        return tag.isEmpty() ? EMPTY : BoxedChemical.parse(lookupProvider, (Tag)tag).orElse(EMPTY);
    }

    protected BoxedChemical(ChemicalType chemicalType, Chemical<?> chemical) {
        this.chemicalType = chemicalType;
        this.chemical = chemical;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.chemical.isEmptyType();
    }

    public ChemicalType getChemicalType() {
        return this.chemicalType;
    }

    public Tag save(HolderLookup.Provider lookupProvider, Tag prefix) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty BoxedChemical");
        }
        return (Tag)CODEC.encode((Object)this, (DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)prefix).getOrThrow();
    }

    public Tag save(HolderLookup.Provider lookupProvider) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty BoxedChemical");
        }
        return (Tag)CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    public Tag saveOptional(HolderLookup.Provider lookupProvider) {
        return this.isEmpty() ? new CompoundTag() : this.save(lookupProvider);
    }

    public Chemical<?> getChemical() {
        return this.chemical;
    }

    @Override
    public Component getTextComponent() {
        return this.chemical.getTextComponent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxedChemical other = (BoxedChemical)o;
        return this.chemicalType == other.chemicalType && this.chemical == other.chemical;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chemicalType, this.chemical});
    }
}

