/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.gas;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.providers.IGasProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class GasStack
extends ChemicalStack<Gas> {
    public static final GasStack EMPTY = new GasStack(null);
    public static final Codec<Gas> GAS_NON_EMPTY_CODEC = GasStack.chemicalNonEmptyCodec(MekanismAPI.GAS_REGISTRY);
    public static final Codec<Holder<Gas>> GAS_NON_EMPTY_HOLDER_CODEC = GasStack.chemicalNonEmptyHolderCodec(MekanismAPI.GAS_REGISTRY);
    public static final MapCodec<GasStack> MAP_CODEC = GasStack.codec(GAS_NON_EMPTY_CODEC, GasStack::new);
    public static final Codec<GasStack> CODEC = MAP_CODEC.codec();
    public static final Codec<GasStack> OPTIONAL_CODEC = GasStack.optionalCodec(CODEC, EMPTY);
    public static final StreamCodec<RegistryFriendlyByteBuf, GasStack> OPTIONAL_STREAM_CODEC = GasStack.optionalStreamCodec(MekanismAPI.GAS_REGISTRY_NAME, GasStack::new, EMPTY);
    public static final StreamCodec<RegistryFriendlyByteBuf, GasStack> STREAM_CODEC = GasStack.streamCodec(OPTIONAL_STREAM_CODEC);

    public static Codec<GasStack> fixedAmountCodec(int amount) {
        return GasStack.fixedAmountCodec(GAS_NON_EMPTY_CODEC, GasStack::new, amount);
    }

    public GasStack(IGasProvider gasProvider, long amount) {
        super((Gas)gasProvider.getChemical(), amount);
    }

    public GasStack(Holder<Gas> gasHolder, long amount) {
        this((IGasProvider)gasHolder.value(), amount);
    }

    private GasStack(@Nullable Void unused) {
        super(unused);
    }

    public static Optional<GasStack> parse(HolderLookup.Provider lookupProvider, Tag tag) {
        return CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(error -> MekanismAPI.logger.error("Tried to load invalid gas: '{}'", error));
    }

    public static GasStack parseOptional(HolderLookup.Provider lookupProvider, CompoundTag tag) {
        return tag.isEmpty() ? EMPTY : GasStack.parse(lookupProvider, (Tag)tag).orElse(EMPTY);
    }

    @Override
    protected Gas getEmptyChemical() {
        return MekanismAPI.EMPTY_GAS;
    }

    public GasStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new GasStack((IGasProvider)this.getChemical(), this.getAmount());
    }

    public GasStack copyWithAmount(long amount) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new GasStack((IGasProvider)this.getChemical(), amount);
    }

    public GasStack split(long amount) {
        long i = Math.min(amount, this.getAmount());
        GasStack stack = this.copyWithAmount(i);
        this.shrink(i);
        return stack;
    }

    public GasStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        GasStack stack = this.copy();
        this.setAmount(0L);
        return stack;
    }

    @Override
    public Tag save(HolderLookup.Provider lookupProvider, Tag prefix) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty GasStack");
        }
        return (Tag)CODEC.encode((Object)this, (DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)prefix).getOrThrow();
    }

    @Override
    public Tag save(HolderLookup.Provider lookupProvider) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty GasStack");
        }
        return (Tag)CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }
}

