/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.attribute;

import java.util.Set;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttribute;

public interface ChemicalAttributeValidator {
    public static final ChemicalAttributeValidator DEFAULT = new ChemicalAttributeValidator(){

        @Override
        public boolean validate(ChemicalAttribute attr) {
            return !attr.needsValidation();
        }

        @Override
        public boolean process(Chemical<?> chemical) {
            return !chemical.hasAttributesWithValidation();
        }
    };
    public static final ChemicalAttributeValidator ALWAYS_ALLOW = new ChemicalAttributeValidator(){

        @Override
        public boolean validate(ChemicalAttribute attr) {
            return true;
        }

        @Override
        public boolean process(Chemical<?> chemical) {
            return true;
        }
    };

    public boolean validate(ChemicalAttribute var1);

    default public boolean process(Chemical<?> chemical) {
        for (ChemicalAttribute chemicalAttribute : chemical.getAttributes()) {
            if (this.validate(chemicalAttribute)) continue;
            return false;
        }
        return true;
    }

    default public boolean process(ChemicalStack<?> stack) {
        return this.process((Chemical<?>)stack.getChemical());
    }

    @SafeVarargs
    public static ChemicalAttributeValidator create(Class<? extends ChemicalAttribute> ... validAttributes) {
        return new SimpleAttributeValidator(validAttributes, true);
    }

    @SafeVarargs
    public static ChemicalAttributeValidator createStrict(Class<? extends ChemicalAttribute> ... validAttributes) {
        return new SimpleAttributeValidator(validAttributes, false);
    }

    public static class SimpleAttributeValidator
    implements ChemicalAttributeValidator {
        private final Set<Class<? extends ChemicalAttribute>> validTypes;
        private final boolean allowNoValidation;

        SimpleAttributeValidator(Class<? extends ChemicalAttribute>[] attributeTypes, boolean allowNoValidation) {
            this.validTypes = Set.of(attributeTypes);
            this.allowNoValidation = allowNoValidation;
        }

        @Override
        public boolean validate(ChemicalAttribute attribute) {
            return this.validTypes.contains(attribute.getClass()) || this.allowNoValidation && !attribute.needsValidation();
        }
    }
}

