/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IEmptyStackProvider;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;

@NothingNullByDefault
public interface IChemicalTank<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends IEmptyStackProvider<CHEMICAL, STACK>,
INBTSerializable<CompoundTag>,
IContentsListener {
    default public STACK createStack(STACK stored, long size) {
        return (STACK)((ChemicalStack)stored).copyWithAmount(size);
    }

    public STACK getStack();

    public void setStack(STACK var1);

    public void setStackUnchecked(STACK var1);

    default public STACK insert(STACK stack, Action action, AutomationType automationType) {
        if (((ChemicalStack)stack).isEmpty() || !this.isValid(stack)) {
            return stack;
        }
        long needed = this.getNeeded();
        if (needed <= 0L) {
            return stack;
        }
        boolean sameType = false;
        if (this.isEmpty() || (sameType = this.isTypeEqual((CHEMICAL)stack))) {
            long toAdd = Math.min(((ChemicalStack)stack).getAmount(), needed);
            if (action.execute()) {
                if (sameType) {
                    this.growStack(toAdd, action);
                } else {
                    this.setStack(this.createStack(stack, toAdd));
                }
            }
            return this.createStack(stack, ((ChemicalStack)stack).getAmount() - toAdd);
        }
        return stack;
    }

    default public STACK extract(long amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount < 1L) {
            return this.getEmptyStack();
        }
        STACK ret = this.createStack(this.getStack(), Math.min(this.getStored(), amount));
        if (!((ChemicalStack)ret).isEmpty() && action.execute()) {
            this.shrinkStack(((ChemicalStack)ret).getAmount(), action);
        }
        return ret;
    }

    public long getCapacity();

    public boolean isValid(STACK var1);

    default public long setStackSize(long amount, Action action) {
        if (this.isEmpty()) {
            return 0L;
        }
        if (amount <= 0L) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0L;
        }
        long maxStackSize = this.getCapacity();
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getStored() == amount || action.simulate()) {
            return amount;
        }
        this.setStack(this.createStack(this.getStack(), amount));
        return amount;
    }

    default public long growStack(long amount, Action action) {
        long current = this.getStored();
        if (current == 0L) {
            return 0L;
        }
        if (amount > 0L) {
            amount = Math.min(amount, this.getNeeded());
        }
        long newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    default public long shrinkStack(long amount, Action action) {
        return -this.growStack(-amount, action);
    }

    default public boolean isEmpty() {
        return ((ChemicalStack)this.getStack()).isEmpty();
    }

    default public void setEmpty() {
        this.setStack(this.getEmptyStack());
    }

    default public long getStored() {
        return ((ChemicalStack)this.getStack()).getAmount();
    }

    default public long getNeeded() {
        return Math.max(0L, this.getCapacity() - this.getStored());
    }

    default public CHEMICAL getType() {
        return ((ChemicalStack)this.getStack()).getChemical();
    }

    default public boolean isTypeEqual(STACK other) {
        return ChemicalStack.isSameChemical(this.getStack(), other);
    }

    default public boolean isTypeEqual(CHEMICAL other) {
        return ((ChemicalStack)this.getStack()).is(other);
    }

    default public ChemicalAttributeValidator getAttributeValidator() {
        return ChemicalAttributeValidator.DEFAULT;
    }

    default public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.put("stored", ((ChemicalStack)this.getStack()).save(provider));
        }
        return nbt;
    }
}

