/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.container.ContainerInteraction;
import mekanism.api.container.InContainerGetter;
import mekanism.api.container.LongContainerInteraction;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalUtils {
    private ChemicalUtils() {
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK insert(STACK stack, @Nullable Direction side, Action action, STACK empty, ToIntFunction<@Nullable Direction> tankCount, InContainerGetter<STACK> inTankGetter, ContainerInteraction<STACK> insertChemical) {
        ChemicalStack remainder;
        if (stack.isEmpty()) {
            return empty;
        }
        int tanks = tankCount.applyAsInt(side);
        if (tanks == 0) {
            return stack;
        }
        if (tanks == 1) {
            return (STACK)((ChemicalStack)insertChemical.interact(0, stack, side, action));
        }
        Object toInsert = stack;
        IntArrayList emptyTanks = new IntArrayList();
        for (int tank = 0; tank < tanks; ++tank) {
            ChemicalStack inTank = (ChemicalStack)inTankGetter.getStored(tank, side);
            if (inTank.isEmpty()) {
                emptyTanks.add(tank);
                continue;
            }
            if (!ChemicalStack.isSameChemical(inTank, stack)) continue;
            remainder = (ChemicalStack)insertChemical.interact(tank, toInsert, side, action);
            if (remainder.isEmpty()) {
                return empty;
            }
            toInsert = remainder;
        }
        IntListIterator intListIterator = emptyTanks.iterator();
        while (intListIterator.hasNext()) {
            int tank = (Integer)intListIterator.next();
            remainder = (ChemicalStack)insertChemical.interact(tank, toInsert, side, action);
            if (remainder.isEmpty()) {
                return empty;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> STACK insert(STACK stack, @Nullable Direction side, Function<@Nullable Direction, List<TANK>> tankSupplier, Action action, AutomationType automationType, STACK empty) {
        if (stack.isEmpty()) {
            return empty;
        }
        List<TANK> chemicalTanks = tankSupplier.apply(side);
        return ChemicalUtils.insert(stack, action, automationType, empty, chemicalTanks.size(), chemicalTanks);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> STACK insert(STACK stack, Action action, AutomationType automationType, STACK empty, int size, Iterable<TANK> chemicalTanks) {
        STACK remainder;
        if (stack.isEmpty()) {
            return empty;
        }
        if (size == 0) {
            return stack;
        }
        if (size == 1) {
            return ((IChemicalTank)chemicalTanks.iterator().next()).insert(stack, action, automationType);
        }
        STACK toInsert = stack;
        ArrayList<IChemicalTank> emptyTanks = new ArrayList<IChemicalTank>();
        for (IChemicalTank tank : chemicalTanks) {
            if (tank.isEmpty()) {
                emptyTanks.add(tank);
                continue;
            }
            if (!tank.isTypeEqual(stack)) continue;
            remainder = tank.insert(toInsert, action, automationType);
            if (remainder.isEmpty()) {
                return empty;
            }
            toInsert = remainder;
        }
        for (IChemicalTank tank : emptyTanks) {
            remainder = tank.insert(toInsert, action, automationType);
            if (remainder.isEmpty()) {
                return empty;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK extract(long amount, @Nullable Direction side, Action action, STACK empty, ToIntFunction<@Nullable Direction> tankCount, InContainerGetter<STACK> inTankGetter, LongContainerInteraction<STACK> extractChemical) {
        if (amount == 0L) {
            return empty;
        }
        int tanks = tankCount.applyAsInt(side);
        if (tanks == 0) {
            return empty;
        }
        if (tanks == 1) {
            return (STACK)((ChemicalStack)extractChemical.interact(0, amount, side, action));
        }
        Object extracted = empty;
        long toDrain = amount;
        for (int tank = 0; tank < tanks; ++tank) {
            ChemicalStack drained;
            if (!extracted.isEmpty() && !ChemicalStack.isSameChemical(extracted, (ChemicalStack)inTankGetter.getStored(tank, side)) || (drained = (ChemicalStack)extractChemical.interact(tank, toDrain, side, action)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) == 0L) break;
        }
        return extracted;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> STACK extract(long amount, @Nullable Direction side, Function<@Nullable Direction, List<TANK>> tankSupplier, Action action, AutomationType automationType, STACK empty) {
        if (amount == 0L) {
            return empty;
        }
        List<TANK> chemicalTanks = tankSupplier.apply(side);
        return ChemicalUtils.extract(amount, action, automationType, empty, chemicalTanks.size(), chemicalTanks);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> STACK extract(long amount, Action action, AutomationType automationType, STACK empty, int size, Iterable<TANK> chemicalTanks) {
        if (amount == 0L || size == 0) {
            return empty;
        }
        if (size == 1) {
            return ((IChemicalTank)chemicalTanks.iterator().next()).extract(amount, action, automationType);
        }
        STACK extracted = empty;
        long toDrain = amount;
        for (IChemicalTank tank : chemicalTanks) {
            Object drained;
            if (!extracted.isEmpty() && !tank.isTypeEqual(extracted) || ((ChemicalStack)(drained = tank.extract(toDrain, action, automationType))).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(((ChemicalStack)drained).getAmount());
            }
            if ((toDrain -= ((ChemicalStack)drained).getAmount()) != 0L) continue;
            break;
        }
        return extracted;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK extract(STACK stack, @Nullable Direction side, Action action, STACK empty, ToIntFunction<@Nullable Direction> tankCount, InContainerGetter<STACK> inTankGetter, LongContainerInteraction<STACK> extractChemical) {
        if (stack.isEmpty()) {
            return empty;
        }
        int tanks = tankCount.applyAsInt(side);
        if (tanks == 0) {
            return empty;
        }
        if (tanks == 1) {
            ChemicalStack inTank = (ChemicalStack)inTankGetter.getStored(0, side);
            if (inTank.isEmpty() || !ChemicalStack.isSameChemical(inTank, stack)) {
                return empty;
            }
            return (STACK)((ChemicalStack)extractChemical.interact(0, stack.getAmount(), side, action));
        }
        Object extracted = empty;
        long toDrain = stack.getAmount();
        for (int tank = 0; tank < tanks; ++tank) {
            ChemicalStack drained;
            if (!ChemicalStack.isSameChemical(stack, (ChemicalStack)inTankGetter.getStored(tank, side)) || (drained = (ChemicalStack)extractChemical.interact(tank, toDrain, side, action)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) == 0L) break;
        }
        return extracted;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> STACK extract(STACK stack, @Nullable Direction side, Function<@Nullable Direction, List<TANK>> tankSupplier, Action action, AutomationType automationType, STACK empty) {
        if (stack.isEmpty()) {
            return empty;
        }
        List<TANK> chemicalTanks = tankSupplier.apply(side);
        return ChemicalUtils.extract(stack, action, automationType, empty, chemicalTanks.size(), chemicalTanks);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> STACK extract(STACK stack, Action action, AutomationType automationType, STACK empty, int size, Iterable<TANK> chemicalTanks) {
        if (stack.isEmpty() || size == 0) {
            return empty;
        }
        if (size == 1) {
            IChemicalTank tank = (IChemicalTank)chemicalTanks.iterator().next();
            if (tank.isEmpty() || !tank.isTypeEqual(stack)) {
                return empty;
            }
            return tank.extract(stack.getAmount(), action, automationType);
        }
        STACK extracted = empty;
        long toDrain = stack.getAmount();
        for (IChemicalTank tank : chemicalTanks) {
            Object drained;
            if (!tank.isTypeEqual(stack) || ((ChemicalStack)(drained = tank.extract(toDrain, action, automationType))).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(((ChemicalStack)drained).getAmount());
            }
            if ((toDrain -= ((ChemicalStack)drained).getAmount()) != 0L) continue;
            break;
        }
        return extracted;
    }
}

