/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.attribute.IChemicalAttributeContainer;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.text.TextComponentUtil;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class Chemical<CHEMICAL extends Chemical<CHEMICAL>>
implements IChemicalProvider<CHEMICAL>,
IChemicalAttributeContainer<CHEMICAL> {
    public static final Codec<Chemical<?>> BOXED_OPTIONAL_CODEC = ChemicalType.CODEC.dispatch("chemical_type", ChemicalType::getTypeFor, type -> switch (type) {
        default -> throw new MatchException(null, null);
        case ChemicalType.GAS -> MekanismAPI.GAS_REGISTRY.byNameCodec().fieldOf("gas");
        case ChemicalType.INFUSION -> MekanismAPI.INFUSE_TYPE_REGISTRY.byNameCodec().fieldOf("infuse_type");
        case ChemicalType.PIGMENT -> MekanismAPI.PIGMENT_REGISTRY.byNameCodec().fieldOf("pigment");
        case ChemicalType.SLURRY -> MekanismAPI.SLURRY_REGISTRY.byNameCodec().fieldOf("slurry");
    });
    public static final Codec<Chemical<?>> BOXED_CODEC = BOXED_OPTIONAL_CODEC.validate(chemical -> chemical.isEmptyType() ? DataResult.error(() -> "Chemical must not be mekanism:empty") : DataResult.success((Object)chemical));
    public static final StreamCodec<RegistryFriendlyByteBuf, Chemical<?>> BOXED_OPTIONAL_STREAM_CODEC = ChemicalType.STREAM_CODEC.cast().dispatch(ChemicalType::getTypeFor, type -> switch (type) {
        default -> throw new MatchException(null, null);
        case ChemicalType.GAS -> Gas.STREAM_CODEC;
        case ChemicalType.INFUSION -> InfuseType.STREAM_CODEC;
        case ChemicalType.PIGMENT -> Pigment.STREAM_CODEC;
        case ChemicalType.SLURRY -> Slurry.STREAM_CODEC;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, Chemical<?>> BOXED_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Chemical<?>>(){

        public Chemical<?> decode(RegistryFriendlyByteBuf buffer) {
            Chemical chemical = (Chemical)BOXED_OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            if (chemical.isEmptyType()) {
                throw new DecoderException("Empty Chemicals are not allowed");
            }
            return chemical;
        }

        public void encode(RegistryFriendlyByteBuf buffer, Chemical<?> chemical) {
            if (chemical.isEmptyType()) {
                throw new EncoderException("Empty Chemicals are not allowed");
            }
            BOXED_OPTIONAL_STREAM_CODEC.encode((Object)buffer, chemical);
        }
    };
    private final Map<Class<? extends ChemicalAttribute>, ChemicalAttribute> attributeMap;
    private final ResourceLocation iconLocation;
    private final int tint;
    private boolean isRadioactive;
    private boolean hasAttributesWithValidation;
    @Nullable
    private String translationKey;

    protected Chemical(ChemicalBuilder<CHEMICAL, ?> builder) {
        this.attributeMap = new HashMap<Class<ChemicalAttribute>, ChemicalAttribute>(builder.getAttributeMap());
        this.iconLocation = builder.getTexture();
        this.tint = builder.getTint();
        this.isRadioactive = this.attributeMap.containsKey(GasAttributes.Radiation.class);
        this.hasAttributesWithValidation = this.isRadioactive || this.attributeMap.values().stream().anyMatch(ChemicalAttribute::needsValidation);
    }

    @Override
    @NotNull
    public CHEMICAL getChemical() {
        return (CHEMICAL)this;
    }

    @Override
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = this.getDefaultTranslationKey();
        }
        return this.translationKey;
    }

    @Override
    public boolean has(Class<? extends ChemicalAttribute> type) {
        return this.attributeMap.containsKey(type);
    }

    public boolean isRadioactive() {
        return this.isRadioactive;
    }

    public boolean hasAttributesWithValidation() {
        return this.hasAttributesWithValidation;
    }

    @Override
    @Nullable
    public <ATTRIBUTE extends ChemicalAttribute> ATTRIBUTE get(Class<ATTRIBUTE> type) {
        return (ATTRIBUTE)this.attributeMap.get(type);
    }

    public void addAttribute(ChemicalAttribute attribute) {
        this.attributeMap.put(attribute.getClass(), attribute);
        if (attribute instanceof GasAttributes.Radiation) {
            this.isRadioactive = true;
            this.hasAttributesWithValidation = true;
        } else if (attribute.needsValidation()) {
            this.hasAttributesWithValidation = true;
        }
    }

    @Override
    public Collection<ChemicalAttribute> getAttributes() {
        return this.attributeMap.values();
    }

    @Override
    public Collection<Class<? extends ChemicalAttribute>> getAttributeTypes() {
        return this.attributeMap.keySet();
    }

    protected abstract String getDefaultTranslationKey();

    @Override
    public Component getTextComponent() {
        return TextComponentUtil.translate(this.getTranslationKey());
    }

    public ResourceLocation getIcon() {
        return this.iconLocation;
    }

    public int getTint() {
        return this.tint;
    }

    public int getColorRepresentation() {
        return this.getTint();
    }

    public boolean is(TagKey<CHEMICAL> tag) {
        return this.getAsHolder().is(tag);
    }

    public Stream<TagKey<CHEMICAL>> getTags() {
        return this.getAsHolder().tags();
    }

    public Holder<CHEMICAL> getAsHolder() {
        return this.getRegistry().wrapAsHolder((Object)this);
    }

    public abstract boolean isEmptyType();

    @Override
    public ResourceLocation getRegistryName() {
        return this.getRegistry().getKey((Object)this);
    }

    protected abstract DefaultedRegistry<CHEMICAL> getRegistry();
}

