/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;

@NothingNullByDefault
public class MekanismAPITags {
    private static final ResourceLocation HIDDEN_RL = ResourceLocation.fromNamespaceAndPath((String)"c", (String)"hidden_from_recipe_viewers");

    private MekanismAPITags() {
    }

    private static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)path);
    }

    public static class Entities {
        public static final TagKey<EntityType<?>> RADIATION_IMMUNE = Entities.commonTag("radiation_immune");
        public static final TagKey<EntityType<?>> MEK_RADIATION_IMMUNE = Entities.tag("radiation_immune");

        private Entities() {
        }

        private static TagKey<EntityType<?>> commonTag(String name) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        private static TagKey<EntityType<?>> tag(String name) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)MekanismAPITags.rl(name));
        }
    }

    public static class DamageTypes {
        public static final TagKey<DamageType> MEKASUIT_ALWAYS_SUPPORTED = DamageTypes.tag("mekasuit_always_supported");
        public static final TagKey<DamageType> IS_PREVENTABLE_MAGIC = DamageTypes.tag("is_preventable_magic");

        private DamageTypes() {
        }

        private static TagKey<DamageType> tag(String name) {
            return TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)MekanismAPITags.rl(name));
        }
    }

    public static class MobEffects {
        public static final TagKey<MobEffect> SPEED_UP_BLACKLIST = MobEffects.tag("speed_up_blacklist");

        private MobEffects() {
        }

        private static TagKey<MobEffect> tag(String name) {
            return TagKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)MekanismAPITags.rl(name));
        }
    }

    public static class Slurries {
        public static final TagKey<Slurry> HIDDEN_FROM_RECIPE_VIEWERS = TagKey.create(MekanismAPI.SLURRY_REGISTRY_NAME, (ResourceLocation)HIDDEN_RL);
        public static final TagKey<Slurry> DIRTY = Slurries.tag("dirty");
        public static final TagKey<Slurry> CLEAN = Slurries.tag("clean");

        private Slurries() {
        }

        private static TagKey<Slurry> tag(String name) {
            return TagKey.create(MekanismAPI.SLURRY_REGISTRY_NAME, (ResourceLocation)MekanismAPITags.rl(name));
        }
    }

    public static class Pigments {
        public static final TagKey<Pigment> HIDDEN_FROM_RECIPE_VIEWERS = TagKey.create(MekanismAPI.PIGMENT_REGISTRY_NAME, (ResourceLocation)HIDDEN_RL);

        private Pigments() {
        }
    }

    public static class InfuseTypes {
        public static final TagKey<InfuseType> HIDDEN_FROM_RECIPE_VIEWERS = TagKey.create(MekanismAPI.INFUSE_TYPE_REGISTRY_NAME, (ResourceLocation)HIDDEN_RL);
        public static final TagKey<InfuseType> CARBON = InfuseTypes.tag("carbon");
        public static final TagKey<InfuseType> REDSTONE = InfuseTypes.tag("redstone");
        public static final TagKey<InfuseType> DIAMOND = InfuseTypes.tag("diamond");
        public static final TagKey<InfuseType> REFINED_OBSIDIAN = InfuseTypes.tag("refined_obsidian");
        public static final TagKey<InfuseType> BIO = InfuseTypes.tag("bio");
        public static final TagKey<InfuseType> FUNGI = InfuseTypes.tag("fungi");
        public static final TagKey<InfuseType> GOLD = InfuseTypes.tag("gold");
        public static final TagKey<InfuseType> TIN = InfuseTypes.tag("tin");

        private InfuseTypes() {
        }

        private static TagKey<InfuseType> tag(String name) {
            return TagKey.create(MekanismAPI.INFUSE_TYPE_REGISTRY_NAME, (ResourceLocation)MekanismAPITags.rl(name));
        }
    }

    public static class Gases {
        public static final TagKey<Gas> HIDDEN_FROM_RECIPE_VIEWERS = TagKey.create(MekanismAPI.GAS_REGISTRY_NAME, (ResourceLocation)HIDDEN_RL);
        public static final TagKey<Gas> WASTE_BARREL_DECAY_BLACKLIST = Gases.tag("waste_barrel_decay_blacklist");

        private Gases() {
        }

        private static TagKey<Gas> tag(String name) {
            return TagKey.create(MekanismAPI.GAS_REGISTRY_NAME, (ResourceLocation)MekanismAPITags.rl(name));
        }
    }
}

