/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.util;

import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import tfar.craftingstation.util.SideContainerWrapper;

public class SideContainerNeoForge
implements IItemHandlerModifiable,
SideContainerWrapper {
    private final IItemHandlerModifiable handler;

    public SideContainerNeoForge(IItemHandlerModifiable handler) {
        this.handler = handler;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        if (this.$valid(slot)) {
            this.handler.setStackInSlot(slot, stack);
        }
    }

    public int getSlots() {
        return this.handler.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (!this.$valid(slot)) {
            return ItemStack.EMPTY;
        }
        return this.handler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.handler.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.$valid(slot)) {
            return ItemStack.EMPTY;
        }
        return this.handler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.handler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.handler.isItemValid(slot, stack);
    }

    @Override
    public int $getSlotCount() {
        return this.getSlots();
    }

    @Override
    public ItemStack $getStack(int slot) {
        return this.getStackInSlot(slot);
    }

    @Override
    public void $setStack(int slot, ItemStack stack) {
        this.setStackInSlot(slot, stack);
    }

    @Override
    public ItemStack $removeStack(int slot, int count) {
        return this.extractItem(slot, count, false);
    }
}

