/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tfar.craftingstation.blockentity.CraftingStationBlockEntity;
import tfar.craftingstation.platform.Services;

public class CraftingStationBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final VoxelShape shape;
    public static final BooleanProperty WATERLOGGED;
    public static final DirectionProperty FACING;

    public CraftingStationBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        ((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level level, BlockPos pos, Player player, BlockHitResult pHitResult) {
        BlockEntity tileEntity;
        if (!level.isClientSide && (tileEntity = level.getBlockEntity(pos)) instanceof MenuProvider) {
            Services.PLATFORM.openMenu((ServerPlayer)player, (MenuProvider)tileEntity, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        return te instanceof CraftingStationBlockEntity ? (MenuProvider)te : null;
    }

    public void onRemove(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileentity = worldIn.getBlockEntity(pos);
            if (tileentity instanceof CraftingStationBlockEntity) {
                CraftingStationBlockEntity craftingStationBlock = (CraftingStationBlockEntity)tileentity;
                CraftingStationBlock.dropItems(craftingStationBlock.input, worldIn, pos);
                worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    public static void dropItems(SimpleContainer inv, Level world, BlockPos pos) {
        Containers.dropContents((Level)world, (BlockPos)pos, (Container)inv);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    @Nonnull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Nonnull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.add(new Property[]{WATERLOGGED, FACING});
    }

    @Nonnull
    public FluidState getFluidState(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_204507_1_);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos pos;
        Level level = ctx.getLevel();
        boolean water = level.getFluidState(pos = ctx.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new CraftingStationBlockEntity(pPos, pState);
    }

    static {
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        FACING = HorizontalDirectionalBlock.FACING;
        VoxelShape[] shapes = new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0, (double)16.0)};
        shape = Shapes.or((VoxelShape)shapes[0], (VoxelShape[])new VoxelShape[]{shapes[1], shapes[2], shapes[3], shapes[4]});
    }
}

