/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.util;

import dev.shadowsoffire.placebo.Placebo;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.apache.commons.lang3.tuple.Pair;

public class PlaceboTaskQueue {
    public static void submitTask(ResourceLocation id, Task task) {
        Impl.TASKS.add((Pair<ResourceLocation, Task>)Pair.of((Object)id, (Object)task));
    }

    public static void submitDelayedTask(ResourceLocation id, int delay, Task task) {
        Impl.TASKS.add((Pair<ResourceLocation, Task>)Pair.of((Object)id, (Object)new DelayedTask(delay, task)));
    }

    @EventBusSubscriber(modid="placebo", bus=EventBusSubscriber.Bus.GAME)
    public static class Impl {
        private static final Queue<Pair<ResourceLocation, Task>> TASKS = new ArrayDeque<Pair<ResourceLocation, Task>>();

        @SubscribeEvent
        public static void tick(ServerTickEvent.Post e) {
            Iterator it = TASKS.iterator();
            Pair current = null;
            while (it.hasNext()) {
                current = (Pair)it.next();
                try {
                    if (!((Task)current.getRight()).execute().isCompleted()) continue;
                    it.remove();
                }
                catch (Exception ex) {
                    Placebo.LOGGER.error("An exception occurred while running a ticking task with ID {}. It will be terminated.", current.getLeft());
                    it.remove();
                    ex.printStackTrace();
                }
            }
        }

        @SubscribeEvent
        public static void stopped(ServerStoppedEvent e) {
            TASKS.clear();
        }

        @SubscribeEvent
        public static void started(ServerStartedEvent e) {
            TASKS.clear();
        }
    }

    private static class DelayedTask
    implements Task {
        private int delay;
        private Task task;

        private DelayedTask(int delay, Task task) {
            this.delay = delay;
            this.task = task;
        }

        @Override
        public Status execute() {
            if (this.delay-- > 0) {
                return Status.COMPLETED;
            }
            return this.task.execute();
        }
    }

    @FunctionalInterface
    public static interface Task {
        public Status execute();
    }

    public static enum Status {
        RUNNING,
        COMPLETED;


        public boolean isCompleted() {
            return this == COMPLETED;
        }
    }
}

