/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.reload;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ReloadListenerPayloads {

    public record End(String path) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<End> TYPE = new CustomPacketPayload.Type(Placebo.loc("reload_sync_end"));
        public static final StreamCodec<FriendlyByteBuf, End> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, End::path, End::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static class Provider
        implements PayloadProvider<End> {
            @Override
            public CustomPacketPayload.Type<End> getType() {
                return TYPE;
            }

            @Override
            public StreamCodec<? super RegistryFriendlyByteBuf, End> getCodec() {
                return CODEC;
            }

            @Override
            public void handle(End msg, IPayloadContext ctx) {
                DynamicRegistry.SyncManagement.endSync(msg.path);
            }

            @Override
            public List<ConnectionProtocol> getSupportedProtocols() {
                return List.of(ConnectionProtocol.PLAY);
            }

            @Override
            public Optional<PacketFlow> getFlow() {
                return Optional.of(PacketFlow.CLIENTBOUND);
            }

            @Override
            public String getVersion() {
                return "1";
            }
        }
    }

    public record Content<V extends CodecProvider<? super V>>(String path, ResourceLocation key, V item) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Content<?>> TYPE = new CustomPacketPayload.Type(Placebo.loc("reload_sync_content"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Content<?>> CODEC = StreamCodec.of(Content::write, Content::read);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void write(RegistryFriendlyByteBuf buf, Content payload) {
            buf.writeUtf(payload.path, 50);
            buf.writeResourceLocation(payload.key);
            DynamicRegistry.SyncManagement.writeItem(payload.path, payload.item, buf);
        }

        public static <V extends CodecProvider<? super V>> Content<V> read(RegistryFriendlyByteBuf buf) {
            String path = buf.readUtf(50);
            ResourceLocation key = buf.readResourceLocation();
            try {
                CodecProvider value = (CodecProvider)DynamicRegistry.SyncManagement.readItem(path, buf);
                return new Content<CodecProvider>(path, key, value);
            }
            catch (Exception ex) {
                Placebo.LOGGER.error("Failure when deserializing a dynamic registry object via network: Registry: {}, Object ID: {}", (Object)path, (Object)key);
                throw ex;
            }
        }

        public static class Provider<V extends CodecProvider<? super V>>
        implements PayloadProvider<Content<?>> {
            @Override
            public CustomPacketPayload.Type<Content<?>> getType() {
                return TYPE;
            }

            @Override
            public StreamCodec<? super RegistryFriendlyByteBuf, Content<?>> getCodec() {
                return CODEC;
            }

            @Override
            public void handle(Content<?> msg, IPayloadContext ctx) {
                DynamicRegistry.SyncManagement.acceptItem(msg.path, msg.key, msg.item);
            }

            @Override
            public List<ConnectionProtocol> getSupportedProtocols() {
                return List.of(ConnectionProtocol.PLAY);
            }

            @Override
            public Optional<PacketFlow> getFlow() {
                return Optional.of(PacketFlow.CLIENTBOUND);
            }

            @Override
            public String getVersion() {
                return "1";
            }
        }
    }

    public record Start(String path) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Start> TYPE = new CustomPacketPayload.Type(Placebo.loc("reload_sync_start"));
        public static final StreamCodec<FriendlyByteBuf, Start> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Start::path, Start::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static class Provider
        implements PayloadProvider<Start> {
            @Override
            public CustomPacketPayload.Type<Start> getType() {
                return TYPE;
            }

            @Override
            public StreamCodec<? super RegistryFriendlyByteBuf, Start> getCodec() {
                return CODEC;
            }

            @Override
            public void handle(Start msg, IPayloadContext ctx) {
                DynamicRegistry.SyncManagement.initSync(msg.path);
            }

            @Override
            public List<ConnectionProtocol> getSupportedProtocols() {
                return List.of(ConnectionProtocol.PLAY);
            }

            @Override
            public Optional<PacketFlow> getFlow() {
                return Optional.of(PacketFlow.CLIENTBOUND);
            }

            @Override
            public String getVersion() {
                return "1";
            }
        }
    }
}

