/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.reload;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.JsonUtil;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.RegistryCallback;
import dev.shadowsoffire.placebo.reload.ReloadListenerPayloads;
import io.netty.handler.codec.CodecException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public abstract class DynamicRegistry<R extends CodecProvider<? super R>>
extends SimpleJsonResourceReloadListener {
    protected final Logger logger;
    protected final String path;
    protected final boolean synced;
    protected final boolean subtypes;
    protected final CodecMap<R> codecs;
    protected final Codec<DynamicHolder<R>> holderCodec;
    protected final BiMap<ResourceLocation, StreamCodec<RegistryFriendlyByteBuf, ? extends R>> streamCodecs;
    protected BiMap<ResourceLocation, R> registry = ImmutableBiMap.of();
    private final Map<ResourceLocation, R> staged = new HashMap<ResourceLocation, R>();
    private final Map<ResourceLocation, DynamicHolder<? extends R>> holders = new ConcurrentHashMap<ResourceLocation, DynamicHolder<? extends R>>();
    private final Set<RegistryCallback<R>> callbacks = new HashSet<RegistryCallback<R>>();

    public DynamicRegistry(Logger logger, String path, boolean synced, boolean subtypes) {
        super(new GsonBuilder().setLenient().create(), path);
        this.logger = logger;
        this.path = path;
        this.synced = synced;
        this.subtypes = subtypes;
        this.codecs = new CodecMap(path);
        this.streamCodecs = HashBiMap.create();
        this.registerBuiltinCodecs();
        if (this.codecs.isEmpty()) {
            throw new RuntimeException("Attempted to create a dynamic registry for " + path + " with no built-in codecs!");
        }
        this.holderCodec = ResourceLocation.CODEC.xmap(this::holder, DynamicHolder::getId);
    }

    protected final void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.beginReload();
        ConditionalOps ops = this.makeConditionalOps();
        objects.forEach((key, ele) -> {
            try {
                if (JsonUtil.checkAndLogEmpty(ele, key, this.path, this.logger) && JsonUtil.checkConditions(ele, key, this.path, this.logger, (ConditionalOps<JsonElement>)ops)) {
                    JsonObject obj = ele.getAsJsonObject();
                    CodecProvider deserialized = (CodecProvider)((Pair)this.codecs.decode(JsonOps.INSTANCE, obj).getOrThrow(this::makeCodecException)).getFirst();
                    Preconditions.checkNotNull(deserialized.getCodec(), (Object)("A " + this.path + " with id " + String.valueOf(key) + " is not declaring a codec."));
                    Preconditions.checkNotNull((Object)this.codecs.getKey(deserialized.getCodec()), (Object)("A " + this.path + " with id " + String.valueOf(key) + " is declaring an unregistered codec."));
                    this.register((ResourceLocation)key, (R)deserialized);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed parsing {} file {}.", (Object)this.path, key);
                this.logger.error("Underlying Exception: ", (Throwable)e);
            }
        });
        this.onReload();
    }

    protected abstract void registerBuiltinCodecs();

    protected void beginReload() {
        this.callbacks.forEach(l -> l.beginReload(this));
        this.registry = HashBiMap.create();
        this.holders.values().forEach(DynamicHolder::unbind);
    }

    protected void onReload() {
        this.registry = ImmutableBiMap.copyOf(this.registry);
        this.logger.info("Registered {} {}.", (Object)this.registry.size(), (Object)this.path);
        this.callbacks.forEach(l -> l.onReload(this));
        this.holders.values().forEach(DynamicHolder::bind);
    }

    public Set<ResourceLocation> getKeys() {
        return this.registry.keySet();
    }

    public Collection<R> getValues() {
        return this.registry.values();
    }

    @Nullable
    public R getValue(ResourceLocation key) {
        return (R)((CodecProvider)this.registry.get((Object)key));
    }

    @Nullable
    public ResourceLocation getKey(R value) {
        return (ResourceLocation)this.registry.inverse().get(value);
    }

    public R getOrDefault(ResourceLocation key, R defValue) {
        return (R)((CodecProvider)this.registry.getOrDefault((Object)key, defValue));
    }

    public void registerToBus() {
        if (this.synced) {
            SyncManagement.registerForSync(this);
        }
        NeoForge.EVENT_BUS.addListener(this::addReloader);
    }

    public <T extends R> DynamicHolder<T> holder(ResourceLocation id) {
        return this.holders.computeIfAbsent(id, k -> new DynamicHolder(this, (ResourceLocation)k));
    }

    public <T extends R> DynamicHolder<T> holder(T t) {
        ResourceLocation key = this.getKey(t);
        return this.holder((T)(key == null ? DynamicHolder.EMPTY : key));
    }

    public DynamicHolder<R> emptyHolder() {
        return this.holder((Object)DynamicHolder.EMPTY);
    }

    public Codec<DynamicHolder<R>> holderCodec() {
        return this.holderCodec;
    }

    public final void registerCodec(ResourceLocation key, Codec<? extends R> codec, StreamCodec<RegistryFriendlyByteBuf, ? extends R> streamCodec) {
        if (!this.subtypes) {
            throw new UnsupportedOperationException("Attempted to call registerCodec on a registry which does not support subtypes.");
        }
        this.codecs.register(key, codec);
        this.streamCodecs.put((Object)key, streamCodec);
    }

    public final void registerCodec(ResourceLocation key, Codec<? extends R> codec) {
        this.registerCodec(key, codec, ByteBufCodecs.fromCodecWithRegistries(codec));
    }

    protected final void registerDefaultCodec(ResourceLocation key, Codec<? extends R> codec, StreamCodec<RegistryFriendlyByteBuf, ? extends R> streamCodec) {
        if (this.codecs.getDefaultCodec() != null) {
            throw new UnsupportedOperationException("Attempted to register a second " + this.path + " default codec with key " + String.valueOf(key));
        }
        this.codecs.register(key, codec);
        this.codecs.setDefaultCodec(codec);
        this.streamCodecs.put((Object)key, streamCodec);
    }

    protected final void registerDefaultCodec(ResourceLocation key, Codec<? extends R> codec) {
        if (this.codecs.getDefaultCodec() != null) {
            throw new UnsupportedOperationException("Attempted to register a second " + this.path + " default codec with key " + String.valueOf(key));
        }
        this.codecs.register(key, codec);
        this.codecs.setDefaultCodec(codec);
    }

    public final boolean addCallback(RegistryCallback<R> callback) {
        return this.callbacks.add(callback);
    }

    public final boolean removeCallback(RegistryCallback<R> callback) {
        return this.callbacks.remove(callback);
    }

    public final String getPath() {
        return this.path;
    }

    protected final void register(ResourceLocation key, R value) {
        if (this.registry.containsKey((Object)key)) {
            throw new UnsupportedOperationException("Attempted to register a " + this.path + " with a duplicate registry ID! Key: " + String.valueOf(key));
        }
        this.validateItem(key, value);
        this.registry.put((Object)key, value);
        this.holders.computeIfAbsent(key, k -> new DynamicHolder(this, (ResourceLocation)k));
    }

    protected void validateItem(ResourceLocation key, R value) {
    }

    private void addReloader(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)this);
    }

    private void pushStagedToLive() {
        this.beginReload();
        this.staged.forEach(this::register);
        this.onReload();
    }

    private CodecException makeCodecException(String msg) {
        return new CodecException("Codec failure for type %s, message: %s".formatted(this.path, msg));
    }

    private void sync(OnDatapackSyncEvent e) {
        ServerPlayer player = e.getPlayer();
        Consumer<CustomPacketPayload> target = player == null ? x$0 -> PacketDistributor.sendToAllPlayers((CustomPacketPayload)x$0, (CustomPacketPayload[])new CustomPacketPayload[0]) : payload -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        target.accept(new ReloadListenerPayloads.Start(this.path));
        this.registry.forEach((k, v) -> target.accept(new ReloadListenerPayloads.Content<CodecProvider>(this.path, (ResourceLocation)k, (CodecProvider)v)));
        target.accept(new ReloadListenerPayloads.End(this.path));
    }

    @ApiStatus.Internal
    static class SyncManagement {
        private static final Map<String, DynamicRegistry<?>> SYNC_REGISTRY = new LinkedHashMap();

        SyncManagement() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void registerForSync(DynamicRegistry<?> listener) {
            if (!listener.synced) {
                throw new UnsupportedOperationException("Attempted to register the non-synced JSON Reload Listener " + listener.path + " as a synced listener!");
            }
            Map<String, DynamicRegistry<?>> map = SYNC_REGISTRY;
            synchronized (map) {
                if (SYNC_REGISTRY.containsKey(listener.path)) {
                    throw new UnsupportedOperationException("Attempted to register the JSON Reload Listener for syncing " + listener.path + " but one already exists!");
                }
                if (SYNC_REGISTRY.isEmpty()) {
                    NeoForge.EVENT_BUS.addListener(SyncManagement::syncAll);
                }
                SYNC_REGISTRY.put(listener.path, listener);
            }
        }

        static void initSync(String path) {
            SyncManagement.ifPresent(path, registry -> registry.staged.clear());
            Placebo.LOGGER.info("Starting sync for {}", (Object)path);
        }

        static <V extends CodecProvider<? super V>> void writeItem(String path, V value, RegistryFriendlyByteBuf buf) {
            SyncManagement.ifPresent(path, registry -> {
                ResourceLocation type = registry.codecs.getKey(value.getCodec());
                buf.writeResourceLocation(type);
                ((StreamCodec)registry.streamCodecs.get((Object)type)).encode((Object)buf, (Object)value);
            });
        }

        static <V> V readItem(String path, RegistryFriendlyByteBuf buf) {
            DynamicRegistry<?> registry = SYNC_REGISTRY.get(path);
            if (registry == null) {
                throw new RuntimeException("Received sync packet for unknown registry!");
            }
            ResourceLocation type = buf.readResourceLocation();
            return (V)((StreamCodec)registry.streamCodecs.get((Object)type)).decode((Object)buf);
        }

        static <V> void acceptItem(String path, ResourceLocation key, V value) {
            SyncManagement.ifPresent(path, registry -> registry.staged.put(key, value));
        }

        static void endSync(String path) {
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                return;
            }
            SyncManagement.ifPresent(path, DynamicRegistry::pushStagedToLive);
        }

        private static void ifPresent(String path, Consumer<DynamicRegistry<?>> consumer) {
            DynamicRegistry<?> value = SYNC_REGISTRY.get(path);
            if (value != null) {
                consumer.accept(value);
            }
        }

        private static void syncAll(OnDatapackSyncEvent e) {
            SYNC_REGISTRY.values().forEach(r -> r.sync(e));
        }
    }
}

