/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo;

import com.mojang.brigadier.CommandDispatcher;
import dev.shadowsoffire.placebo.PlaceboConfig;
import dev.shadowsoffire.placebo.color.GradientColor;
import dev.shadowsoffire.placebo.commands.PlaceboCommand;
import dev.shadowsoffire.placebo.events.ResourceReloadEvent;
import dev.shadowsoffire.placebo.loot.StackLootEntry;
import dev.shadowsoffire.placebo.network.PayloadHelper;
import dev.shadowsoffire.placebo.payloads.ButtonClickPayload;
import dev.shadowsoffire.placebo.payloads.PatreonDisablePayload;
import dev.shadowsoffire.placebo.reload.ReloadListenerPayloads;
import dev.shadowsoffire.placebo.systems.gear.GearSetRegistry;
import dev.shadowsoffire.placebo.systems.mixes.MixRegistry;
import dev.shadowsoffire.placebo.systems.wanderer.WandererTradesRegistry;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import dev.shadowsoffire.placebo.util.PlaceboUtil;
import java.util.HashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.bus.EventBus;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="placebo")
public class Placebo {
    public static final String MODID = "placebo";
    public static final Logger LOGGER = LogManager.getLogger((String)"placebo");

    public Placebo(IEventBus bus) {
        bus.register((Object)this);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::serverReload);
        TextColor.NAMED_COLORS = new HashMap(TextColor.NAMED_COLORS);
        bus.addListener(TabFillingRegistry::fillTabs);
        bus.register((Object)new PayloadHelper());
        ((EventBus)NeoForge.EVENT_BUS).start();
        PlaceboConfig.load();
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        PayloadHelper.registerPayload(new ButtonClickPayload.Provider());
        PayloadHelper.registerPayload(new PatreonDisablePayload.Provider());
        PayloadHelper.registerPayload(new ReloadListenerPayloads.Start.Provider());
        PayloadHelper.registerPayload(new ReloadListenerPayloads.Content.Provider());
        PayloadHelper.registerPayload(new ReloadListenerPayloads.End.Provider());
        e.enqueueWork(() -> PlaceboUtil.registerCustomColor(GradientColor.RAINBOW));
        GearSetRegistry.INSTANCE.registerToBus();
        WandererTradesRegistry.INSTANCE.registerToBus();
        MixRegistry.INSTANCE.registerToBus();
    }

    @SubscribeEvent
    public void register(RegisterEvent e) {
        e.register(Registries.LOOT_POOL_ENTRY_TYPE, helper -> helper.register(Placebo.loc("stack_entry"), (Object)StackLootEntry.TYPE));
    }

    public void registerCommands(RegisterCommandsEvent e) {
        PlaceboCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher(), e.getBuildContext());
    }

    public void serverReload(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)((ResourceManagerReloadListener)res -> NeoForge.EVENT_BUS.post((Event)new ResourceReloadEvent(res, LogicalSide.SERVER))));
    }

    public static ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

