/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.vanillaplustools;

import com.ldtteam.vanillaplustools.ModEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ToolAction;
import net.neoforged.neoforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class ModShovelItem
extends ShovelItem {
    public ModShovelItem(Tier tier) {
        super(tier, new Item.Properties());
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ToolAction toolAction) {
        return ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack item;
        if (!context.getLevel().isClientSide && (item = context.getItemInHand()).getItem() instanceof ModShovelItem) {
            Player player = context.getPlayer();
            Level level = context.getLevel();
            if (super.useOn(context) == InteractionResult.CONSUME && player != null && player.mayUseItemAt(context.getClickedPos(), context.getClickedFace(), context.getItemInHand())) {
                for (BlockPos pos : ModEvents.getAffectedPos(player)) {
                    BlockState blockstate = (BlockState)FLATTENABLES.get(level.getBlockState(pos).getBlock());
                    if (!level.getBlockState(pos.above()).isAir() || blockstate == null) continue;
                    BlockState state = Blocks.DIRT_PATH.defaultBlockState();
                    level.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.setBlock(pos, state, 11);
                }
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, context.getItemInHand().getEquipmentSlot());
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }
}

