/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.vanillaplustools;

import com.ldtteam.vanillaplustools.BlockParticleEffectMessage;
import com.ldtteam.vanillaplustools.ModHammerItem;
import com.ldtteam.vanillaplustools.ModShovelItem;
import com.ldtteam.vanillaplustools.ModTags;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class ModEvents {
    @SubscribeEvent
    public static void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        ItemStack item;
        if (event.getState().canOcclude() && ((item = event.getPlayer().getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof ModHammerItem || item.getItem() instanceof ModShovelItem)) {
            ItemStack mainHand = event.getPlayer().getMainHandItem();
            Level level = event.getPlayer().getCommandSenderWorld();
            double hardness = event.getState().getDestroySpeed((BlockGetter)level, event.getPos());
            for (BlockPos pos : ModEvents.getAffectedPos(event.getPlayer())) {
                BlockState state = level.getBlockState(pos);
                if (!(hardness * 2.0 >= (double)state.getDestroySpeed((BlockGetter)level, pos)) || !ModEvents.isBestTool(state, (LevelAccessor)level, pos, item, event.getPlayer())) continue;
                state.getBlock().playerDestroy(level, event.getPlayer(), pos, state, level.getBlockEntity(pos), mainHand);
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
        }
    }

    private static boolean isBestTool(BlockState target, LevelAccessor level, BlockPos pos, ItemStack stack, Player player) {
        if (stack.getItem() instanceof ModHammerItem && target.is(ModTags.CAN_HAMMER) || stack.getItem() instanceof ModShovelItem && target.is(ModTags.CAN_SHOVEL)) {
            return true;
        }
        return stack.isCorrectToolForDrops(target);
    }

    public static BlockHitResult rayTrace(Level level, Player player, ClipContext.Fluid mode) {
        float pitch = player.getXRot();
        float yaw = player.getYRot();
        Vec3 vec3 = player.getEyePosition(1.0f);
        float cosYaw = Mth.cos((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = Mth.sin((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -Mth.cos((float)(-pitch * ((float)Math.PI / 180)));
        float sinPitch = Mth.sin((float)(-pitch * ((float)Math.PI / 180)));
        float product = sinYaw * cosPitch;
        float product2 = cosYaw * cosPitch;
        double reachDistance = Math.max(player.blockInteractionRange(), player.entityInteractionRange());
        Vec3 vec32 = vec3.add((double)product * reachDistance, (double)sinPitch * reachDistance, (double)product2 * reachDistance);
        return level.clip(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, mode, (Entity)player));
    }

    public static List<BlockPos> getAffectedPos(@NotNull Player player) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockHitResult rayTrace = ModEvents.rayTrace(player.level(), player, ClipContext.Fluid.NONE);
        if (rayTrace instanceof BlockHitResult) {
            BlockHitResult rayTraceResult = rayTrace;
            BlockPos center = rayTraceResult.getBlockPos();
            list.add(center);
            switch (rayTraceResult.getDirection()) {
                case DOWN: 
                case UP: {
                    list.add(center.west());
                    list.add(center.east());
                    list.add(center.north());
                    list.add(center.south());
                    list.add(center.west().north());
                    list.add(center.west().south());
                    list.add(center.east().north());
                    list.add(center.east().south());
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    list.add(center.above());
                    list.add(center.below());
                    list.add(center.west());
                    list.add(center.east());
                    list.add(center.west().above());
                    list.add(center.west().below());
                    list.add(center.east().above());
                    list.add(center.east().below());
                    break;
                }
                case EAST: 
                case WEST: {
                    list.add(center.above());
                    list.add(center.below());
                    list.add(center.north());
                    list.add(center.south());
                    list.add(center.north().above());
                    list.add(center.north().below());
                    list.add(center.south().above());
                    list.add(center.south().below());
                }
            }
        }
        return list;
    }

    @SubscribeEvent
    public static void breakSpeed(@NotNull PlayerEvent.BreakSpeed event) {
        ItemStack item = event.getEntity().getItemInHand(InteractionHand.MAIN_HAND);
        if (event.getPosition().isPresent() && (item.getItem() instanceof ModHammerItem || item.getItem() instanceof ModShovelItem)) {
            Player player = event.getEntity();
            Level level = player.getCommandSenderWorld();
            BlockPos vector = ((BlockPos)event.getPosition().get()).subtract((Vec3i)player.blockPosition());
            Direction facing = Direction.getNearest((float)vector.getX(), (float)vector.getY(), (float)vector.getZ()).getOpposite();
            for (BlockPos pos : ModEvents.getAffectedPos(player)) {
                BlockState theBlock = level.getBlockState(pos);
                if (!ModEvents.isBestTool(theBlock, (LevelAccessor)level, pos, item, event.getEntity())) continue;
                BlockParticleEffectMessage pEM = new BlockParticleEffectMessage(pos, facing.get3DDataValue());
                if (level.isClientSide()) continue;
                PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)level), null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)10.0, (CustomPacketPayload)pEM, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

