/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.vanillaplustools;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class BlockParticleEffectMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<BlockParticleEffectMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"vanillaplustools", (String)"block_particle_effect_message"));
    private BlockPos pos;
    private int side;

    public BlockParticleEffectMessage(@NotNull FriendlyByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
        this.side = buf.readInt();
    }

    public BlockParticleEffectMessage(BlockPos pos, int side) {
        this.pos = pos;
        this.side = side;
    }

    public void onExecute(@NotNull IPayloadContext ctxIn) {
        ctxIn.enqueueWork(() -> Minecraft.getInstance().particleEngine.crack(this.pos, Direction.values()[this.side]));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.pos.getX());
        buf.writeInt(this.pos.getY());
        buf.writeInt(this.pos.getZ());
        buf.writeInt(this.side);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

