/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record PlayerGUIOperationMessage(Operation op, List<UUID> targets) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerGUIOperationMessage> TYPE = new CustomPacketPayload.Type(FTBTeamsAPI.rl("player_gui_operation"));
    public static StreamCodec<FriendlyByteBuf, PlayerGUIOperationMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)NetworkHelper.enumStreamCodec(Operation.class), PlayerGUIOperationMessage::op, (StreamCodec)UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs.list()), PlayerGUIOperationMessage::targets, PlayerGUIOperationMessage::new);

    public static PlayerGUIOperationMessage forUUID(Operation op, UUID target) {
        return new PlayerGUIOperationMessage(op, List.of(target));
    }

    public static PlayerGUIOperationMessage forGameProfiles(Operation op, Collection<GameProfile> targets) {
        return new PlayerGUIOperationMessage(op, targets.stream().map(GameProfile::getId).toList());
    }

    public static void handle(PlayerGUIOperationMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            UUID senderId = context.getPlayer().getUUID();
            FTBTeamsAPI.api().getManager().getTeamForPlayerID(senderId).ifPresent(team -> {
                if (team instanceof PartyTeam) {
                    PartyTeam partyTeam = (PartyTeam)team;
                    TeamRank senderRank = partyTeam.getRankForPlayer(serverPlayer.getUUID());
                    message.targets.forEach(target -> PlayerGUIOperationMessage.processTarget(serverPlayer, senderRank, partyTeam, message.op, target));
                }
            });
        });
    }

    private static void processTarget(ServerPlayer sourcePlayer, TeamRank senderRank, PartyTeam partyTeam, Operation op, UUID targetId) {
        if (op.requireSameTeam() && !FTBTeamsAPI.api().getManager().arePlayersInSameTeam(sourcePlayer.getUUID(), targetId)) {
            return;
        }
        TeamRank targetRank = partyTeam.getRankForPlayer(targetId);
        FTBTeams.LOGGER.debug("received teams operation msg {} from {} (rank {}), team {}, target {} (rank {})", (Object)op, (Object)sourcePlayer.getUUID(), (Object)senderRank, (Object)partyTeam.getName().getString(), (Object)targetId, (Object)targetRank);
        try {
            List<GameProfile> targetProfile = List.of(new GameProfile(targetId, ""));
            switch (op.ordinal()) {
                case 3: {
                    if (senderRank.getPower() <= targetRank.getPower()) break;
                    partyTeam.kick(sourcePlayer.createCommandSourceStack(), targetProfile);
                    break;
                }
                case 0: {
                    if (!senderRank.isAtLeast(TeamRank.OWNER) || !targetRank.isAtLeast(TeamRank.MEMBER)) break;
                    partyTeam.promote(sourcePlayer, targetProfile);
                    break;
                }
                case 1: {
                    if (!senderRank.isAtLeast(TeamRank.OWNER) || !targetRank.isAtLeast(TeamRank.OFFICER)) break;
                    partyTeam.demote(sourcePlayer, targetProfile);
                    break;
                }
                case 4: {
                    if (!senderRank.isAtLeast(TeamRank.OWNER)) break;
                    ServerPlayer p = sourcePlayer.getServer().getPlayerList().getPlayer(targetId);
                    if (p != null) {
                        partyTeam.transferOwnership(sourcePlayer.createCommandSourceStack(), p.getGameProfile());
                    }
                    break;
                }
                case 2: {
                    partyTeam.leave(sourcePlayer.getUUID());
                    break;
                }
                case 5: {
                    if (!senderRank.isAtLeast(TeamRank.OFFICER)) break;
                    ServerPlayer p = sourcePlayer.getServer().getPlayerList().getPlayer(targetId);
                    if (p != null) {
                        partyTeam.invite(sourcePlayer, List.of(p.getGameProfile()));
                    }
                    break;
                }
                case 6: {
                    if (!senderRank.isAtLeast(TeamRank.OFFICER) || !targetRank.isAtLeast(TeamRank.NONE)) break;
                    partyTeam.addAlly(sourcePlayer.createCommandSourceStack(), targetProfile);
                    break;
                }
                case 7: {
                    if (!senderRank.isAtLeast(TeamRank.OFFICER) || !targetRank.isAtLeast(TeamRank.ALLY)) break;
                    partyTeam.removeAlly(sourcePlayer.createCommandSourceStack(), targetProfile);
                }
            }
        }
        catch (CommandSyntaxException e) {
            sourcePlayer.displayClientMessage((Component)Component.literal((String)e.getMessage()).withStyle(ChatFormatting.RED), false);
        }
    }

    public CustomPacketPayload.Type<PlayerGUIOperationMessage> type() {
        return TYPE;
    }

    public static enum Operation {
        PROMOTE(true),
        DEMOTE(true),
        LEAVE(true),
        KICK(true),
        TRANSFER_OWNER(true),
        INVITE(false),
        ADD_ALLY(false),
        REMOVE_ALLY(false);

        private final boolean requireSameTeam;

        private Operation(boolean requireSameTeam) {
            this.requireSameTeam = requireSameTeam;
        }

        boolean requireSameTeam() {
            return this.requireSameTeam;
        }

        public void sendMessage(KnownClientPlayer target) {
            NetworkManager.sendToServer((CustomPacketPayload)PlayerGUIOperationMessage.forUUID(this, target.id()));
        }
    }
}

