/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.item;

import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.glfw.GLFW;

@ParametersAreNonnullByDefault
public class BasicItem
extends Item {
    private TitaniumTab itemGroup = null;

    public BasicItem(Item.Properties properties) {
        super(properties);
    }

    public BasicItem(String name, Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        if (this.hasTooltipDetails(null)) {
            this.addTooltipDetails(null, stack, tooltip, flagIn.isAdvanced());
        }
        for (Key key : Key.values()) {
            if (!this.hasTooltipDetails(key)) continue;
            if (key.isDown()) {
                this.addTooltipDetails(key, stack, tooltip, flagIn.isAdvanced());
                continue;
            }
            tooltip.add((Component)Component.literal((String)("Hold " + String.valueOf(ChatFormatting.YELLOW) + key.getSerializedName() + String.valueOf(ChatFormatting.GRAY) + " for more information")));
        }
    }

    public void addTooltipDetails(@Nullable Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
    }

    public boolean hasTooltipDetails(@Nullable Key key) {
        return false;
    }

    public void setItemGroup(TitaniumTab itemGroup) {
        this.itemGroup = itemGroup;
        this.itemGroup.getTabList().add(this);
    }

    public static enum Key implements StringRepresentable
    {
        SHIFT(344, 340),
        CTRL(345, 341),
        ALT(346, 342);

        final String name;
        final int[] keys;

        private Key(int ... keys) {
            this.keys = keys;
            this.name = this.name();
        }

        public boolean isDown() {
            for (int key : this.keys) {
                if (GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)key) != 1) continue;
                return true;
            }
            return false;
        }

        @Nonnull
        public String getSerializedName() {
            return StringUtils.capitalize((String)this.name.toLowerCase());
        }
    }
}

