/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.inventory;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.FacingHandlerScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.component.sideness.SidedComponentManager;
import com.hrznstudio.titanium.util.FacingUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class SidedInventoryComponent<T extends IComponentHarness>
extends InventoryComponent<T>
implements IFacingComponent {
    private int color = DyeColor.WHITE.getFireworkColor();
    private int facingHandlerX = 8;
    private int facingHandlerY = 84;
    private HashMap<FacingUtil.Sideness, IFacingComponent.FaceMode> facingModes = new HashMap();
    private HashMap<FacingUtil.Sideness, Integer> slotCache = new HashMap();
    private int position;
    private boolean hasFacingAddon;
    private IFacingComponent.FaceMode[] validFaceModes;

    public SidedInventoryComponent(String name, int xPos, int yPos, int size, int position) {
        super(name, xPos, yPos, size);
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            this.facingModes.put(value, IFacingComponent.FaceMode.ENABLED);
        }
        this.position = position;
        this.setColorGuiEnabled(true);
        this.hasFacingAddon = true;
        this.validFaceModes = IFacingComponent.FaceMode.values();
    }

    public SidedInventoryComponent<T> disableFacingAddon() {
        this.hasFacingAddon = false;
        return this;
    }

    public HashMap<FacingUtil.Sideness, IFacingComponent.FaceMode> getFacingModes() {
        return this.facingModes;
    }

    @Override
    public int getColor() {
        return new Color(this.color).getRGB();
    }

    public SidedInventoryComponent<T> setColor(int color) {
        this.color = color;
        return this;
    }

    public SidedInventoryComponent<T> setColor(DyeColor color) {
        this.color = color.getMapColor().col;
        return this;
    }

    @Override
    public Color getColorForSlotRendering(int slot) {
        return this.getSlotToColorRenderMap().getOrDefault(slot, new Color(this.color));
    }

    @Override
    public Rectangle getRectangle(IAsset asset) {
        int renderingOffset = 1;
        Rectangle rectangle = new Rectangle((Integer)this.getSlotPosition().apply(0).getLeft() - 1, (Integer)this.getSlotPosition().apply(0).getRight() - 1, (int)asset.getArea().getWidth() + (Integer)this.getSlotPosition().apply(0).getLeft(), (int)asset.getArea().getHeight() + (Integer)this.getSlotPosition().apply(0).getRight());
        for (int i = 0; i < this.getSlots(); ++i) {
            if ((double)((Integer)this.getSlotPosition().apply(i).getLeft()).intValue() < rectangle.getX()) {
                rectangle.setLocation((Integer)this.getSlotPosition().apply(i).getLeft(), rectangle.y);
            }
            if ((double)((Integer)this.getSlotPosition().apply(i).getRight()).intValue() < rectangle.getY()) {
                rectangle.setLocation(rectangle.x, (Integer)this.getSlotPosition().apply(i).getRight());
            }
            if ((double)((Integer)this.getSlotPosition().apply(i).getLeft()).intValue() + asset.getArea().getWidth() > (double)rectangle.width) {
                rectangle.setSize((Integer)this.getSlotPosition().apply(i).getLeft() + asset.getArea().width, rectangle.height);
            }
            if (!((double)((Integer)this.getSlotPosition().apply(i).getRight()).intValue() + asset.getArea().getHeight() > (double)rectangle.height)) continue;
            rectangle.setSize(rectangle.width, (Integer)this.getSlotPosition().apply(i).getRight() + asset.getArea().height);
        }
        return new Rectangle(this.getXPos() - renderingOffset - 2 + rectangle.x, this.getYPos() - renderingOffset - 2 + rectangle.y, rectangle.width + renderingOffset * 2 + 3, rectangle.height + renderingOffset * 2 + 3);
    }

    @Override
    public int getFacingHandlerX() {
        return this.facingHandlerX;
    }

    @Override
    public int getFacingHandlerY() {
        return this.facingHandlerY;
    }

    private boolean workSides(Level level, BlockPos pos, Direction blockFacing, int workAmount, IFacingComponent.FaceMode mode) {
        for (FacingUtil.Sideness sideness : this.facingModes.keySet()) {
            Direction real;
            IItemHandler cap;
            if (this.facingModes.get((Object)sideness) != mode || (cap = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos.relative(real = FacingUtil.getFacingFromSide(blockFacing, sideness)), (Object)real.getOpposite())) == null || !this.transfer(sideness, (IItemHandler)(mode == IFacingComponent.FaceMode.PUSH ? this : cap), (IItemHandler)(mode == IFacingComponent.FaceMode.PUSH ? cap : this), workAmount)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean work(Level world, BlockPos pos, Direction blockFacing, int workAmount) {
        if (this.workSides(world, pos, blockFacing, workAmount, IFacingComponent.FaceMode.PUSH)) {
            return true;
        }
        return this.workSides(world, pos, blockFacing, workAmount, IFacingComponent.FaceMode.PULL);
    }

    @Override
    public SidedInventoryComponent<T> setFacingHandlerPos(int x, int y) {
        this.facingHandlerX = x;
        this.facingHandlerY = y;
        return this;
    }

    @Override
    public IFacingComponent.FaceMode[] getValidFacingModes() {
        return this.validFaceModes;
    }

    public SidedInventoryComponent<T> setValidFaceModes(IFacingComponent.FaceMode ... validFaceModes) {
        this.validFaceModes = validFaceModes;
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            this.facingModes.put(value, validFaceModes[0]);
        }
        return this;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeNBT(provider);
        CompoundTag compound = new CompoundTag();
        for (FacingUtil.Sideness facing : this.facingModes.keySet()) {
            compound.putString(facing.name(), this.facingModes.get((Object)facing).name());
        }
        nbt.put("FacingModes", (Tag)compound);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        if (nbt.contains("FacingModes")) {
            CompoundTag compound = nbt.getCompound("FacingModes");
            for (String face : compound.getAllKeys()) {
                this.facingModes.put(FacingUtil.Sideness.valueOf(face), IFacingComponent.FaceMode.valueOf(compound.getString(face)));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        List<IFactory<? extends IScreenAddon>> addons = super.getScreenAddons();
        if (this.hasFacingAddon) {
            addons.add(() -> new FacingHandlerScreenAddon(SidedComponentManager.ofRight(this.getFacingHandlerX(), this.getFacingHandlerY(), this.position, AssetTypes.BUTTON_SIDENESS_MANAGER, 4), this, AssetTypes.SLOT, this.getComponentHarness() instanceof ActiveTile ? ((ActiveTile)this.getComponentHarness()).getFacingDirection() : Direction.NORTH));
        }
        return addons;
    }

    private int getNextSlot(IItemHandler handler, int currentSlot) {
        for (int i = currentSlot; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).isEmpty()) continue;
            return i;
        }
        return 0;
    }

    private boolean transfer(FacingUtil.Sideness sideness, IItemHandler from, IItemHandler to, int workAmount) {
        if (from.getSlots() <= 0) {
            return false;
        }
        int slot = this.slotCache.getOrDefault((Object)sideness, this.getNextSlot(from, 0));
        if (slot >= from.getSlots()) {
            slot = 0;
        }
        ItemStack extracted = from.extractItem(slot, workAmount, true);
        int outSlot = this.isValidForAnySlot(to, extracted);
        if (!extracted.isEmpty() && outSlot != -1) {
            ItemStack returned = to.insertItem(outSlot, extracted, false);
            return !from.extractItem(slot, extracted.getCount() - returned.getCount(), false).isEmpty();
        }
        this.slotCache.put(sideness, this.getNextSlot(from, slot + 1));
        return false;
    }

    private int isValidForAnySlot(IItemHandler dest, ItemStack stack) {
        for (int i = 0; i < dest.getSlots(); ++i) {
            if (!dest.isItemValid(i, stack)) continue;
            if (dest.getStackInSlot(i).isEmpty()) {
                return i;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)dest.getStackInSlot(i), (ItemStack)stack) || dest.getStackInSlot(i).getCount() >= dest.getSlotLimit(i)) continue;
            return i;
        }
        return -1;
    }
}

