/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.container;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.client.screen.IScreenAddonConsumer;
import com.hrznstudio.titanium.client.screen.addon.AssetScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.WidgetScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.lwjgl.glfw.GLFW;

public class BasicContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IScreenAddonConsumer {
    private final T container;
    private final Component title;
    private IAssetProvider assetProvider;
    protected int xCenter;
    protected int yCenter;
    private List<IScreenAddon> addons;
    private int dragX;
    private int dragY;
    private boolean isMouseDragging;

    public BasicContainerScreen(T container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.container = container;
        this.title = title;
        this.assetProvider = IAssetProvider.DEFAULT_PROVIDER;
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.imageWidth = background.getArea().width;
        this.imageHeight = background.getArea().height;
        this.isMouseDragging = false;
        this.addons = new ArrayList<IScreenAddon>();
    }

    public BasicContainerScreen(T container, Inventory inventory, Component title, IAssetProvider provider) {
        super(container, inventory, title);
        this.container = container;
        this.title = title;
        this.assetProvider = provider;
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.imageWidth = background.getArea().width;
        this.imageHeight = background.getArea().height;
        this.addons = new ArrayList<IScreenAddon>();
    }

    protected void init() {
        super.init();
        this.getAddons().forEach(screenAddon -> screenAddon.init(this.leftPos, this.topPos));
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.xCenter = (this.width - this.imageWidth) / 2;
        this.yCenter = (this.height - this.imageHeight) / 2;
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.blit(IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND).getResourceLocation(), this.xCenter, this.yCenter, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.drawString(this.font, this.title.getString(), this.getTitleX(this.xCenter), this.getTitleY(this.yCenter), this.getTitleColor(), false);
        this.addons.stream().filter(IScreenAddon::isBackground).forEach(iGuiAddon -> iGuiAddon.drawBackgroundLayer(guiGraphics, (Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY, partialTicks));
        this.addons.stream().filter(iScreenAddon -> !iScreenAddon.isBackground()).forEach(iGuiAddon -> iGuiAddon.drawBackgroundLayer(guiGraphics, (Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY, partialTicks));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.addons.forEach(iGuiAddon -> {
            if (iGuiAddon instanceof AssetScreenAddon) {
                AssetScreenAddon assetGuiAddon = (AssetScreenAddon)iGuiAddon;
                if (!assetGuiAddon.isBackground()) {
                    iGuiAddon.drawForegroundLayer(guiGraphics, (Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY, this.minecraft.getTimer().getGameTimeDeltaPartialTick(false));
                }
            } else {
                iGuiAddon.drawForegroundLayer(guiGraphics, (Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY, this.minecraft.getTimer().getGameTimeDeltaPartialTick(false));
            }
        });
        this.renderTooltip(guiGraphics, mouseX - this.xCenter, mouseY - this.yCenter);
        for (IScreenAddon iScreenAddon : this.addons) {
            if (!iScreenAddon.isMouseOver(mouseX - this.xCenter, mouseY - this.yCenter) || iScreenAddon.getTooltipLines().isEmpty()) continue;
            guiGraphics.renderComponentTooltip(this.font, iScreenAddon.getTooltipLines(), mouseX - this.xCenter, mouseY - this.yCenter);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.children() != null) {
            for (GuiEventListener listener : this.children()) {
                if (!(listener instanceof WidgetScreenAddon)) continue;
                WidgetScreenAddon addon = (WidgetScreenAddon)listener;
                AbstractWidget widget = addon.getWidget();
                if (widget.keyPressed(keyCode, scanCode, modifiers)) {
                    return true;
                }
                if (!widget.isFocused() || scanCode != 18) continue;
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void checkForMouseDrag(int mouseX, int mouseY) {
        int pressedButton = GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)0);
        if (pressedButton == 1) {
            if (!this.isMouseDragging) {
                this.isMouseDragging = true;
            } else {
                for (IScreenAddon iScreenAddon : this.addons) {
                    if (!iScreenAddon.isMouseOver(mouseX - this.xCenter, mouseY - this.yCenter)) continue;
                    iScreenAddon.mouseDragged(mouseX - this.xCenter, mouseY - this.yCenter, pressedButton, this.dragX, this.dragY);
                }
            }
            this.dragX = mouseX;
            this.dragY = mouseY;
        } else {
            this.isMouseDragging = false;
        }
    }

    public int getX() {
        return this.xCenter;
    }

    public int getY() {
        return this.yCenter;
    }

    @Nonnull
    public T getMenu() {
        return this.container;
    }

    public List<IScreenAddon> getAddons() {
        return this.addons;
    }

    public List<? extends GuiEventListener> children() {
        if (super.children() != null) {
            List collect = super.children().stream().map(guiEventListener -> guiEventListener).collect(Collectors.toList());
            collect.addAll(this.getAddons());
            return collect;
        }
        return new ArrayList();
    }

    public void setAddons(List<IScreenAddon> addons) {
        this.addons = addons;
    }

    public IAssetProvider getAssetProvider() {
        return this.assetProvider;
    }

    public void setAssetProvider(IAssetProvider assetProvider) {
        this.assetProvider = assetProvider;
    }

    public int getTitleColor() {
        T t = this.container;
        if (t instanceof BasicAddonContainer) {
            BasicAddonContainer addonContainer = (BasicAddonContainer)t;
            return addonContainer.getTitleColorFromProvider();
        }
        return 0xFFFFFF;
    }

    public float getTitleX(float xCenter) {
        T t = this.container;
        if (t instanceof BasicAddonContainer) {
            BasicAddonContainer addonContainer = (BasicAddonContainer)t;
            return addonContainer.getTitleXPos(this.font.width(this.title.getString()), this.width, this.height, this.imageWidth, this.imageHeight);
        }
        return xCenter / 2.0f + (float)(this.imageHeight / 2) - (float)(this.font.width(this.title.getString()) / 2);
    }

    public float getTitleY(float yCenter) {
        T t = this.container;
        if (t instanceof BasicAddonContainer) {
            BasicAddonContainer addonContainer = (BasicAddonContainer)t;
            return addonContainer.getTitleYPos(this.font.width(this.title.getString()), this.width, this.height, this.imageWidth, this.imageHeight);
        }
        return yCenter / 2.0f + 6.0f;
    }
}

