/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.redstone;

import com.hrznstudio.titanium.api.IEnumValues;
import com.hrznstudio.titanium.api.redstone.IRedstoneAction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class RedstoneManager<T extends IEnumValues<T> & IRedstoneAction>
implements INBTSerializable<CompoundTag> {
    private T action;
    private boolean lastRedstoneState;
    private boolean shouldWork;

    public RedstoneManager(T defaultValue, boolean lastRedstoneState) {
        this.action = defaultValue;
        this.lastRedstoneState = lastRedstoneState;
        this.shouldWork = true;
    }

    public T getAction() {
        return this.action;
    }

    public void setAction(T action) {
        this.action = action;
    }

    public boolean getLastRedstoneState() {
        return this.lastRedstoneState;
    }

    public void setLastRedstoneState(boolean lastRedstoneState) {
        if (!this.lastRedstoneState && lastRedstoneState) {
            this.shouldWork = true;
        }
        this.lastRedstoneState = lastRedstoneState;
    }

    public boolean shouldWork() {
        return !((IRedstoneAction)this.action).startsOnChange() || this.shouldWork;
    }

    public void finish() {
        this.shouldWork = false;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag value = new CompoundTag();
        value.putString("Name", ((IRedstoneAction)this.action).getName());
        value.putBoolean("LastState", this.lastRedstoneState);
        return value;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.action = (IEnumValues)this.action.getValue(nbt.getString("Name"));
        this.lastRedstoneState = nbt.getBoolean("LastState");
    }
}

