/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.world.ChunkCache;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public final class WorldHelper {
    public static final int DIMENSION_ID_OVERWORLD = 0;
    public static final int DIMENSION_ID_NETHER = -1;
    public static final int DIMENSION_ID_THEEND = 1;

    public static Optional<Level> getClientWorld() {
        return ZeroCore.getProxy().getClientWorld();
    }

    public static Optional<ServerLevel> getServerWorld(ResourceKey<Level> worldKey) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return null != server ? Optional.ofNullable(server.getLevel(worldKey)) : Optional.empty();
    }

    public static Stream<BlockPos> getNeighboringPositions(BlockPos origin) {
        return Stream.of(Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST).map(arg_0 -> ((BlockPos)origin).relative(arg_0));
    }

    public static BlockPos[] getNeighboringPositionsList(BlockPos origin, BlockPos[] storage) {
        for (int i = 0; i < CodeHelper.DIRECTIONS.length; ++i) {
            storage[i] = origin.relative(CodeHelper.DIRECTIONS[i]);
        }
        return storage;
    }

    public static Optional<BlockState> getBlockState(Level world, BlockPos position) {
        return world.isLoaded(position) ? Optional.of(world.getBlockState(position)) : Optional.empty();
    }

    public static Stream<BlockState> getBlockStatesFrom(Level world, Stream<BlockPos> positions) {
        return WorldHelper.getFromWorld(world, positions, WorldHelper::getBlockState);
    }

    public static Stream<Block> getBlocksFrom(Level world, Stream<BlockPos> positions) {
        return WorldHelper.getBlockStatesFrom(world, positions).map(BlockBehaviour.BlockStateBase::getBlock);
    }

    public static void notifyBlockUpdate(Level world, BlockPos position) {
        WorldHelper.notifyBlockUpdate(world, position, null, null);
    }

    public static void notifyBlockUpdate(Level world, BlockPos position, @Nullable BlockState oldState, @Nullable BlockState newState) {
        if (null == oldState) {
            oldState = world.getBlockState(position);
        }
        if (null == newState) {
            newState = oldState;
        }
        world.sendBlockUpdated(position, oldState, newState, 3);
    }

    public static void markBlockRangeForRenderUpdate(BlockPos min, BlockPos max) {
        ZeroCore.getProxy().markBlockRangeForRenderUpdate(min, max);
    }

    public static void notifyNeighborsOfStateChange(Level world, BlockPos pos, Block blockType) {
        world.updateNeighborsAt(pos, blockType);
    }

    @Nullable
    public static BlockEntity getLoadedTile(Level world, BlockPos position) {
        return world.isInWorldBounds(position) ? WorldHelper.getLoadedTile((LevelChunk)world.getChunk(position.getX() >> 4, position.getZ() >> 4, ChunkStatus.FULL, false), position) : null;
    }

    @Nullable
    public static BlockEntity getLoadedTile(ChunkCache chunkCache, BlockPos position) {
        return chunkCache.getWorld().isInWorldBounds(position) ? WorldHelper.getLoadedTile(chunkCache.get(position), position) : null;
    }

    @Nullable
    private static BlockEntity getLoadedTile(@Nullable LevelChunk chunk, BlockPos position) {
        return null != chunk ? chunk.getBlockEntity(position, LevelChunk.EntityCreationType.CHECK) : null;
    }

    public static Optional<BlockEntity> getTile(Level world, BlockPos position) {
        return world.getWorldBorder().isWithinBounds(position) ? Optional.ofNullable(WorldHelper.getLoadedTile(world, position)) : Optional.empty();
    }

    @Deprecated
    public static Optional<BlockEntity> getTile(BlockGetter world, BlockPos position) {
        if (world instanceof Level) {
            return Optional.ofNullable(WorldHelper.getLoadedTile((Level)world, position));
        }
        return Optional.ofNullable(world.getBlockEntity(position));
    }

    public static Optional<BlockEntity> getTile(Level world, BlockPos origin, Direction direction) {
        return WorldHelper.getTile(world, origin.relative(direction));
    }

    public static Optional<BlockEntity> getTile(BlockEntity origin, Direction direction) {
        Level world = origin.getLevel();
        return null != world ? WorldHelper.getTile(world, origin.getBlockPos().relative(direction)) : Optional.empty();
    }

    public static Stream<BlockEntity> getTilesFrom(Level world, Stream<BlockPos> positions) {
        return WorldHelper.getFromWorld(world, positions, WorldHelper::getTile);
    }

    public static <Controller extends IMultiblockController<Controller>> Optional<IMultiblockPart<Controller>> getMultiblockPartFrom(Level world, BlockPos position) {
        return WorldHelper.getTile(world, position).filter(te -> te instanceof IMultiblockPart).map(te -> (IMultiblockPart)te);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends BlockEntity> Optional<T> getClientTile(BlockPos position) {
        return WorldHelper.getClientWorld().map(w -> WorldHelper.getLoadedTile(w, position));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends BlockEntity> Optional<T> getClientTile(BlockPos position, Direction direction) {
        return WorldHelper.getClientTile(position.relative(direction));
    }

    public static int getChunkXFromBlock(int blockX) {
        return blockX >> 4;
    }

    public static int getChunkXFromBlock(BlockPos position) {
        return position.getX() >> 4;
    }

    public static int getChunkZFromBlock(int blockZ) {
        return blockZ >> 4;
    }

    public static int getChunkZFromBlock(BlockPos position) {
        return position.getZ() >> 4;
    }

    public static long getChunkXZHashFromBlock(int blockX, int blockZ) {
        return ChunkPos.asLong((int)WorldHelper.getChunkXFromBlock(blockX), (int)WorldHelper.getChunkZFromBlock(blockZ));
    }

    public static long getChunkXZHashFromBlock(BlockPos position) {
        return ChunkPos.asLong((int)WorldHelper.getChunkXFromBlock(position), (int)WorldHelper.getChunkZFromBlock(position));
    }

    public static boolean chunkExists(Level world, BlockPos position) {
        return world.hasChunk(WorldHelper.getChunkXFromBlock(position), WorldHelper.getChunkZFromBlock(position));
    }

    public static boolean isEntityInRange(Entity entity, double x, double y, double z, double range) {
        return entity.distanceToSqr(x + 0.5, y + 0.5, z + 0.5) < range * range;
    }

    public static boolean isEntityInRange(Entity entity, BlockPos position, double range) {
        return entity.distanceToSqr((double)position.getX() + 0.5, (double)position.getY() + 0.5, (double)position.getZ() + 0.5) < range * range;
    }

    public static <T extends ParticleOptions> void spawnVanillaParticles(Level world, T particle, int minCount, int maxCount, int x, int y, int z, int offsetX, int offsetY, int offsetZ) {
        RandomSource rand = world.random;
        int howMany = Mth.nextInt((RandomSource)rand, (int)minCount, (int)maxCount);
        double px1 = (double)(x - offsetX) + 0.5;
        double px2 = (double)(x + offsetX) + 0.5;
        double py1 = y;
        double py2 = y + offsetY;
        double pz1 = (double)(z - offsetZ) + 0.5;
        double pz2 = (double)(z + offsetZ) + 0.5;
        if (world instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)world;
            double motionX = rand.nextGaussian() * 0.02;
            double motionY = rand.nextGaussian() * 0.02;
            double motionZ = rand.nextGaussian() * 0.02;
            double pX = Mth.nextDouble((RandomSource)rand, (double)px1, (double)px2);
            double pY = Mth.nextDouble((RandomSource)rand, (double)py1, (double)py2);
            double pZ = Mth.nextDouble((RandomSource)rand, (double)pz1, (double)pz2);
            ws.sendParticles(particle, pX, pY, pZ, howMany, motionX, motionY, motionZ, rand.nextGaussian() * 0.02);
        } else {
            for (int i = 0; i < howMany; ++i) {
                double motionX = rand.nextGaussian() * 0.02;
                double motionY = rand.nextGaussian() * 0.02;
                double motionZ = rand.nextGaussian() * 0.02;
                double pX = Mth.nextDouble((RandomSource)rand, (double)px1, (double)px2);
                double pY = Mth.nextDouble((RandomSource)rand, (double)py1, (double)py2);
                double pZ = Mth.nextDouble((RandomSource)rand, (double)pz1, (double)pz2);
                world.addParticle(particle, pX, pY, pZ, motionX, motionY, motionZ);
            }
        }
    }

    public static void spawnItemStack(ItemStack stack, Level world, double x, double y, double z, boolean withMomentum) {
        float z2;
        float y2;
        float x2;
        if (withMomentum) {
            x2 = world.random.nextFloat() * 0.8f + 0.1f;
            y2 = world.random.nextFloat() * 0.8f + 0.1f;
            z2 = world.random.nextFloat() * 0.8f + 0.1f;
        } else {
            x2 = 0.5f;
            y2 = 0.0f;
            z2 = 0.5f;
        }
        ItemEntity entity = new ItemEntity(world, x + (double)x2, y + (double)y2, z + (double)z2, stack.copy());
        if (withMomentum) {
            entity.setDeltaMovement(world.random.nextGaussian() * (double)0.05f, world.random.nextGaussian() * (double)0.05f + (double)0.2f, world.random.nextGaussian() * (double)0.05f);
        } else {
            entity.setDeltaMovement(0.0, (double)-0.05f, 0.0);
        }
        world.addFreshEntity((Entity)entity);
    }

    public static boolean isFluidStateTagged(BlockGetter access, BlockPos position, TagKey<Fluid> tag) {
        return access.getFluidState(position).is(tag);
    }

    public static boolean isFluidStateTagged(BlockState blockState, TagKey<Fluid> tag) {
        return blockState.getFluidState().is(tag);
    }

    private static <T> Stream<T> getFromWorld(Level world, Stream<BlockPos> positions, BiFunction<Level, BlockPos, Optional<T>> getter) {
        return positions.map(position -> (Optional)getter.apply(world, (BlockPos)position)).filter(Optional::isPresent).map(Optional::get);
    }

    private WorldHelper() {
    }
}

