/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="zerocore", bus=EventBusSubscriber.Bus.GAME)
public class ChunkCache {
    private static final Map<LevelAccessor, ChunkCache> s_caches = new Reference2ObjectArrayMap(16);
    private final Long2ObjectMap<LevelChunk> _chunks;
    private final Level _world;

    @Nullable
    public static ChunkCache get(Level world) {
        return s_caches.get(world);
    }

    public static ChunkCache getOrCreate(Level world) {
        return s_caches.computeIfAbsent((LevelAccessor)world, w -> new ChunkCache(Objects.requireNonNull(world)));
    }

    @Nullable
    public LevelChunk get(BlockPos position) {
        int chunkZ;
        if (!this._world.isInWorldBounds(position)) {
            return null;
        }
        int chunkX = position.getX() >> 4;
        long chunkHash = ChunkPos.asLong((int)chunkX, (int)(chunkZ = position.getZ() >> 4));
        LevelChunk chunk = (LevelChunk)this._chunks.get(chunkHash);
        if (null == chunk && null != (chunk = (LevelChunk)this._world.getChunk(chunkX, chunkZ, ChunkStatus.FULL, false))) {
            this._chunks.put(chunkHash, (Object)chunk);
        }
        return chunk;
    }

    public void remove(LevelChunk chunk) {
        this._chunks.remove(chunk.getPos().toLong());
    }

    public void clear() {
        this._chunks.clear();
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ChunkAccess chunk = Objects.requireNonNull(event.getChunk());
        Level world = chunk.getLevel();
        if (chunk instanceof LevelChunk) {
            ChunkCache cache;
            LevelChunk levelChunk = (LevelChunk)chunk;
            if (null != world && null != (cache = s_caches.get(world))) {
                cache.remove(levelChunk);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor world = Objects.requireNonNull(event.getLevel());
        ChunkCache cache = s_caches.get(world);
        if (null != cache) {
            cache.clear();
            s_caches.remove(world);
        }
    }

    public Level getWorld() {
        return this._world;
    }

    private ChunkCache(Level world) {
        this._world = Objects.requireNonNull(world);
        this._chunks = new Long2ObjectOpenHashMap(2048, 0.75f);
    }
}

