/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.geometry.CuboidBoundingBox;
import it.zerono.mods.zerocore.lib.data.nbt.INestedSyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.multiblock.AssemblyState;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockRegistry;
import it.zerono.mods.zerocore.lib.multiblock.ReferencePartTracker;
import it.zerono.mods.zerocore.lib.multiblock.registry.MultiblockRegistry;
import it.zerono.mods.zerocore.lib.multiblock.storage.EmptyPartStorage;
import it.zerono.mods.zerocore.lib.multiblock.storage.IPartStorage;
import it.zerono.mods.zerocore.lib.multiblock.storage.PartStorage;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.lib.network.INetworkTileEntitySyncProvider;
import it.zerono.mods.zerocore.lib.network.NetworkTileEntitySyncProvider;
import it.zerono.mods.zerocore.lib.world.ChunkCache;
import it.zerono.mods.zerocore.lib.world.NeighboringPositions;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public abstract class AbstractMultiblockController<Controller extends AbstractMultiblockController<Controller>>
implements IMultiblockController<Controller>,
IMultiblockValidator,
INestedSyncableEntity,
INetworkTileEntitySyncProvider {
    public final IEvent<Runnable> DataUpdated;
    protected IPartStorage<Controller> _connectedParts;
    protected IPartStorage<Controller> _detachedParts;
    private final AssemblyState _assemblyState = new AssemblyState();
    private final Level _world;
    private final ReferencePartTracker<Controller> _reference;
    private CuboidBoundingBox _boundingBox;
    protected boolean _shouldCheckForDisconnections;
    private ValidationError _lastValidationError;
    private final INetworkTileEntitySyncProvider _syncProvider;
    private boolean _requestDataUpdateNotification;
    private boolean _needBuildingBoxRebuild;

    @Override
    public void syncFromSaveDelegate(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        this.syncDataFrom(data, registries, syncReason);
        this.requestDataUpdateNotification();
    }

    @Override
    public boolean isEmpty() {
        return this._connectedParts.isEmpty();
    }

    @Override
    public int getPartsCount() {
        return this._connectedParts.size();
    }

    @Override
    public boolean containsPart(IMultiblockPart<Controller> part) {
        return this.isPartCompatible(part) && this._connectedParts.contains(part);
    }

    @Override
    public boolean containsPartsAt(NeighboringPositions positions) {
        return this._connectedParts.contains(positions);
    }

    @Override
    public boolean containsPartsAt(BlockPos[] positions) {
        return this._connectedParts.contains(positions);
    }

    @Override
    public void attachPart(IMultiblockPart<Controller> part) {
        Controller mySelf = this.castSelf();
        this._connectedParts.addOrReplace(part);
        part.onAttached(mySelf);
        this.partAdded(part);
        if (part.hasMultiblockSaveData()) {
            part.forMultiblockSaveData(data -> {
                this.syncFromSaveDelegate((CompoundTag)data, (HolderLookup.Provider)this.getWorld().registryAccess(), ISyncableEntity.SyncReason.FullSync);
                part.onMultiblockDataAssimilated();
            });
        }
        this.getReferenceTracker().accept(part);
        this.getRegistry().addDirtyController(mySelf);
        this.callOnLogicalClient(CodeHelper::clearErrorReport);
    }

    @Override
    public void detachPart(IMultiblockPart<Controller> part, boolean chunkUnloading) {
        Controller mySelf = this.castSelf();
        if (chunkUnloading && this._assemblyState.isAssembled()) {
            this._assemblyState.setPaused();
            this.clearDataUpdatedSubscribers();
            this.onMachinePaused();
        }
        this.onDetachPart(part);
        this._connectedParts.remove(part);
        if (this._connectedParts.isEmpty()) {
            this._boundingBox = CuboidBoundingBox.EMPTY;
            this.getRegistry().addDeadController(mySelf);
            return;
        }
        this._needBuildingBoxRebuild = true;
        if (null == this._detachedParts) {
            this._detachedParts = this.createPartStorage();
        }
        this._detachedParts.addOrReplace(part);
        this.getRegistry().addDirtyController(mySelf);
        this.callOnLogicalClient(CodeHelper::clearErrorReport);
    }

    @Override
    public IPartStorage<Controller> detachAll() {
        IPartStorage<Controller> detachedParts = this._connectedParts;
        this._connectedParts.forEach(this::onDetachPart, part -> this.getWorld().hasChunkAt(part.getWorldPosition()));
        this._connectedParts = this.createPartStorage();
        this._boundingBox = CuboidBoundingBox.EMPTY;
        return detachedParts;
    }

    @Override
    public void assimilateController(Controller other) {
        if (!this.isControllerCompatible(other)) {
            return;
        }
        if (this.compareTo(other) >= 0) {
            throw new IllegalArgumentException("The controller with the lowest minimum-coord value must consume the one with the higher coords");
        }
        IPartStorage<Controller> otherParts = ((AbstractMultiblockController)other)._connectedParts;
        int otherPartsCount = otherParts.size();
        if (1 == otherPartsCount) {
            IMultiblockPart<Controller> acquiredPart2 = Objects.requireNonNull(otherParts.getFirst());
            ((AbstractMultiblockController)other).prepareAssimilation(this);
            this._connectedParts.addOrReplace(acquiredPart2);
            acquiredPart2.onAssimilated(this.castSelf());
            this.partAdded(acquiredPart2);
        } else {
            Controller mySelf = this.castSelf();
            boolean export = this._connectedParts.size() < otherPartsCount;
            ((AbstractMultiblockController)other).prepareAssimilation(this);
            otherParts.forEachValidPart(acquiredPart -> {
                acquiredPart.onAssimilated(mySelf);
                this.partAdded((IMultiblockPart<Controller>)acquiredPart);
            });
            if (export) {
                otherParts.addAll(this._connectedParts);
                this._connectedParts = otherParts;
            } else {
                this._connectedParts.addAll(otherParts);
            }
        }
        this.onAssimilate((IMultiblockController<Controller>)other);
        ((AbstractMultiblockController)other).onAssimilated(this);
    }

    @Override
    public boolean shouldConsumeController(Controller other) {
        if (!this.isControllerCompatible(other)) {
            throw new IllegalArgumentException("Attempting to merge two multiblocks with different master classes - this should never happen!");
        }
        if (this == other) {
            return false;
        }
        int res = this.compareTo(other);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        Log.LOGGER.warn(Log.MULTIBLOCK, "[{}] Encountered two controllers with the same reference coordinate. Auditing connected parts and retrying.", (Object)CodeHelper.getWorldSideName(this.getWorld()));
        ChunkCache chunkCache = ChunkCache.getOrCreate(this.getWorld());
        this.auditParts(chunkCache);
        ((AbstractMultiblockController)other).auditParts(chunkCache);
        chunkCache.clear();
        res = this.compareTo(other);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        Log.LOGGER.error(Log.MULTIBLOCK, "My Controller ({}): size ({})", (Object)this.hashCode(), (Object)this.getPartsCount());
        Log.LOGGER.error(Log.MULTIBLOCK, "Other Controller ({}): size ({})", (Object)other.hashCode(), (Object)((AbstractMultiblockController)other).getPartsCount());
        throw new IllegalArgumentException("[" + CodeHelper.getWorldSideName(this.getWorld()) + "] Two controllers with the same reference coord that somehow both have valid parts - this should never happen!");
    }

    @Override
    public IPartStorage<Controller> checkForDisconnections() {
        if (!this._shouldCheckForDisconnections || null == this._detachedParts || this._detachedParts.isEmpty()) {
            return EmptyPartStorage.getInstance();
        }
        ReferencePartTracker reference = this.getReferenceTracker();
        reference.invalidate();
        this._connectedParts.forEach(part -> {
            part.setUnvisited();
            reference.accept((IMultiblockPart)part);
        });
        Controller mySelf = this.castSelf();
        if (reference.isInvalid() || this.isEmpty()) {
            this._shouldCheckForDisconnections = false;
            this.getRegistry().addDeadController(mySelf);
            return EmptyPartStorage.getInstance();
        }
        this._detachedParts = null;
        this.visitAllLoadedParts();
        IPartStorage<Controller> removedParts = this.createPartStorage();
        ObjectArrayList deadParts = new ObjectArrayList(1024);
        this._connectedParts.forEachNotVisitedPart(arg_0 -> this.lambda$checkForDisconnections$4((List)deadParts, mySelf, removedParts, arg_0));
        if (!deadParts.isEmpty()) {
            this._connectedParts.removeAll((Collection<IMultiblockPart<Controller>>)deadParts);
            this._needBuildingBoxRebuild = true;
        }
        this._shouldCheckForDisconnections = false;
        return removedParts;
    }

    @Override
    public Runnable listenForDataUpdate(Runnable handler) {
        this.DataUpdated.subscribe(handler);
        return handler;
    }

    @Override
    public void unlistenForDataUpdate(Runnable handler) {
        this.DataUpdated.unsubscribe(handler);
    }

    @Override
    public void checkIfMachineIsWhole() {
        this._lastValidationError = null;
        if (this.isMachineWhole(this)) {
            this.assembleMachine(this._assemblyState.isPaused());
        } else if (this._assemblyState.isAssembled()) {
            this.disassembleMachine();
        }
        this._detachedParts = null;
        this.callOnLogicalClient(CodeHelper::clearErrorReport);
    }

    @Override
    public boolean isAssembled() {
        return this._assemblyState.isAssembled();
    }

    @Override
    public boolean isDisassembled() {
        return this._assemblyState.isDisassembled();
    }

    @Override
    public boolean isPaused() {
        return this._assemblyState.isPaused();
    }

    @Override
    public final void updateMultiblockEntity() {
        if (this.isEmpty()) {
            this.getRegistry().addDeadController(this.castSelf());
            return;
        }
        if (!this.isAssembled()) {
            return;
        }
        if (this.calledByLogicalClient()) {
            this.updateClient();
            if (this._requestDataUpdateNotification) {
                this.raiseDataUpdated();
            }
        } else if (this.updateServer()) {
            this.raiseDataUpdated();
            Level myWorld = this.getWorld();
            BlockPos min = this._boundingBox.getMin();
            BlockPos max = this._boundingBox.getMax();
            if (myWorld.hasChunksAt(min.getX(), min.getY(), min.getZ(), max.getX(), max.getY(), max.getZ())) {
                int minChunkX = WorldHelper.getChunkXFromBlock(min);
                int minChunkZ = WorldHelper.getChunkZFromBlock(min);
                int maxChunkX = WorldHelper.getChunkXFromBlock(max);
                int maxChunkZ = WorldHelper.getChunkZFromBlock(max);
                for (int x = minChunkX; x <= maxChunkX; ++x) {
                    for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                        myWorld.getChunk(x, z).setUnsaved(true);
                    }
                }
            }
        }
    }

    @Override
    public Optional<BlockPos> getReferenceCoord() {
        return this.getReferenceTracker().getPosition();
    }

    @Override
    public Level getWorld() {
        return this._world;
    }

    @Override
    public void recalculateCoords() {
        if (this._needBuildingBoxRebuild) {
            this._boundingBox = this.isEmpty() ? CuboidBoundingBox.EMPTY : this.buildBoundingBox();
            this._needBuildingBoxRebuild = false;
        }
    }

    @Override
    @Deprecated
    public Optional<BlockPos> getMinimumCoord() {
        return Optional.of(this._boundingBox.getMin());
    }

    @Override
    public CuboidBoundingBox getBoundingBox() {
        return this._boundingBox;
    }

    @Override
    @Deprecated
    public <T> T mapBoundingBoxCoordinates(BiFunction<BlockPos, BlockPos, T> minMaxCoordMapper, T defaultValue) {
        return minMaxCoordMapper.apply(this._boundingBox.getMin(), this._boundingBox.getMax());
    }

    @Override
    @Deprecated
    public <T> T mapBoundingBoxCoordinates(BiFunction<BlockPos, BlockPos, T> minMaxCoordMapper, T defaultValue, Function<BlockPos, BlockPos> minRemapper, Function<BlockPos, BlockPos> maxRemapper) {
        return minMaxCoordMapper.apply(minRemapper.apply(this._boundingBox.getMin()), maxRemapper.apply(this._boundingBox.getMax()));
    }

    @Override
    @Deprecated
    public void forBoundingBoxCoordinates(BiConsumer<BlockPos, BlockPos> minMaxCoordConsumer) {
        minMaxCoordConsumer.accept(this._boundingBox.getMin(), this._boundingBox.getMax());
    }

    @Override
    @Deprecated
    public void forBoundingBoxCoordinates(BiConsumer<BlockPos, BlockPos> minMaxCoordConsumer, Function<BlockPos, BlockPos> minRemapper, Function<BlockPos, BlockPos> maxRemapper) {
        minMaxCoordConsumer.accept(minRemapper.apply(this._boundingBox.getMin()), minRemapper.apply(this._boundingBox.getMax()));
    }

    @Override
    public void forceStructureUpdate(Level world) {
    }

    @Override
    public int compareTo(Controller other) {
        int sizeCmp = Integer.compare(((AbstractMultiblockController)other).getPartsCount(), this.getPartsCount());
        return 0 != sizeCmp ? sizeCmp : this.getReferenceTracker().compareTo(((AbstractMultiblockController)other).getReferenceTracker());
    }

    @Override
    public boolean hasLastError() {
        return null != this._lastValidationError;
    }

    @Override
    public boolean isLastErrorEmpty() {
        return null == this._lastValidationError;
    }

    @Override
    public Optional<ValidationError> getLastError() {
        return Optional.ofNullable(this._lastValidationError);
    }

    @Override
    public void setLastError(ValidationError error) {
        this._lastValidationError = error;
    }

    @Override
    public void setLastError(String messageFormatStringResourceKey, Object ... messageParameters) {
        this._lastValidationError = new ValidationError(null, messageFormatStringResourceKey, messageParameters);
    }

    @Override
    public void setLastError(BlockPos position, String messageFormatStringResourceKey, Object ... messageParameters) {
        this._lastValidationError = new ValidationError(position, messageFormatStringResourceKey, messageParameters);
    }

    @Override
    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        this.requestDataUpdateNotification();
    }

    @Override
    public Optional<ISyncableEntity> getNestedSyncableEntity() {
        return Optional.of(this);
    }

    @Override
    public void enlistForUpdates(ServerPlayer player, boolean updateNow) {
        this._syncProvider.enlistForUpdates(player, updateNow && this.calledByLogicalServer());
    }

    @Override
    public void delistFromUpdates(ServerPlayer player) {
        this._syncProvider.delistFromUpdates(player);
    }

    @Override
    public void sendUpdates() {
        this.callOnLogicalServer(this._syncProvider::sendUpdates);
    }

    public String toString() {
        return String.format("%d parts", this._connectedParts.size());
    }

    protected AbstractMultiblockController(Level world) {
        this._connectedParts = this.createPartStorage();
        this._world = world;
        this._lastValidationError = null;
        this._reference = new ReferencePartTracker();
        this._boundingBox = CuboidBoundingBox.EMPTY;
        this._shouldCheckForDisconnections = false;
        this._syncProvider = NetworkTileEntitySyncProvider.create(this._world, () -> this.getReferenceCoord().orElseGet(() -> new BlockPos(0, 0, 0)), this);
        this._requestDataUpdateNotification = false;
        this._needBuildingBoxRebuild = false;
        this.DataUpdated = new Event<Runnable>();
    }

    protected abstract void onPartAdded(IMultiblockPart<Controller> var1);

    protected abstract void onPartRemoved(IMultiblockPart<Controller> var1);

    protected void onMachineAssembled() {
        if (CodeHelper.isDevEnv()) {
            Log.LOGGER.info(Log.MULTIBLOCK, "Multiblock assembled at {}", (Object)System.nanoTime());
        }
    }

    protected abstract void onMachineRestored();

    protected abstract void onMachinePaused();

    protected abstract void onMachineDisassembled();

    protected abstract int getMinimumNumberOfPartsForAssembledMachine();

    protected abstract int getMaximumXSize();

    protected abstract int getMaximumZSize();

    protected abstract int getMaximumYSize();

    protected int getMinimumXSize() {
        return 1;
    }

    protected int getMinimumYSize() {
        return 1;
    }

    protected int getMinimumZSize() {
        return 1;
    }

    protected abstract boolean isMachineWhole(IMultiblockValidator var1);

    protected abstract void onAssimilate(IMultiblockController<Controller> var1);

    protected abstract void onAssimilated(IMultiblockController<Controller> var1);

    protected abstract boolean updateServer();

    protected abstract void updateClient();

    protected abstract boolean isBlockGoodForFrame(Level var1, int var2, int var3, int var4, IMultiblockValidator var5);

    protected abstract boolean isBlockGoodForTop(Level var1, int var2, int var3, int var4, IMultiblockValidator var5);

    protected abstract boolean isBlockGoodForBottom(Level var1, int var2, int var3, int var4, IMultiblockValidator var5);

    protected abstract boolean isBlockGoodForSides(Level var1, int var2, int var3, int var4, IMultiblockValidator var5);

    protected abstract boolean isBlockGoodForInterior(Level var1, int var2, int var3, int var4, IMultiblockValidator var5);

    protected void markReferenceCoordForUpdate() {
        this.getReferenceCoord().ifPresent(pos -> WorldHelper.notifyBlockUpdate(this.getWorld(), pos));
    }

    protected void markReferenceCoordDirty() {
        this.callOnLogicalServer(() -> this.getReferenceTracker().consume((part, position) -> {
            this.getWorld().blockEntityChanged(position);
            WorldHelper.notifyBlockUpdate(this.getWorld(), position);
        }));
    }

    protected CuboidBoundingBox buildBoundingBox() {
        return this._connectedParts.boundingBox();
    }

    protected Controller castSelf() {
        return (Controller)this;
    }

    protected IPartStorage<Controller> createPartStorage() {
        return new PartStorage();
    }

    protected Collection<IMultiblockPart<Controller>> getConnectedParts() {
        return this._connectedParts.unmodifiable();
    }

    protected Stream<IMultiblockPart<Controller>> getConnectedParts(Predicate<IMultiblockPart<Controller>> test) {
        return this.getConnectedParts().stream().filter(test);
    }

    protected void forEachConnectedParts(Consumer<IMultiblockPart<Controller>> action) {
        this._connectedParts.forEach(action);
    }

    protected int getPartsCount(Predicate<IMultiblockPart<Controller>> test) {
        return (int)this._connectedParts.stream().filter(test).count();
    }

    protected boolean isAnyPartConnected(Predicate<IMultiblockPart<Controller>> test) {
        return this._connectedParts.stream().anyMatch(test);
    }

    protected NeighboringPositions getNeighboringPositionsToVisit() {
        return new NeighboringPositions();
    }

    protected void visitAllLoadedParts() {
        if (this._connectedParts.size() < 65536) {
            this.visitLoadedNeighboringParts(Objects.requireNonNull(this.getReferenceTracker().get()));
            return;
        }
        IMultiblockPart<Controller> firstPart = Objects.requireNonNull(this.getReferenceTracker().get());
        NeighboringPositions positions = this.getNeighboringPositionsToVisit();
        ReferenceArrayList nearbyParts = new ReferenceArrayList(positions.size());
        firstPart.setVisited();
        positions.setTo(firstPart.getWorldPosition());
        this._connectedParts.get(positions, (List<IMultiblockPart<Controller>>)nearbyParts);
        nearbyParts.parallelStream().forEach(this::visitLoadedNeighboringParts);
    }

    protected void visitLoadedNeighboringParts(IMultiblockPart<Controller> firstPart) {
        LinkedList partsToCheck = Lists.newLinkedList();
        NeighboringPositions positions = this.getNeighboringPositionsToVisit();
        ReferenceArrayList nearbyParts = new ReferenceArrayList(positions.size());
        partsToCheck.add(firstPart);
        do {
            IMultiblockPart part = (IMultiblockPart)partsToCheck.removeFirst();
            part.setVisited();
            positions.setTo(part.getWorldPosition());
            this._connectedParts.get(positions, (List<IMultiblockPart<Controller>>)nearbyParts);
            for (IMultiblockPart nearbyPart : nearbyParts) {
                if (!nearbyPart.isNotVisited()) continue;
                nearbyPart.setVisited();
                partsToCheck.add(nearbyPart);
            }
            nearbyParts.clear();
        } while (!partsToCheck.isEmpty());
    }

    protected ReferencePartTracker<Controller> getReferenceTracker() {
        if (this._reference.isInvalid()) {
            this._reference.accept(this._connectedParts);
        }
        return this._reference;
    }

    public boolean calledByLogicalServer() {
        return !this._world.isClientSide;
    }

    public boolean calledByLogicalClient() {
        return this._world.isClientSide;
    }

    public void callOnLogicalSide(Runnable serverCode, Runnable clientCode) {
        CodeHelper.callOnLogicalSide(this._world, serverCode, clientCode);
    }

    public <T> T callOnLogicalSide(Supplier<T> serverCode, Supplier<T> clientCode) {
        return CodeHelper.callOnLogicalSide(this._world, serverCode, clientCode);
    }

    public boolean callOnLogicalSide(BooleanSupplier serverCode, BooleanSupplier clientCode) {
        return CodeHelper.callOnLogicalSide(this._world, serverCode, clientCode);
    }

    public int callOnLogicalSide(IntSupplier serverCode, IntSupplier clientCode) {
        return CodeHelper.callOnLogicalSide(this._world, serverCode, clientCode);
    }

    public long callOnLogicalSide(LongSupplier serverCode, LongSupplier clientCode) {
        return CodeHelper.callOnLogicalSide(this._world, serverCode, clientCode);
    }

    public double callOnLogicalSide(DoubleSupplier serverCode, DoubleSupplier clientCode) {
        return CodeHelper.callOnLogicalSide(this._world, serverCode, clientCode);
    }

    public void callOnLogicalServer(Runnable code) {
        CodeHelper.callOnLogicalServer(this._world, code);
    }

    public <T> T callOnLogicalServer(Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        return CodeHelper.callOnLogicalServer(this._world, code, invalidSideReturnValue);
    }

    public boolean callOnLogicalServer(BooleanSupplier code) {
        return CodeHelper.callOnLogicalServer(this._world, code);
    }

    public int callOnLogicalServer(IntSupplier code, int invalidSideReturnValue) {
        return CodeHelper.callOnLogicalServer(this._world, code, invalidSideReturnValue);
    }

    public long callOnLogicalServer(LongSupplier code, long invalidSideReturnValue) {
        return CodeHelper.callOnLogicalServer(this._world, code, invalidSideReturnValue);
    }

    public double callOnLogicalServer(DoubleSupplier code, double invalidSideReturnValue) {
        return CodeHelper.callOnLogicalServer(this._world, code, invalidSideReturnValue);
    }

    public void callOnLogicalClient(Runnable code) {
        CodeHelper.callOnLogicalClient(this._world, code);
    }

    public <T> T callOnLogicalClient(Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        return CodeHelper.callOnLogicalClient(this._world, code, invalidSideReturnValue);
    }

    public boolean callOnLogicalClient(BooleanSupplier code) {
        return CodeHelper.callOnLogicalClient(this._world, code);
    }

    public int callOnLogicalClient(IntSupplier code, int invalidSideReturnValue) {
        return CodeHelper.callOnLogicalClient(this._world, code, invalidSideReturnValue);
    }

    public long callOnLogicalClient(LongSupplier code, long invalidSideReturnValue) {
        return CodeHelper.callOnLogicalClient(this._world, code, invalidSideReturnValue);
    }

    public double callOnLogicalClient(DoubleSupplier code, double invalidSideReturnValue) {
        return CodeHelper.callOnLogicalClient(this._world, code, invalidSideReturnValue);
    }

    private void partAdded(IMultiblockPart<Controller> newPart) {
        this._boundingBox = this._boundingBox.add(newPart.getWorldPosition());
        this.onPartAdded(newPart);
    }

    private void assembleMachine(boolean currentlyPaused) {
        Object mySelf = this.castSelf();
        this._connectedParts.forEach(part -> part.onPreMachineAssembled(mySelf));
        this._assemblyState.setAssembled();
        this.clearDataUpdatedSubscribers();
        if (currentlyPaused) {
            this.onMachineRestored();
        } else {
            this.onMachineAssembled();
        }
        this._connectedParts.forEach(part -> part.onPostMachineAssembled(mySelf));
    }

    private void disassembleMachine() {
        this._connectedParts.forEach(IMultiblockPart::onPreMachineBroken);
        this._assemblyState.setDisassembled();
        this.clearDataUpdatedSubscribers();
        this.onMachineDisassembled();
        this._connectedParts.forEach(IMultiblockPart::onPostMachineBroken);
    }

    private void onDetachPart(IMultiblockPart<Controller> part) {
        part.onDetached(this.castSelf());
        this.onPartRemoved(part);
        part.forfeitMultiblockSaveDelegate();
        this._boundingBox = CuboidBoundingBox.EMPTY;
        if (this._reference.test(part)) {
            this._reference.invalidate();
        }
        this._shouldCheckForDisconnections = true;
    }

    protected void prepareAssimilation(IMultiblockController<Controller> otherController) {
        ReferencePartTracker<Controller> reference = this.getReferenceTracker();
        reference.forfeitSaveDelegate();
        reference.invalidate();
        this._connectedParts = this.createPartStorage();
    }

    protected void auditParts(ChunkCache chunkCache) {
        ReferenceOpenHashSet deadParts = new ReferenceOpenHashSet(Math.min(64, this._connectedParts.size()));
        for (IMultiblockPart iMultiblockPart : this._connectedParts) {
            if (!iMultiblockPart.isPartInvalid() && iMultiblockPart == WorldHelper.getLoadedTile(chunkCache, iMultiblockPart.getWorldPosition())) continue;
            this.onDetachPart(iMultiblockPart);
            deadParts.add(iMultiblockPart);
        }
        this._connectedParts.removeAll((Collection<IMultiblockPart<Controller>>)deadParts);
        Log.LOGGER.warn(Log.MULTIBLOCK, "[{}] Controller found {} dead parts during an audit, {} parts remain attached", (Object)CodeHelper.getWorldSideName(this.getWorld()), (Object)deadParts.size(), (Object)this.getPartsCount());
    }

    protected void markMultiblockForRenderUpdate() {
        this.forBoundingBoxCoordinates(WorldHelper::markBlockRangeForRenderUpdate);
    }

    private IMultiblockRegistry<Controller> getRegistry() {
        return (IMultiblockRegistry)MultiblockRegistry.INSTANCE.get();
    }

    private void requestDataUpdateNotification() {
        this._requestDataUpdateNotification = true;
    }

    private void raiseDataUpdated() {
        this.DataUpdated.raise(Runnable::run);
        this._requestDataUpdateNotification = false;
    }

    private void clearDataUpdatedSubscribers() {
        this.DataUpdated.unsubscribeAll();
    }

    private /* synthetic */ void lambda$checkForDisconnections$4(List deadParts, AbstractMultiblockController mySelf, IPartStorage removedParts, IMultiblockPart orphanCandidate) {
        deadParts.add(orphanCandidate);
        orphanCandidate.onOrphaned(mySelf, 0, 0);
        this.onDetachPart(orphanCandidate);
        removedParts.addOrReplace(orphanCandidate);
    }
}

