/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.stack;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.stack.IStackAdapter;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.ObjIntConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public abstract class AbstractStackHolder<Holder extends AbstractStackHolder<Holder, Stack>, Stack>
implements IStackHolder<Holder, Stack> {
    private final BiPredicate<Integer, Stack> _stackValidator;
    private ObjIntConsumer<IStackHolder.ChangeType> _onChangeListener;
    private Runnable _onLoadListener;
    private Int2IntFunction _maxCapacityProvider;

    protected AbstractStackHolder() {
        this(AbstractStackHolder::defaultValidator);
    }

    protected AbstractStackHolder(BiPredicate<Integer, Stack> stackValidator) {
        Preconditions.checkNotNull(stackValidator, (Object)"Stack validator must not be null");
        this._stackValidator = stackValidator;
        this._onChangeListener = (change, index) -> {};
        this._onLoadListener = CodeHelper.VOID_RUNNABLE;
        this._maxCapacityProvider = $ -> 0;
    }

    protected void onLoad() {
        this._onLoadListener.run();
    }

    protected void onChange(IStackHolder.ChangeType change, int index) {
        this._onChangeListener.accept(change, index);
    }

    protected <StackType, ContentType> void syncFrom(CompoundTag data, HolderLookup.Provider registries, IStackAdapter<StackType, ContentType> adapter, Int2ObjectFunction<List<StackType>> itemsListSupplier) {
        List stacks = (List)itemsListSupplier.get(data.getInt("Size"));
        ListTag tagList = data.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            int slot = itemTags.getInt("Slot");
            if (slot < 0 || slot >= stacks.size()) continue;
            stacks.set(slot, adapter.deserialize(registries, (Tag)itemTags));
        }
        this.onLoad();
    }

    protected <StackType, ContentType> CompoundTag syncTo(CompoundTag data, HolderLookup.Provider registries, List<StackType> items, IStackAdapter<StackType, ContentType> adapter) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < items.size(); ++i) {
            if (adapter.isEmpty(items.get(i))) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            adapter.serialize(registries, items.get(i), (Tag)itemTag);
            nbtTagList.add((Object)itemTag);
        }
        data.put("Items", (Tag)nbtTagList);
        data.putInt("Size", items.size());
        return data;
    }

    @Override
    public boolean isStackValid(int index, Stack stack) {
        return this._stackValidator.test(index, stack);
    }

    @Override
    public Holder setOnContentsChangedListener(ObjIntConsumer<IStackHolder.ChangeType> listener) {
        this._onChangeListener = Objects.requireNonNull(listener);
        return (Holder)this;
    }

    @Override
    public Holder setOnLoadListener(Runnable listener) {
        this._onLoadListener = Objects.requireNonNull(listener);
        return (Holder)this;
    }

    @Override
    public void setMaxCapacity(Int2IntFunction maxCapacity) {
        this._maxCapacityProvider = Objects.requireNonNull(maxCapacity);
    }

    @Override
    public int getMaxCapacity(int index) {
        return this._maxCapacityProvider.applyAsInt(index);
    }

    protected static <Stack> boolean defaultValidator(Integer index, Stack stack) {
        return true;
    }
}

