/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.component;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.data.stack.IStackAdapter;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStackListComponent<StackType, ContentType> {
    private final IStackAdapter<StackType, ContentType> _adapter;
    protected final NonNullList<StackType> _stacks;

    protected AbstractStackListComponent(IStackAdapter<StackType, ContentType> adapter, NonNullList<StackType> stacks) {
        Preconditions.checkNotNull(adapter, (Object)"Adapter must not be null");
        Preconditions.checkNotNull(stacks, (Object)"Stacks must not be null");
        this._adapter = adapter;
        this._stacks = CodeHelper.asNonNullList(stacks);
    }

    protected static <StackType, ContentType, Component extends AbstractStackListComponent<StackType, ContentType>> ModCodecs<Component, RegistryFriendlyByteBuf> createCodecs(Codec<StackType> elementCodec, StreamCodec<RegistryFriendlyByteBuf, StackType> streamCodec, Function<@NotNull NonNullList<StackType>, @NotNull Component> componentFactory) {
        return new ModCodecs(RecordCodecBuilder.create(instance -> instance.group((App)ModCodecs.nonNullListCodec(elementCodec).fieldOf("stacks").forGetter(component -> component._stacks)).apply((Applicative)instance, (java.util.function.Function)componentFactory)), StreamCodec.composite(ModCodecs.nonNullListStreamCodec(streamCodec), component -> component._stacks, componentFactory));
    }

    public boolean isEmpty(int index) {
        return this._adapter.isEmpty(this._stacks.get(index));
    }

    public StackType getStack(int index) {
        return (StackType)this._stacks.get(index);
    }

    public int getAmount(int index) {
        return this._adapter.getAmount(this.getStack(index));
    }

    public void copyInto(NonNullList<StackType> target) {
        CodeHelper.replaceNonNullListElements(target, this._stacks);
    }
}

