/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.computer;

import net.minecraft.core.BlockPos;

public final class LuaHelper {
    public static void validateArgsCount(Object[] arguments, int count) {
        if (arguments.length < count) {
            LuaHelper.raiseInvalidArgsCount(count);
        }
    }

    public static double getDoubleFromArgs(Object[] arguments, int index) {
        if (null == arguments[index] || !(arguments[index] instanceof Double)) {
            LuaHelper.raiseIllegalArgumentType(index, "Number");
        }
        return (Double)arguments[index];
    }

    public static double getDoubleFromArgs(Object[] arguments, int index, double minValue, double maxValue) {
        double value = LuaHelper.getDoubleFromArgs(arguments, index);
        if (value < minValue || value > maxValue) {
            LuaHelper.raiseIllegalArgumentRange(index, minValue, maxValue);
        }
        return value;
    }

    public static int getIntFromArgs(Object[] arguments, int index) {
        return (int)Math.round(LuaHelper.getDoubleFromArgs(arguments, index));
    }

    public static int getIntFromArgs(Object[] arguments, int index, int minValue, int maxValue) {
        int value = LuaHelper.getIntFromArgs(arguments, index);
        if (value < minValue || value > maxValue) {
            LuaHelper.raiseIllegalArgumentRange(index, minValue, maxValue);
        }
        return value;
    }

    public static boolean getBooleanFromArgs(Object[] arguments, int index) {
        if (null == arguments[index] || !(arguments[index] instanceof Boolean)) {
            LuaHelper.raiseIllegalArgumentType(index, "Boolean");
        }
        return (Boolean)arguments[index];
    }

    public static String getStringFromArgs(Object[] arguments, int index) {
        if (null == arguments[index] || !(arguments[index] instanceof String)) {
            LuaHelper.raiseIllegalArgumentType(index, "String");
        }
        return (String)arguments[index];
    }

    public static void raiseInvalidArgsCount(int expectedCount) {
        throw new IllegalArgumentException(String.format("Insufficient number of arguments, expected %d", expectedCount));
    }

    public static void raiseIllegalArgumentType(int index, String expectedType) {
        throw new IllegalArgumentException(String.format("Invalid argument %d, expected %s", index, expectedType));
    }

    public static void raiseIllegalArgumentRange(int index, double minValue, double maxValue) {
        throw new IllegalArgumentException(String.format("Invalid argument %d, valid range is %f : %f", index, minValue, maxValue));
    }

    public static void raiseIllegalArgumentRange(int index, int minValue, int maxValue) {
        throw new IllegalArgumentException(String.format("Invalid argument %d, valid range is %d : %d", index, minValue, maxValue));
    }

    public static Object[] blockPosToArray(BlockPos position) {
        return new Object[]{position.getX(), position.getY(), position.getZ()};
    }

    private LuaHelper() {
    }
}

