/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.internal.client.RenderTypes;
import it.zerono.mods.zerocore.internal.client.model.MissingModel;
import it.zerono.mods.zerocore.internal.mixin.client.GuiGraphicsAccessor;
import it.zerono.mods.zerocore.internal.mixin.client.ModelBakeryAccessor;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.IRichText;
import it.zerono.mods.zerocore.lib.client.gui.Orientation;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.sprite.AtlasSpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class ModRenderHelper {
    public static final float ONE_PIXEL = 0.0625f;
    public static final int GUI_TOPMOST_Z = 900;
    public static final int GUI_ITEM_Z = 600;
    public static final Supplier<@NotNull Font> DEFAULT_FONT_RENDERER = () -> Minecraft.getInstance().font;

    public static long getLastRenderTime() {
        return ZeroCore.getProxy().getLastRenderTime();
    }

    public static ModelManager getModelManager() {
        return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getModelManager();
    }

    public static UnbakedModel getModel(ResourceLocation location) {
        return ((ModelBakeryAccessor)Minecraft.getInstance().getModelManager().getModelBakery()).zerocore_getModel(location);
    }

    public static BakedModel getModel(BlockState state) {
        return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(state);
    }

    public static BakedModel getModel(ModelResourceLocation modelLocation) {
        return ModRenderHelper.getModelManager().getModel(modelLocation);
    }

    public static BakedModel getMissingModel() {
        return MissingModel.INSTANCE;
    }

    @Nullable
    public static BakedModel getMissingModel(Map<ModelResourceLocation, BakedModel> modelRegistry) {
        return modelRegistry.get(ModelBakery.MISSING_MODEL_VARIANT);
    }

    public static void bindTexture(ResourceLocation textureLocation) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
    }

    public static void bindTexture(ISprite sprite) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.getTextureMap().getTextureLocation());
    }

    public static void bindBlocksTexture() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
    }

    public static TextureAtlasSprite getTextureSprite(ResourceLocation location) {
        return ModRenderHelper.getTextureSprite(InventoryMenu.BLOCK_ATLAS, location);
    }

    public static TextureAtlasSprite getTextureSprite(ResourceLocation atlasName, ResourceLocation spriteName) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(atlasName).apply(spriteName);
    }

    public static TextureAtlasSprite getFluidStillSprite(Fluid fluid) {
        return ModRenderHelper.getTextureSprite(Objects.requireNonNull(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture()));
    }

    public static TextureAtlasSprite getFluidStillSprite(FluidStack stack) {
        return ModRenderHelper.getTextureSprite(Objects.requireNonNull(IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getStillTexture(stack)));
    }

    public static TextureAtlasSprite getFluidFlowingSprite(Fluid fluid) {
        return ModRenderHelper.getTextureSprite(Objects.requireNonNull(IClientFluidTypeExtensions.of((Fluid)fluid).getFlowingTexture()));
    }

    public static TextureAtlasSprite getFluidFlowingSprite(FluidStack stack) {
        return ModRenderHelper.getTextureSprite(Objects.requireNonNull(IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getFlowingTexture(stack)));
    }

    public static TextureAtlasSprite getMissingTexture(ResourceLocation atlasName) {
        return ModRenderHelper.getTextureSprite(atlasName, MissingTextureAtlasSprite.getLocation());
    }

    public static TextureAtlasSprite getMissingTexture() {
        return ModRenderHelper.getTextureSprite(MissingTextureAtlasSprite.getLocation());
    }

    @Nullable
    public static TextureAtlasSprite getFluidOverlaySprite(Fluid fluid) {
        ResourceLocation rl = IClientFluidTypeExtensions.of((Fluid)fluid).getOverlayTexture();
        return null != rl ? ModRenderHelper.getTextureSprite(rl) : null;
    }

    @Nullable
    public static TextureAtlasSprite getFluidOverlaySprite(FluidStack stack) {
        ResourceLocation rl = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getOverlayTexture(stack);
        return null != rl ? ModRenderHelper.getTextureSprite(rl) : null;
    }

    public static int getFluidTint(Fluid fluid) {
        return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
    }

    public static int getFluidTint(FluidStack stack) {
        return IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getTintColor(stack);
    }

    public static Colour getFluidTintColour(Fluid fluid) {
        return Colour.fromARGB(ModRenderHelper.getFluidTint(fluid));
    }

    public static Colour getFluidTintColour(FluidStack stack) {
        return Colour.fromARGB(ModRenderHelper.getFluidTint(stack));
    }

    public static ISprite getStillFluidSprite(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidStillSprite(fluid), null);
    }

    public static ISprite getStillFluidSprite(FluidStack stack) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidStillSprite(stack), null);
    }

    public static ISprite getStillFluidSpriteWithOverlay(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidStillSprite(fluid), ModRenderHelper.getFluidOverlaySprite(fluid));
    }

    public static ISprite getStillFluidSpriteWithOverlay(FluidStack stack) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidStillSprite(stack), ModRenderHelper.getFluidOverlaySprite(stack));
    }

    public static ISprite getFlowingFluidSprite(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidFlowingSprite(fluid), null);
    }

    public static ISprite getFlowingFluidSprite(FluidStack stack) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidFlowingSprite(stack), null);
    }

    public static ISprite getFlowingFluidSpriteWithOverlay(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidFlowingSprite(fluid), ModRenderHelper.getFluidOverlaySprite(fluid));
    }

    public static ISprite getFlowingFluidSpriteWithOverlay(FluidStack stack) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidFlowingSprite(stack), ModRenderHelper.getFluidOverlaySprite(stack));
    }

    private static ISprite buildSprite(TextureAtlasSprite main, @Nullable TextureAtlasSprite overlay) {
        ISprite s = AtlasSpriteTextureMap.from(main).sprite(main);
        if (null != overlay) {
            return s.copyWith(AtlasSpriteTextureMap.from(overlay).sprite(overlay));
        }
        return s;
    }

    public static List<FormattedText> splitLines(Font font, String line, int maxLineWidth) {
        return ModRenderHelper.splitLines(font, line, maxLineWidth, Style.EMPTY);
    }

    public static List<FormattedText> splitLines(Font font, String line, int maxLineWidth, Style lineStyle) {
        return font.getSplitter().splitLines(line, maxLineWidth, lineStyle);
    }

    public static List<FormattedText> splitLines(Font font, FormattedText line, int maxLineWidth) {
        return ModRenderHelper.splitLines(font, line, maxLineWidth, Style.EMPTY);
    }

    public static List<FormattedText> splitLines(Font font, FormattedText line, int maxLineWidth, Style lineStyle) {
        return font.getSplitter().splitLines(line, maxLineWidth, lineStyle);
    }

    public static int addBlockLight(int combinedLight, int blockLight) {
        return combinedLight & 0xFFFF0000 | Math.max(blockLight << 4, combinedLight & 0xFFFF);
    }

    public static void renderBlockFace(VertexConsumer renderer, Matrix4f matrix, Direction face, float x1, float y1, float z1, float x2, float y2, float z2, float minU, float maxU, float minV, float maxV, int color, int brightness) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int light1 = brightness & 0xFFFF;
        int light2 = brightness >> 16 & 0xFFFF;
        switch (face) {
            case DOWN: {
                renderer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha).setUv(minU, maxV).setUv2(light1, light2);
                renderer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha).setUv(minU, minV).setUv2(light1, light2);
                renderer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha).setUv(maxU, minV).setUv2(light1, light2);
                renderer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha).setUv(maxU, maxV).setUv2(light1, light2);
                break;
            }
            case UP: {
                renderer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha).setUv(minU, maxV).setUv2(light1, light2);
                renderer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha).setUv(minU, minV).setUv2(light1, light2);
                renderer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha).setUv(maxU, minV).setUv2(light1, light2);
                renderer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha).setUv(maxU, maxV).setUv2(light1, light2);
                break;
            }
            case NORTH: {
                renderer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha).setUv(minU, maxV).setUv2(light1, light2);
                renderer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha).setUv(minU, minV).setUv2(light1, light2);
                renderer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha).setUv(maxU, minV).setUv2(light1, light2);
                renderer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha).setUv(maxU, maxV).setUv2(light1, light2);
                break;
            }
            case SOUTH: {
                renderer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha).setUv(minU, maxV).setUv2(light1, light2);
                renderer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha).setUv(minU, minV).setUv2(light1, light2);
                renderer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha).setUv(maxU, minV).setUv2(light1, light2);
                renderer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha).setUv(maxU, maxV).setUv2(light1, light2);
                break;
            }
            case WEST: {
                renderer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha).setUv(minU, maxV).setUv2(light1, light2);
                renderer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha).setUv(minU, minV).setUv2(light1, light2);
                renderer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha).setUv(maxU, minV).setUv2(light1, light2);
                renderer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha).setUv(maxU, maxV).setUv2(light1, light2);
                break;
            }
            case EAST: {
                renderer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha).setUv(minU, maxV).setUv2(light1, light2);
                renderer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha).setUv(minU, minV).setUv2(light1, light2);
                renderer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha).setUv(maxU, minV).setUv2(light1, light2);
                renderer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha).setUv(maxU, maxV).setUv2(light1, light2);
            }
        }
    }

    public static void renderQuads(PoseStack matrix, VertexConsumer builder, List<BakedQuad> quads, int combinedLight, int combinedOverlay) {
        PoseStack.Pose entry = matrix.last();
        for (BakedQuad quad : quads) {
            builder.putBulkData(entry, quad, 1.0f, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, true);
        }
    }

    public static void renderQuads(PoseStack matrix, VertexConsumer builder, List<BakedQuad> quads, int combinedLight, int combinedOverlay, IntFunction<Colour> quadTintGetter) {
        PoseStack.Pose entry = matrix.last();
        for (BakedQuad quad : quads) {
            float alpha;
            float blue;
            float green;
            float red;
            if (quad.isTinted()) {
                Colour tint = quadTintGetter.apply(quad.getTintIndex());
                red = tint.R;
                green = tint.G;
                blue = tint.B;
                alpha = tint.A;
            } else {
                alpha = 1.0f;
                blue = 1.0f;
                green = 1.0f;
                red = 1.0f;
            }
            builder.putBulkData(entry, quad, red, green, blue, alpha, combinedLight, combinedOverlay, true);
        }
    }

    public static void renderModel(BakedModel model, ModelData data, PoseStack matrix, VertexConsumer builder, int combinedLight, int combinedOverlay, @Nullable RenderType renderType) {
        for (Direction direction : CodeHelper.DIRECTIONS) {
            ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, direction, CodeHelper.fakeRandom(), data, renderType), combinedLight, combinedOverlay);
        }
        ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, null, CodeHelper.fakeRandom(), data, renderType), combinedLight, combinedOverlay);
    }

    public static void renderModel(BakedModel model, ModelData data, PoseStack matrix, VertexConsumer builder, int combinedLight, int combinedOverlay, IntFunction<Colour> quadTintGetter, @Nullable RenderType renderType) {
        for (Direction direction : CodeHelper.DIRECTIONS) {
            ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, direction, CodeHelper.fakeRandom(), data, renderType), combinedLight, combinedOverlay, quadTintGetter);
        }
        ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, null, CodeHelper.fakeRandom(), data, renderType), combinedLight, combinedOverlay, quadTintGetter);
    }

    public static Vector3d[] getQuadVerticesFor(Direction face, float width, float height, float depth) {
        return ModRenderHelper.getQuadVerticesFor(face, width, height, depth, Vector3d.ZERO);
    }

    public static Vector3d[] getQuadVerticesFor(Direction face, float width, float height, float depth, Vector3d offset) {
        Vector3d bottomToTop;
        Vector3d leftToRight;
        Vector3d nearToFar = switch (face) {
            case Direction.NORTH -> {
                leftToRight = Vector3d.XN;
                bottomToTop = Vector3d.YP;
                yield Vector3d.ZN;
            }
            case Direction.SOUTH -> {
                leftToRight = Vector3d.XP;
                bottomToTop = Vector3d.YP;
                yield Vector3d.ZP;
            }
            case Direction.EAST -> {
                leftToRight = Vector3d.ZN;
                bottomToTop = Vector3d.YP;
                yield Vector3d.XP;
            }
            default -> {
                leftToRight = Vector3d.ZP;
                bottomToTop = Vector3d.YP;
                yield Vector3d.XN;
            }
            case Direction.UP -> {
                leftToRight = Vector3d.XN;
                bottomToTop = Vector3d.ZP;
                yield Vector3d.YP;
            }
            case Direction.DOWN -> {
                leftToRight = Vector3d.XP;
                bottomToTop = Vector3d.ZP;
                yield Vector3d.YN;
            }
        };
        leftToRight = leftToRight.multiply((double)width * 0.5);
        bottomToTop = bottomToTop.multiply((double)height * 0.5);
        nearToFar = nearToFar.multiply((double)depth * 0.5);
        Vector3d[] vertices = new Vector3d[]{Vector3d.HALF.subtract(leftToRight).subtract(bottomToTop).add(nearToFar).add(offset), Vector3d.HALF.add(leftToRight).subtract(bottomToTop).add(nearToFar).add(offset), Vector3d.HALF.add(leftToRight).add(bottomToTop).add(nearToFar).add(offset), Vector3d.HALF.subtract(leftToRight).add(bottomToTop).add(nearToFar).add(offset)};
        return vertices;
    }

    public static void paintVoxelShape(VoxelShape shape, PoseStack matrix, MultiBufferSource bufferSource, RenderType renderType, double originX, double originY, double originZ, Colour colour) {
        VertexConsumer buffer = bufferSource.getBuffer(renderType);
        Matrix4f m = matrix.last().pose();
        PoseStack.Pose normal = matrix.last();
        float red = colour.glRed();
        float green = colour.glGreen();
        float blue = colour.glBlue();
        float alpha = colour.glAlpha();
        shape.forAllEdges((x1, y1, z1, x2, y2, z2) -> {
            float deltaX = (float)(x2 - x1);
            float deltaY = (float)(y2 - y1);
            float deltaZ = (float)(z2 - z1);
            float len = Mth.sqrt((float)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
            buffer.addVertex(m, (float)(x1 + originX), (float)(y1 + originY), (float)(z1 + originZ)).setColor(red, green, blue, alpha).setNormal(normal, deltaX /= len, deltaY /= len, deltaZ /= len);
            buffer.addVertex(m, (float)(x2 + originX), (float)(y2 + originY), (float)(z2 + originZ)).setColor(red, green, blue, alpha).setNormal(normal, deltaX, deltaY, deltaZ);
        });
    }

    public static void paintSprite(GuiGraphics gfx, ISprite sprite, Point screenXY, int zLevel, int width, int height) {
        ModRenderHelper.paintSprite(gfx, sprite, screenXY.X, screenXY.Y, zLevel, width, height);
    }

    public static void paintSprite(GuiGraphics gfx, ISprite sprite, int x, int y, int zLevel, int width, int height) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        GuiGraphicsAccessor gfxAccessor = (GuiGraphicsAccessor)gfx;
        gfxAccessor.zerocore_invokeInnerBlit(sprite.getTextureMap().getTextureLocation(), x, x + width, y, y + height, zLevel, sprite.getMinU(), sprite.getMaxU(), sprite.getMinV(), sprite.getMaxV());
        RenderSystem.disableBlend();
        sprite.applyOverlay(o -> ModRenderHelper.paintSprite(gfx, o, x, y, zLevel, width, height));
    }

    public static void paintSprite(GuiGraphics gfx, ISprite sprite, int xOffset, int yOffset, int zLevel, Padding padding, int width, int height, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int x = xOffset + padding.getLeft() + maskLeft;
        int y = yOffset + padding.getTop() + maskTop;
        int u = sprite.getU() + maskLeft;
        int v = sprite.getV() + maskTop;
        int paintWidth = width - maskRight - maskLeft;
        int paintHeight = height - maskBottom - maskTop;
        float widthRatio = 1.0f / (float)sprite.getTextureMap().getWidth();
        float heightRatio = 1.0f / (float)sprite.getTextureMap().getHeight();
        GuiGraphicsAccessor gfxAccessor = (GuiGraphicsAccessor)gfx;
        gfxAccessor.zerocore_invokeInnerBlit(sprite.getTextureMap().getTextureLocation(), x, x + paintWidth, y, y + paintHeight, zLevel, (float)u * widthRatio, ((float)u + (float)paintWidth) * widthRatio, (float)v * heightRatio, ((float)v + (float)paintHeight) * heightRatio);
        RenderSystem.disableBlend();
        sprite.applyOverlay(o -> ModRenderHelper.paintSprite(gfx, o, xOffset, yOffset, zLevel, padding, width, height, maskTop, maskBottom, maskLeft, maskRight));
    }

    public static void paintOrientedProgressBarSprite(GuiGraphics gfx, Orientation orientation, ISprite sprite, Point screenXY, int zLevel, Rectangle area, double progress, Colour tint) {
        if (0.0 == progress) {
            return;
        }
        switch (orientation) {
            case BottomToTop: {
                ModRenderHelper.paintBottomToTopTiledSprite(gfx, sprite, tint, screenXY.X, screenXY.Y + area.Height, zLevel, area.Width, (int)((double)area.Height * progress));
                break;
            }
            case TopToBottom: {
                ModRenderHelper.paintTopToBottomTiledSprite(gfx, sprite, tint, screenXY.X, screenXY.Y, zLevel, area.Width, (int)((double)area.Height * progress));
                break;
            }
            case LeftToRight: {
                ModRenderHelper.paintLeftToRightTiledSprite(gfx, sprite, tint, screenXY.X, screenXY.Y, zLevel, (int)((double)area.Width * progress), area.Height);
                break;
            }
            case RightToLeft: {
                ModRenderHelper.paintRightToLeftTiledSprite(gfx, sprite, tint, screenXY.X + area.Width, screenXY.Y, zLevel, (int)((double)area.Width * progress), area.Height);
            }
        }
    }

    public static void paintOrientedProgressBarSprite(GuiGraphics gfx, Orientation orientation, ISprite sprite, int x, int y, int zLevel, int areaWidth, int areaHeight, double progress, Colour tint) {
        if (0.0 == progress) {
            return;
        }
        switch (orientation) {
            case BottomToTop: {
                ModRenderHelper.paintBottomToTopTiledSprite(gfx, sprite, tint, x, y + areaHeight, zLevel, areaWidth, (int)((double)areaHeight * progress));
                break;
            }
            case TopToBottom: {
                ModRenderHelper.paintTopToBottomTiledSprite(gfx, sprite, tint, x, y, zLevel, areaWidth, (int)((double)areaHeight * progress));
                break;
            }
            case LeftToRight: {
                ModRenderHelper.paintLeftToRightTiledSprite(gfx, sprite, tint, x, y, zLevel, (int)((double)areaWidth * progress), areaHeight);
                break;
            }
            case RightToLeft: {
                ModRenderHelper.paintRightToLeftTiledSprite(gfx, sprite, tint, x + areaWidth, y, zLevel, (int)((double)areaWidth * progress), areaHeight);
            }
        }
    }

    public static void paintTopToBottomTiledSprite(GuiGraphics gfx, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        if (0 == paintWidth || 0 == paintHeight) {
            return;
        }
        Matrix4f pose = gfx.pose().last().pose();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        ModRenderHelper.bindTexture(sprite);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMaxU = spriteMaxU - deltaU * (float)skippedWidth / (float)spriteWidth;
            int tileX1 = x + horizontalTile * spriteWidth;
            int tileX2 = tileX1 + spriteWidth - skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMaxV = spriteMaxV - deltaV * (float)skippedHeight / (float)spriteHeight;
                int tileY1 = y + verticalTile * spriteHeight;
                int tileY2 = tileY1 + height;
                bufferBuilder.addVertex(pose, (float)tileX1, (float)tileY2, (float)zLevel).setUv(spriteMinU, tileMaxV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
                bufferBuilder.addVertex(pose, (float)tileX2, (float)tileY2, (float)zLevel).setUv(tileMaxU, tileMaxV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
                bufferBuilder.addVertex(pose, (float)tileX2, (float)tileY1, (float)zLevel).setUv(tileMaxU, spriteMinV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
                bufferBuilder.addVertex(pose, (float)tileX1, (float)tileY1, (float)zLevel).setUv(spriteMinU, spriteMinV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
            }
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void paintBottomToTopTiledSprite(GuiGraphics gfx, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        if (0 == paintWidth || 0 == paintHeight) {
            return;
        }
        Matrix4f pose = gfx.pose().last().pose();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        ModRenderHelper.bindTexture(sprite);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMaxU = spriteMaxU - deltaU * (float)skippedWidth / (float)spriteWidth;
            int tileX1 = x + horizontalTile * spriteWidth;
            int tileX2 = tileX1 + spriteWidth - skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMinV = spriteMaxV - deltaV * (float)height / (float)spriteHeight;
                int baseY = y - (verticalTile + 1) * spriteHeight;
                int tileY1 = baseY + skippedHeight;
                int tileY2 = baseY + spriteHeight;
                bufferBuilder.addVertex(pose, (float)tileX1, (float)tileY2, (float)zLevel).setUv(spriteMinU, spriteMaxV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
                bufferBuilder.addVertex(pose, (float)tileX2, (float)tileY2, (float)zLevel).setUv(tileMaxU, spriteMaxV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
                bufferBuilder.addVertex(pose, (float)tileX2, (float)tileY1, (float)zLevel).setUv(tileMaxU, tileMinV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
                bufferBuilder.addVertex(pose, (float)tileX1, (float)tileY1, (float)zLevel).setUv(spriteMinU, tileMinV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
            }
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void paintLeftToRightTiledSprite(GuiGraphics gfx, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        if (0 == paintWidth || 0 == paintHeight) {
            return;
        }
        Matrix4f pose = gfx.pose().last().pose();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        ModRenderHelper.bindTexture(sprite);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMaxU = spriteMaxU - deltaU * (float)skippedWidth / (float)spriteWidth;
            int tileX1 = x + horizontalTile * spriteWidth;
            int tileX2 = tileX1 + spriteWidth - skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMaxV = spriteMaxV - deltaV * (float)skippedHeight / (float)spriteHeight;
                int baseY = y + verticalTile * spriteHeight;
                int tileY1 = baseY + skippedHeight;
                int tileY2 = baseY + spriteHeight;
                bufferBuilder.addVertex(pose, (float)tileX1, (float)tileY2, (float)zLevel).setUv(spriteMinU, tileMaxV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
                bufferBuilder.addVertex(pose, (float)tileX2, (float)tileY2, (float)zLevel).setUv(tileMaxU, tileMaxV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
                bufferBuilder.addVertex(pose, (float)tileX2, (float)tileY1, (float)zLevel).setUv(tileMaxU, spriteMinV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
                bufferBuilder.addVertex(pose, (float)tileX1, (float)tileY1, (float)zLevel).setUv(spriteMinU, spriteMinV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
            }
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void paintRightToLeftTiledSprite(GuiGraphics gfx, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        if (0 == paintWidth || 0 == paintHeight) {
            return;
        }
        Matrix4f pose = gfx.pose().last().pose();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        ModRenderHelper.bindTexture(sprite);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMinU = spriteMaxU - deltaU * (float)width / (float)spriteWidth;
            int tileX2 = x - horizontalTile * spriteWidth;
            int tileX1 = tileX2 - spriteWidth + skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMaxV = spriteMaxV - deltaV * (float)skippedHeight / (float)spriteHeight;
                int baseY = y + verticalTile * spriteHeight;
                int tileY1 = baseY + skippedHeight;
                int tileY2 = baseY + spriteHeight;
                bufferBuilder.addVertex(pose, (float)tileX1, (float)tileY2, (float)zLevel).setUv(tileMinU, tileMaxV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
                bufferBuilder.addVertex(pose, (float)tileX2, (float)tileY2, (float)zLevel).setUv(spriteMaxU, tileMaxV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
                bufferBuilder.addVertex(pose, (float)tileX2, (float)tileY1, (float)zLevel).setUv(spriteMaxU, spriteMinV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
                bufferBuilder.addVertex(pose, (float)tileX1, (float)tileY1, (float)zLevel).setUv(tileMinU, spriteMinV).setColor((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A);
            }
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void paintSolidRect(GuiGraphics gfx, Point screenXY1, Point screenXY2, int zLevel, Colour colour) {
        gfx.fill(RenderTypes.gui(), screenXY1.X, screenXY1.Y, screenXY2.X, screenXY2.Y, zLevel, colour.toARGB());
    }

    public static void paintSolidRect(GuiGraphics gfx, int x1, int y1, int x2, int y2, int zLevel, Colour colour) {
        gfx.fill(RenderType.gui(), x1, y1, x2, y2, zLevel, colour.toARGB());
    }

    public static void paintHollowRect(GuiGraphics gfx, Point screenXY, int width, int height, int zLevel, Colour colour) {
        ModRenderHelper.paintHollowRect(gfx, screenXY.X, screenXY.Y, width, height, zLevel, colour);
    }

    public static void paintHollowRect(GuiGraphics gfx, int x1, int y1, int width, int height, int zLevel, Colour colour) {
        ModRenderHelper.paintHorizontalLine(gfx, x1, y1, width, zLevel, colour);
        ModRenderHelper.paintVerticalLine(gfx, x1 + width - 1, y1 + 1, height - 2, zLevel, colour);
        ModRenderHelper.paintHorizontalLine(gfx, x1, y1 + height - 1, width, zLevel, colour);
        ModRenderHelper.paintVerticalLine(gfx, x1, y1 + 1, height - 2, zLevel, colour);
    }

    public static void paintTriangularGradientRect(GuiGraphics gfx, int x, int y, int width, int height, int zLevel, Colour lightColour, Colour darkColour) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f pose = gfx.pose().last().pose();
        float startAlpha = lightColour.glAlpha();
        float startRed = lightColour.glRed();
        float startGreen = lightColour.glGreen();
        float startBlue = lightColour.glBlue();
        float endAlpha = darkColour.glAlpha();
        float endRed = darkColour.glRed();
        float endGreen = darkColour.glGreen();
        float endBlue = darkColour.glBlue();
        int x2 = x + width - 1;
        int y2 = y + height - 1;
        builder.addVertex(pose, (float)x2, (float)y, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        builder.addVertex(pose, (float)x, (float)y, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        builder.addVertex(pose, (float)x, (float)y2, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        builder.addVertex(pose, (float)x2, (float)y2, (float)zLevel).setColor(endRed, endGreen, endBlue, endAlpha);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void paintHorizontalLine(GuiGraphics gfx, Point screenXY, int length, int zLevel, Colour colour) {
        gfx.fill(RenderTypes.gui(), screenXY.X, screenXY.Y, screenXY.X + length + 1, screenXY.Y + 1, zLevel, colour.toARGB());
    }

    public static void paintHorizontalLine(GuiGraphics gfx, int x, int y, int length, int zLevel, Colour colour) {
        gfx.fill(RenderTypes.gui(), x, y, x + length, y + 1, zLevel, colour.toARGB());
    }

    public static void paintVerticalLine(GuiGraphics gfx, Point screenXY, int length, int zLevel, Colour colour) {
        gfx.fill(RenderTypes.gui(), screenXY.X, screenXY.Y, screenXY.X + 1, screenXY.Y + length + 1, zLevel, colour.toARGB());
    }

    public static void paintVerticalLine(GuiGraphics gfx, int x, int y, int length, int zLevel, Colour colour) {
        gfx.fill(RenderTypes.gui(), x, y, x + 1, y + length, zLevel, colour.toARGB());
    }

    public static void paintButton3D(GuiGraphics gfx, Point screenXY, int width, int height, int zLevel, Colour darkOutlineColour, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintButton3D(gfx, screenXY.X, screenXY.Y, width, height, zLevel, darkOutlineColour, gradientLightColour, gradientDarkColour, borderLightColour, borderDarkColour);
    }

    public static void paintButton3D(GuiGraphics gfx, int x, int y, int width, int height, int zLevel, Colour darkOutlineColour, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintHollowRect(gfx, x, y, width, height, zLevel, darkOutlineColour);
        ModRenderHelper.paintTriangularGradientRect(gfx, x + 2, y + 2, width - 3, height - 3, zLevel, gradientLightColour, gradientDarkColour);
        ModRenderHelper.paintHorizontalLine(gfx, x + 1, y + 1, width - 2, zLevel, borderLightColour);
        ModRenderHelper.paintVerticalLine(gfx, x + 1, y + 1, height - 3, zLevel, borderLightColour);
        ModRenderHelper.paintHorizontalLine(gfx, x + 1, y + height - 2, width - 2, zLevel, borderDarkColour);
        ModRenderHelper.paintVerticalLine(gfx, x + width - 2, y + 2, height - 3, zLevel, borderDarkColour);
    }

    public static void paintButton3D(GuiGraphics gfx, Point screenXY, int width, int height, int zLevel, Colour darkOutlineColour, Colour flatBackgroundColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintButton3D(gfx, screenXY.X, screenXY.Y, width, height, zLevel, darkOutlineColour, flatBackgroundColour, borderLightColour, borderDarkColour);
    }

    public static void paintButton3D(GuiGraphics gfx, int x, int y, int width, int height, int zLevel, Colour darkOutlineColour, Colour flatBackgroundColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintHollowRect(gfx, x, y, width, height, zLevel, darkOutlineColour);
        ModRenderHelper.paintSolidRect(gfx, x + 2, y + 2, x + 2 + width - 3, y + 2 + height - 3, zLevel, flatBackgroundColour);
        ModRenderHelper.paintHorizontalLine(gfx, x + 1, y + 1, width - 2, zLevel, borderLightColour);
        ModRenderHelper.paintVerticalLine(gfx, x + 1, y + 1, height - 3, zLevel, borderLightColour);
        ModRenderHelper.paintHorizontalLine(gfx, x + 1, y + height - 2, width - 2, zLevel, borderDarkColour);
        ModRenderHelper.paintVerticalLine(gfx, x + width - 2, y + 2, height - 3, zLevel, borderDarkColour);
    }

    public static void paintMessage(GuiGraphics gfx, IRichText message, int x, int y, int zLevel, int margin, Colour background, Colour highlight1, Colour highlight2) {
        Rectangle boxBounds = message.bounds().expand(margin * 2, margin * 2).offset(x, y);
        ModRenderHelper.paintVerticalLine(gfx, boxBounds.getX1(), boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, background);
        ModRenderHelper.paintSolidRect(gfx, boxBounds.getX1() + 1, boxBounds.getY1(), boxBounds.getX2(), boxBounds.getY2() + 1, zLevel, background);
        ModRenderHelper.paintVerticalLine(gfx, boxBounds.getX2(), boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, background);
        ModRenderHelper.paintVerticalGradientLine(gfx, boxBounds.getX1() + 1, boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, highlight1, highlight2);
        ModRenderHelper.paintHorizontalGradientLine(gfx, boxBounds.getX1() + 2, boxBounds.getY1() + 1, boxBounds.Width - 4, zLevel, highlight1, highlight2);
        ModRenderHelper.paintHorizontalGradientLine(gfx, boxBounds.getX1() + 2, boxBounds.getY2() - 1, boxBounds.Width - 4, zLevel, highlight1, highlight2);
        ModRenderHelper.paintVerticalGradientLine(gfx, boxBounds.getX2() - 1, boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, highlight1, highlight2);
        message.paint(gfx, boxBounds.getX1() + margin, boxBounds.getY1() + margin, zLevel + 1);
    }

    public static boolean paintItemStack(GuiGraphics gfx, ItemStack stack, int x, int y, String text, boolean highlight) {
        if (stack.isEmpty()) {
            return false;
        }
        if (highlight) {
            ModRenderHelper.paintSolidRect(gfx, x, y, x + 16, y + 16, 599, Colour.fromARGB(-2130706433));
        }
        gfx.renderItem(stack, x, y);
        gfx.renderItemDecorations(Minecraft.getInstance().font, stack, x + 4, y, text);
        return true;
    }

    public static boolean paintItemStackWithCount(GuiGraphics gfx, ItemStack stack, int x, int y, boolean highlight) {
        return !stack.isEmpty() && ModRenderHelper.paintItemStack(gfx, stack, x, y, CodeHelper.formatAsHumanReadableNumber(stack.getCount(), ""), highlight);
    }

    public static void paintSolidLines(GuiGraphics gfx, Colour colour, double thickness, double zLevel, double ... vertices) {
        Matrix4f pose = gfx.pose().last().pose();
        float halfThickness = (float)(thickness / 2.0);
        int verticesCount = vertices.length;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        int i = 0;
        while (i < verticesCount) {
            float swap;
            float x1 = (float)vertices[i++];
            float y1 = (float)vertices[i++];
            float x2 = (float)vertices[i++];
            float y2 = (float)vertices[i++];
            if (x1 == x2) {
                if (y2 < y1) {
                    swap = y1;
                    y1 = y2;
                    y2 = swap;
                }
                builder.addVertex(pose, x1 - halfThickness, y1 - halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
                builder.addVertex(pose, x1 - halfThickness, y2 + halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
                builder.addVertex(pose, x1 + halfThickness, y1 - halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
                builder.addVertex(pose, x1 + halfThickness, y2 + halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
                continue;
            }
            if (y1 == y2) {
                if (x2 < x1) {
                    swap = x1;
                    x1 = x2;
                    x2 = swap;
                }
                builder.addVertex(pose, x1 - halfThickness, y1 - halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
                builder.addVertex(pose, x1 - halfThickness, y1 + halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
                builder.addVertex(pose, x2 + halfThickness, y1 - halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
                builder.addVertex(pose, x2 + halfThickness, y1 + halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
                continue;
            }
            if (x1 < x2 && y1 < y2 || x2 < x1 && y2 < y1) {
                if (x2 < x1) {
                    swap = x1;
                    x1 = x2;
                    x2 = swap;
                    swap = y1;
                    y1 = y2;
                    y2 = swap;
                }
                builder.addVertex(pose, x1 + halfThickness, y1 - halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
                builder.addVertex(pose, x1 - halfThickness, y1 + halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
                builder.addVertex(pose, x2 + halfThickness, y2 - halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
                builder.addVertex(pose, x2 - halfThickness, y2 + halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
                continue;
            }
            if (x1 < x2) {
                swap = x1;
                x1 = x2;
                x2 = swap;
                swap = y1;
                y1 = y2;
                y2 = swap;
            }
            builder.addVertex(pose, x1 + halfThickness, y1 + halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
            builder.addVertex(pose, x1 - halfThickness, y1 - halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
            builder.addVertex(pose, x2 + halfThickness, y2 + halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
            builder.addVertex(pose, x2 - halfThickness, y2 - halfThickness, (float)zLevel).setColor((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void paintSolidRects(GuiGraphics gfx, Colour colour, double zLevel, int ... vertices) {
        Tesselator tessellator = Tesselator.getInstance();
        Matrix4f pose = gfx.pose().last().pose();
        GlStateManager._enableBlend();
        GlStateManager._blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        ModRenderHelper.glSetColour(colour);
        RenderSystem.setShader(GameRenderer::getPositionShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        int verticesCount = vertices.length;
        for (int i = 0; i < verticesCount; i += 4) {
            int x1 = vertices[i];
            int y1 = vertices[i + 1];
            int x2 = vertices[i + 2];
            int y2 = vertices[i + 3];
            builder.addVertex(pose, (float)x1, (float)y2, (float)zLevel);
            builder.addVertex(pose, (float)x2, (float)y2, (float)zLevel);
            builder.addVertex(pose, (float)x2, (float)y1, (float)zLevel);
            builder.addVertex(pose, (float)x1, (float)y1, (float)zLevel);
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        GlStateManager._disableBlend();
    }

    public static void paintSolidTriangles(GuiGraphics gfx, Colour colour, double zLevel, int ... vertices) {
        Matrix4f pose = gfx.pose().last().pose();
        GlStateManager._enableBlend();
        GlStateManager._blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        ModRenderHelper.glSetColour(colour);
        RenderSystem.setShader(GameRenderer::getPositionShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION);
        int verticesCount = vertices.length;
        for (int i = 0; i < verticesCount; i += 6) {
            int x1 = vertices[i];
            int y1 = vertices[i + 1];
            int x2 = vertices[i + 2];
            int y2 = vertices[i + 3];
            int x3 = vertices[i + 4];
            int y3 = vertices[i + 5];
            builder.addVertex(pose, (float)x1, (float)y1, (float)zLevel);
            builder.addVertex(pose, (float)x2, (float)y2, (float)zLevel);
            builder.addVertex(pose, (float)x3, (float)y3, (float)zLevel);
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        GlStateManager._disableBlend();
    }

    public static void paintHorizontalGradientLine(GuiGraphics gfx, int x, int y, int length, double zLevel, Colour startColour, Colour endColour) {
        ModRenderHelper.paintHorizontalGradientRect(gfx, x, y, x + length, y + 1, zLevel, startColour, endColour);
    }

    public static void paintVerticalGradientLine(GuiGraphics gfx, int x, int y, int length, double zLevel, Colour startColour, Colour endColour) {
        ModRenderHelper.paintVerticalGradientRect(gfx, x, y, x + 1, y + length, zLevel, startColour, endColour);
    }

    public static void paintVerticalGradientRect(GuiGraphics gfx, int x1, int y1, int x2, int y2, double zLevel, Colour startColour, Colour endColour) {
        Matrix4f pose = gfx.pose().last().pose();
        float startAlpha = startColour.glAlpha();
        float startRed = startColour.glRed();
        float startGreen = startColour.glGreen();
        float startBlue = startColour.glBlue();
        float endAlpha = endColour.glAlpha();
        float endRed = endColour.glRed();
        float endGreen = endColour.glGreen();
        float endBlue = endColour.glBlue();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(pose, (float)x2, (float)y1, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        builder.addVertex(pose, (float)x1, (float)y1, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        builder.addVertex(pose, (float)x1, (float)y2, (float)zLevel).setColor(endRed, endGreen, endBlue, endAlpha);
        builder.addVertex(pose, (float)x2, (float)y2, (float)zLevel).setColor(endRed, endGreen, endBlue, endAlpha);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void paintHorizontalGradientRect(GuiGraphics gfx, int x1, int y1, int x2, int y2, double zLevel, Colour startColour, Colour endColour) {
        Matrix4f pose = gfx.pose().last().pose();
        float startAlpha = startColour.glAlpha();
        float startRed = startColour.glRed();
        float startGreen = startColour.glGreen();
        float startBlue = startColour.glBlue();
        float endAlpha = endColour.glAlpha();
        float endRed = endColour.glRed();
        float endGreen = endColour.glGreen();
        float endBlue = endColour.glBlue();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(pose, (float)x1, (float)y1, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        builder.addVertex(pose, (float)x1, (float)y2, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        builder.addVertex(pose, (float)x2, (float)y2, (float)zLevel).setColor(endRed, endGreen, endBlue, endAlpha);
        builder.addVertex(pose, (float)x2, (float)y1, (float)zLevel).setColor(endRed, endGreen, endBlue, endAlpha);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void paint3DGradientRect(GuiGraphics gfx, int x1, int y1, int x2, int y2, double zLevel, Colour lightColour, Colour darkColour) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f pose = gfx.pose().last().pose();
        float startAlpha = lightColour.glAlpha();
        float startRed = lightColour.glRed();
        float startGreen = lightColour.glGreen();
        float startBlue = lightColour.glBlue();
        float endAlpha = darkColour.glAlpha();
        float endRed = darkColour.glRed();
        float endGreen = darkColour.glGreen();
        float endBlue = darkColour.glBlue();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(pose, (float)x2, (float)y1, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        builder.addVertex(pose, (float)x1, (float)y1, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        builder.addVertex(pose, (float)x1, (float)y2, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        builder.addVertex(pose, (float)x2, (float)y2, (float)zLevel).setColor(endRed, endGreen, endBlue, endAlpha);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void paint3DGradientTriangle(GuiGraphics gfx, double x1, double y1, double x2, double y2, double x3, double y3, double zLevel, Colour lightColour, Colour darkColour) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f pose = gfx.pose().last().pose();
        float startAlpha = lightColour.glAlpha();
        float startRed = lightColour.glRed();
        float startGreen = lightColour.glGreen();
        float startBlue = lightColour.glBlue();
        float endAlpha = darkColour.glAlpha();
        float endRed = darkColour.glRed();
        float endGreen = darkColour.glGreen();
        float endBlue = darkColour.glBlue();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(pose, (float)x2, (float)y2, (float)zLevel).setColor(endRed, endGreen, endBlue, endAlpha);
        builder.addVertex(pose, (float)x1, (float)y1, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        builder.addVertex(pose, (float)x3, (float)y3, (float)zLevel).setColor(endRed, endGreen, endBlue, endAlpha);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void paint3DGradientTriangle(GuiGraphics gfx, double x1, double y1, double x2, double y2, double x3, double y3, double zLevel, Colour colour1, Colour colour2, Colour colour3) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f pose = gfx.pose().last().pose();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(pose, (float)x2, (float)y2, (float)zLevel).setColor(colour2.glRed(), colour2.glGreen(), colour2.glBlue(), colour2.glAlpha());
        builder.addVertex(pose, (float)x1, (float)y1, (float)zLevel).setColor(colour1.glRed(), colour1.glGreen(), colour1.glBlue(), colour1.glAlpha());
        builder.addVertex(pose, (float)x3, (float)y3, (float)zLevel).setColor(colour3.glRed(), colour3.glGreen(), colour3.glBlue(), colour3.glAlpha());
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void paint3DSolidTriangle(GuiGraphics gfx, double x1, double y1, double x2, double y2, double x3, double y3, double zLevel, Colour colour) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f pose = gfx.pose().last().pose();
        float startAlpha = colour.glAlpha();
        float startRed = colour.glRed();
        float startGreen = colour.glGreen();
        float startBlue = colour.glBlue();
        float endAlpha = colour.glAlpha();
        float endRed = colour.glRed();
        float endGreen = colour.glGreen();
        float endBlue = colour.glBlue();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(pose, (float)x1, (float)y1, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        builder.addVertex(pose, (float)x3, (float)y3, (float)zLevel).setColor(endRed, endGreen, endBlue, endAlpha);
        builder.addVertex(pose, (float)x2, (float)y2, (float)zLevel).setColor(endRed, endGreen, endBlue, endAlpha);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void paint3DSunkenBox(GuiGraphics gfx, int x1, int y1, int x2, int y2, double zLevel, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paint3DGradientRect(gfx, x1 + 1, y1 + 1, x2 - 1, y2 - 1, zLevel, gradientLightColour, gradientDarkColour);
        ModRenderHelper.paintSolidRects(gfx, borderDarkColour, zLevel, x1, y1, x2, y1 + 1, x1, y1, x1 + 1, y2);
        ModRenderHelper.paintSolidRects(gfx, borderLightColour, zLevel, x1, y2 - 1, x2, y2, x2 - 1, y1, x2, y2);
    }

    public static void paint3DSunkenBox(GuiGraphics gfx, int x1, int y1, int x2, int y2, double zLevel, Colour gradientLightColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintSolidRect(gfx, x1 + 1, y1 + 1, x2 - 1, y2 - 1, (int)zLevel, gradientLightColour);
        ModRenderHelper.paintSolidRects(gfx, borderDarkColour, zLevel, x1, y1, x2, y1 + 1, x1, y1, x1 + 1, y2);
        ModRenderHelper.paintSolidRects(gfx, borderLightColour, zLevel, x1, y2 - 1, x2, y2, x2 - 1, y1, x2, y2);
    }

    public static void glSetColour(Colour colour) {
        RenderSystem.setShaderColor((float)colour.glRed(), (float)colour.glGreen(), (float)colour.glBlue(), (float)colour.glAlpha());
    }

    public static void glSetViewport(int x, int y, int width, int height) {
        RenderSystem.viewport((int)x, (int)y, (int)width, (int)height);
    }

    public static void glSetViewport(double x, double y, double width, double height) {
        RenderSystem.viewport((int)Mth.floor((double)x), (int)Mth.floor((double)y), (int)Mth.floor((double)width), (int)Mth.floor((double)height));
    }

    public static void glSetDefaultViewport() {
        RenderSystem.viewport((int)0, (int)0, (int)Minecraft.getInstance().getWindow().getWidth(), (int)Minecraft.getInstance().getWindow().getHeight());
    }

    public static Matrix4f glPerspectiveMatrix(float fov, float aspect, float zNear, float zFar) {
        return new Matrix4f().perspective(fov, aspect, zNear, zFar);
    }

    public static IntIntPair getAtlasDimensions(TextureAtlasSprite sprite) {
        Preconditions.checkNotNull((Object)sprite, (Object)"Sprite must not be null");
        SpriteContents contents = sprite.contents();
        int atlasWidth = (int)((float)contents.width() / (sprite.getU1() - sprite.getU0()));
        int atlasHeight = (int)((float)contents.height() / (sprite.getV1() - sprite.getV0()));
        return IntIntPair.of((int)atlasWidth, (int)atlasHeight);
    }

    public static void dumpAtlas(ResourceLocation id) {
        Preconditions.checkNotNull((Object)id, (Object)"Id must not be null");
        TextureAtlas atlas = (TextureAtlas)Preconditions.checkNotNull((Object)Minecraft.getInstance().getModelManager().getAtlas(id), (String)"Atlas with ID %s was not found", (Object)id);
        ModRenderHelper.dumpAtlas(atlas);
    }

    public static void dumpAtlas(TextureAtlas atlas) {
        Preconditions.checkNotNull((Object)atlas, (Object)"Atlas must not be null");
        List<TextureAtlasSprite> sprites = atlas.getTextures().keySet().stream().map(arg_0 -> ((TextureAtlas)atlas).getSprite(arg_0)).sorted((s1, s2) -> s1.getX() == s2.getX() ? s1.getY() - s2.getY() : s1.getX() - s2.getX()).toList();
        if (sprites.isEmpty()) {
            Log.LOGGER.warn(Log.CLIENT, "Atlas {} is empty: nothing to dump", (Object)atlas.location());
            return;
        }
        String filename = atlas.location().toDebugFileName();
        Path path = TextureUtil.getDebugTexturePath();
        try {
            IntIntPair dimensions = ModRenderHelper.getAtlasDimensions(sprites.getFirst());
            Files.createDirectories(path, new FileAttribute[0]);
            TextureUtil.writeAsPNG((Path)path, (String)filename, (int)atlas.getId(), (int)0, (int)dimensions.firstInt(), (int)dimensions.secondInt());
            path = path.resolve(filename + "_sprites.txt");
            try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
                writer.println("#\tID\tX\tY\tWidth\tHeight");
                int count = 0;
                for (TextureAtlasSprite sprite : sprites) {
                    SpriteContents contents = sprite.contents();
                    writer.println(String.format("%d\t%s\t%d\t%d\t%d\t%d", ++count, contents.name(), sprite.getX(), sprite.getY(), contents.width(), contents.height()));
                }
            }
            catch (IOException ex) {
                Log.LOGGER.warn(Log.CLIENT, "Failed to write sprites data to {} : {}", (Object)path, (Object)ex);
            }
        }
        catch (IOException ex) {
            Log.LOGGER.warn(Log.CLIENT, "Failed to dump atlas to {} : {}", (Object)path, (Object)ex);
        }
    }

    public static Map<ModelResourceLocation, BakedModel> debugFilterModelRegistryByModId(Map<ModelResourceLocation, BakedModel> modelRegistry, String modId) {
        return ModRenderHelper.debugFilterModelRegistryByModId(modelRegistry, modId, null);
    }

    public static Map<ModelResourceLocation, BakedModel> debugFilterModelRegistryByModId(Map<ModelResourceLocation, BakedModel> modelRegistry, String modId, @Nullable String optionalPathFilter) {
        Preconditions.checkNotNull(modelRegistry, (Object)"Model registry must not be null");
        Preconditions.checkArgument((!modelRegistry.isEmpty() ? 1 : 0) != 0, (Object)"Model registry must not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)modId) ? 1 : 0) != 0, (Object)"Mod ID must not be null or empty");
        Stream<Map.Entry> stream = modelRegistry.entrySet().stream().filter(entry -> ((ModelResourceLocation)entry.getKey()).id().getNamespace().equals(modId));
        if (!Strings.isNullOrEmpty((String)optionalPathFilter)) {
            stream = stream.filter(entry -> ((ModelResourceLocation)entry.getKey()).id().getPath().contains(optionalPathFilter));
        }
        return (Map)stream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (model1, model2) -> {
            throw new IllegalStateException("Duplicated model resource locations found!");
        }, () -> new Object2ObjectAVLTreeMap(Comparator.comparing(ModelResourceLocation::id).thenComparing(ModelResourceLocation::getVariant, String::compareTo))));
    }

    private ModRenderHelper() {
    }
}

