/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.proxy;

import it.zerono.mods.zerocore.internal.InternalCommand;
import it.zerono.mods.zerocore.internal.Lib;
import it.zerono.mods.zerocore.internal.network.ErrorReportMessage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface IProxy {
    public Optional<Level> getClientWorld();

    public Optional<Player> getClientPlayer();

    public void markBlockRangeForRenderUpdate(BlockPos var1, BlockPos var2);

    public void sendPlayerStatusMessage(Player var1, Component var2);

    default public long getLastRenderTime() {
        return 0L;
    }

    default public void reportErrorToPlayer(@Nullable Player player, @Nullable BlockPos position, Component ... messages) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            Lib.NETWORK_HANDLER.sendToPlayer(sp, new ErrorReportMessage(position, List.of(messages)), new CustomPacketPayload[0]);
        }
    }

    default public void reportErrorToPlayer(@Nullable Player player, @Nullable BlockPos position, List<Component> messages) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            Lib.NETWORK_HANDLER.sendToPlayer(sp, new ErrorReportMessage(position, messages), new CustomPacketPayload[0]);
        }
    }

    default public void displayErrorToPlayer(@Nullable BlockPos position, Component ... messages) {
    }

    default public void displayErrorToPlayer(@Nullable BlockPos position, List<Component> messages) {
    }

    public void clearErrorReport();

    @Nullable
    public RecipeManager getRecipeManager();

    default public void handleInternalCommand(InternalCommand command, CompoundTag data, PacketFlow flow) {
    }

    public void debugUngrabMouse();

    @Nullable
    default public ModContainer getCurrentClientSideModContainer() {
        return null;
    }
}

