/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.proxy;

import it.zerono.mods.zerocore.internal.InternalCommand;
import it.zerono.mods.zerocore.internal.client.RenderTypes;
import it.zerono.mods.zerocore.internal.client.model.MissingModel;
import it.zerono.mods.zerocore.internal.proxy.GuiErrorData;
import it.zerono.mods.zerocore.internal.proxy.IForgeProxy;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.GuiHelper;
import it.zerono.mods.zerocore.lib.client.gui.IRichText;
import it.zerono.mods.zerocore.lib.client.gui.sprite.AtlasSpriteSupplier;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.recipe.ModRecipeType;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import org.jetbrains.annotations.Nullable;

public class ClientProxy
implements IForgeProxy {
    private static final Colour ERROR_BACKGROUND_COLOUR = Colour.fromARGB(0x5F5E5E5E);
    private static final Colour ERROR_HIGHLIGHT1_COLOUR = Colour.fromARGB(1357442637);
    private static final Colour ERROR_HIGHLIGHT2_COLOUR = Colour.fromARGB(1349809958);
    private static final int ERROR_BORDER = 5;
    private static volatile long s_lastRenderTime = System.currentTimeMillis();
    private final GuiErrorData _guiErrorData = new GuiErrorData();

    @Override
    public void initialize(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.addListener(this::onRenderTick);
        NeoForge.EVENT_BUS.addListener(ClientProxy::onRegisterReloadListeners);
        NeoForge.EVENT_BUS.addListener(ClientProxy::onRecipesUpdated);
        NeoForge.EVENT_BUS.addListener(this::onLoggedOut);
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, true, this::onGameOverlayRender);
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, true, this::onGuiDrawScreenEventPost);
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, true, this::onHighlightBlock);
    }

    @Override
    public Optional<Level> getClientWorld() {
        return Optional.ofNullable(Minecraft.getInstance().level);
    }

    @Override
    public Optional<Player> getClientPlayer() {
        return Optional.ofNullable(Minecraft.getInstance().player);
    }

    @Override
    public void markBlockRangeForRenderUpdate(BlockPos min, BlockPos max) {
        Minecraft.getInstance().levelRenderer.setBlocksDirty(min.getX(), min.getY(), min.getZ(), max.getX(), max.getY(), max.getZ());
    }

    @Override
    public void sendPlayerStatusMessage(Player player, Component message) {
        Minecraft.getInstance().gui.setOverlayMessage(message, false);
    }

    @Override
    public long getLastRenderTime() {
        return s_lastRenderTime;
    }

    @Override
    public void displayErrorToPlayer(@Nullable BlockPos position, Component ... messages) {
        this._guiErrorData.addErrors(position, messages);
    }

    @Override
    public void displayErrorToPlayer(@Nullable BlockPos position, List<Component> messages) {
        this._guiErrorData.addErrors(position, messages);
    }

    @Override
    public void clearErrorReport() {
        this._guiErrorData.resetErrors();
    }

    @Override
    public RecipeManager getRecipeManager() {
        if (EffectiveSide.get().isClient()) {
            ClientPacketListener handler = Minecraft.getInstance().getConnection();
            return null != handler ? handler.getRecipeManager() : null;
        }
        return CodeHelper.getMinecraftServer().map(MinecraftServer::getRecipeManager).orElse(null);
    }

    @Override
    public void handleInternalCommand(InternalCommand command, CompoundTag data, PacketFlow flow) {
        switch (command) {
            case DebugGuiFrame: {
                GuiHelper.enableGuiDebugFrame(data.contains("enable") && data.getBoolean("enable"));
                break;
            }
            case ContainerDataSync: {
                ModContainer container = this.getCurrentClientSideModContainer();
                LocalPlayer player = Minecraft.getInstance().player;
                if (null == container || null == player) break;
                container.onContainerDataSync(data, (HolderLookup.Provider)player.registryAccess());
                break;
            }
            default: {
                IForgeProxy.super.handleInternalCommand(command, data, flow);
            }
        }
    }

    @Override
    public void debugUngrabMouse() {
        Minecraft.getInstance().mouseHandler.releaseMouse();
    }

    @Override
    @Nullable
    public ModContainer getCurrentClientSideModContainer() {
        AbstractContainerMenu abstractContainerMenu;
        LocalPlayer player = Minecraft.getInstance().player;
        if (null != player && (abstractContainerMenu = player.containerMenu) instanceof ModContainer) {
            ModContainer modContainer = (ModContainer)abstractContainerMenu;
            return modContainer;
        }
        return null;
    }

    private void onLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        this.clearErrorReport();
    }

    private static void onRegisterReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)AtlasSpriteSupplier.INSTANCE);
        event.addListener((PreparableReloadListener)MissingModel.INSTANCE);
    }

    private static void onRecipesUpdated(RecipesUpdatedEvent event) {
        ModRecipeType.invalidate();
    }

    private void onRenderTick(RenderFrameEvent.Post event) {
        s_lastRenderTime = System.currentTimeMillis();
        this._guiErrorData.tick();
    }

    private void onGameOverlayRender(RenderGuiLayerEvent.Post event) {
        if (!ClientProxy.isGuiOpen()) {
            this.paintErrorMessage(event.getGuiGraphics());
        }
    }

    private void onGuiDrawScreenEventPost(ScreenEvent.Render.Post event) {
        if (ClientProxy.isGuiOpen()) {
            this.paintErrorMessage(event.getGuiGraphics());
        }
    }

    private void onHighlightBlock(RenderHighlightEvent.Block event) {
        BlockHitResult result = event.getTarget();
        BlockPos position = result.getBlockPos();
        if (HitResult.Type.BLOCK == result.getType() && this._guiErrorData.test(position)) {
            Vec3 projectedView = event.getCamera().getPosition();
            ModRenderHelper.paintVoxelShape(Shapes.block(), event.getPoseStack(), event.getMultiBufferSource(), RenderTypes.ERROR_BLOCK_HIGHLIGHT, (double)position.getX() - projectedView.x(), (double)position.getY() - projectedView.y(), (double)position.getZ() - projectedView.z(), ERROR_HIGHLIGHT1_COLOUR);
            event.setCanceled(true);
        }
    }

    private void paintErrorMessage(GuiGraphics gfx) {
        IRichText texts = this._guiErrorData.apply(Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2);
        if (texts.isEmpty()) {
            return;
        }
        ModRenderHelper.paintMessage(gfx, texts, 5, 5, 300, 5, ERROR_BACKGROUND_COLOUR, ERROR_HIGHLIGHT1_COLOUR, ERROR_HIGHLIGHT2_COLOUR);
    }

    private static boolean isGuiOpen() {
        return null != Minecraft.getInstance().screen;
    }
}

