/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal;

import com.mojang.brigadier.CommandDispatcher;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.InternalCommand;
import it.zerono.mods.zerocore.internal.command.ZeroCoreCommand;
import it.zerono.mods.zerocore.internal.network.ErrorReportMessage;
import it.zerono.mods.zerocore.internal.network.InternalCommandMessage;
import it.zerono.mods.zerocore.internal.network.ModSyncableTileMessage;
import it.zerono.mods.zerocore.internal.network.TileCommandMessage;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.data.nbt.NBTBuilder;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ContainerDataHandler;
import it.zerono.mods.zerocore.lib.network.AbstractBlockEntityPlayPacket;
import it.zerono.mods.zerocore.lib.network.NetworkHandler;
import it.zerono.mods.zerocore.lib.recipe.ModRecipeType;
import it.zerono.mods.zerocore.lib.tag.TagList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public final class Lib {
    public static final NetworkHandler NETWORK_HANDLER = new NetworkHandler();
    public static final ResourceLocationBuilder TEXTURES_LOCATION = ZeroCore.ROOT_LOCATION.appendPath("textures");
    public static final ResourceLocationBuilder GUI_TEXTURES_LOCATION = TEXTURES_LOCATION.appendPath("gui");
    public static final String NAME_INGREDIENT = "ingredient";
    public static final String NAME_TAG = "tag";
    public static final String NAME_COUNT = "count";
    private static boolean s_resourceReloaded;
    private static final ResourceManagerReloadListener RECIPES_RELOADER;

    public static void initialize(IEventBus modEventBus) {
        s_resourceReloaded = false;
        modEventBus.addListener(Lib::onRegisterPackets);
        NeoForge.EVENT_BUS.addListener(Lib::onAddReloadListener);
        NeoForge.EVENT_BUS.addListener(Lib::onRegisterCommands);
        NeoForge.EVENT_BUS.addListener(Lib::onWorldTick);
        TagList.initialize();
    }

    public static boolean shouldInvalidateResourceCache() {
        return s_resourceReloaded;
    }

    public static void sendDebugGuiFrameCommand(boolean enable) {
        NETWORK_HANDLER.sendToAllPlayers(new InternalCommandMessage(InternalCommand.DebugGuiFrame, new NBTBuilder().addBoolean("enable", enable).build()), new CustomPacketPayload[0]);
    }

    public static void sendServerContainerDataSync(ServerPlayer player, CompoundTag data) {
        NETWORK_HANDLER.sendToPlayer(player, new InternalCommandMessage(InternalCommand.ContainerDataSync, data), new CustomPacketPayload[0]);
    }

    public static void sendBlockEntityMessage(AbstractModBlockEntity blockEntity, String name, CompoundTag data) {
        NETWORK_HANDLER.sendToServer(new TileCommandMessage(blockEntity, name, data), new CustomPacketPayload[0]);
    }

    public static void sendBlockEntityMessage(ServerPlayer player, AbstractModBlockEntity blockEntity, String name, CompoundTag data) {
        NETWORK_HANDLER.sendToPlayer(player, new TileCommandMessage(blockEntity, name, data), new CustomPacketPayload[0]);
    }

    private static void onRegisterPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("zerocore").versioned("2.0.0");
        registrar.playBidirectional(TileCommandMessage.TYPE, TileCommandMessage.STREAM_CODEC, AbstractBlockEntityPlayPacket::handlePacket);
        registrar.playToClient(ModSyncableTileMessage.TYPE, ModSyncableTileMessage.STREAM_CODEC, AbstractBlockEntityPlayPacket::handlePacket);
        registrar.playToClient(ErrorReportMessage.TYPE, ErrorReportMessage.STREAM_CODEC, ErrorReportMessage::handlePacket);
        registrar.playBidirectional(InternalCommandMessage.TYPE, InternalCommandMessage.STREAM_CODEC, InternalCommandMessage::handlePacket);
        ContainerDataHandler.registerPackets(registrar);
    }

    private static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)RECIPES_RELOADER);
    }

    private static void onRegisterCommands(RegisterCommandsEvent event) {
        ZeroCoreCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static void onWorldTick(LevelTickEvent.Post event) {
        if (!event.getLevel().isClientSide()) {
            s_resourceReloaded = false;
        }
    }

    private Lib() {
    }

    static {
        RECIPES_RELOADER = new ResourceManagerReloadListener(){

            public void onResourceManagerReload(ResourceManager p_10758_) {
                s_resourceReloaded = true;
                ModRecipeType.invalidate();
            }
        };
    }
}

