/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.redstone.sensor;

import it.zerono.mods.zerocore.base.redstone.sensor.AbstractSensorSetting;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorSettingFactory;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSensorSettingData<Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType, SensorSetting>>
extends AbstractData<SensorSetting>
implements IContainerData {
    private final Class<SensorType> _sensorTypeClass;
    private final ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> _factory;
    private SensorSetting _lastValue;

    protected AbstractSensorSettingData(Class<SensorType> sensorTypeClass, ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> factory, Supplier<SensorSetting> getter, Consumer<SensorSetting> clientSideSetter) {
        super(getter, clientSideSetter);
        this._sensorTypeClass = sensorTypeClass;
        this._factory = factory;
    }

    protected AbstractSensorSettingData(Class<SensorType> sensorTypeClass, ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> factory, Supplier<SensorSetting> getter) {
        super(getter);
        this._sensorTypeClass = sensorTypeClass;
        this._factory = factory;
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        AbstractSensorSetting current = (AbstractSensorSetting)this.getValue();
        if (this._lastValue != current) {
            this._lastValue = current;
            return SensorSettingEntry.from(current);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return SensorSettingEntry.from(this._sensorTypeClass, buffer);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof SensorSettingEntry) {
            SensorSettingEntry record = (SensorSettingEntry)entry;
            SensorSetting settings = record.settings(this._factory);
            this.setClientSideValue(settings);
            this.notify(settings);
        }
    }

    private record SensorSettingEntry<Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType, SensorSetting>>(SensorType sensor, SensorBehavior behavior, int value1, int value2) implements ISyncedSetEntry
    {
        private static <Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType, SensorSetting>> SensorSettingEntry<Reader, Writer, SensorType, SensorSetting> from(Class<SensorType> sensorTypeClass, RegistryFriendlyByteBuf buffer) {
            Enum sensor = buffer.readEnum(sensorTypeClass);
            SensorBehavior behavior = (SensorBehavior)buffer.readEnum(SensorBehavior.class);
            int value1 = buffer.readInt();
            int value2 = buffer.readInt();
            return new SensorSettingEntry<Reader, Writer, Enum, SensorSetting>(sensor, behavior, value1, value2);
        }

        private static <Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType, SensorSetting>> SensorSettingEntry<Reader, Writer, SensorType, SensorSetting> from(SensorSetting setting) {
            return new SensorSettingEntry(setting.Sensor, setting.Behavior, setting.Value1, setting.Value1);
        }

        private SensorSetting settings(ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> factory) {
            return factory.createSetting(this.sensor, this.behavior, this.value1, this.value2);
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeEnum(this.sensor);
            buffer.writeEnum((Enum)this.behavior);
            buffer.writeInt(this.value1);
            buffer.writeInt(this.value2);
        }
    }
}

