/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.redstone.sensor;

import it.zerono.mods.zerocore.base.redstone.sensor.ISensorType;
import it.zerono.mods.zerocore.base.redstone.sensor.InputSensorAction;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.nbt.CompoundTag;

public abstract class AbstractSensorSetting<Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType, SensorSetting>>
implements Predicate<Reader>,
InputSensorAction<Writer> {
    public final SensorType Sensor;
    public final SensorBehavior Behavior;
    public final int Value1;
    public final int Value2;

    protected AbstractSensorSetting(SensorType sensor, SensorBehavior behavior, int v1, int v2) {
        this.Sensor = sensor;
        this.Behavior = behavior;
        this.Value1 = v1;
        this.Value2 = v2;
    }

    protected AbstractSensorSetting(CompoundTag data, Function<CompoundTag, SensorType> sensorTypeGetter) throws IllegalArgumentException {
        if (!(data.contains("behavior") && data.contains("v1") && data.contains("v2"))) {
            throw new IllegalArgumentException("Invalid NBT data");
        }
        this.Sensor = (Enum)sensorTypeGetter.apply(data);
        this.Behavior = NBTHelper.nbtGetEnum(data, "behavior", SensorBehavior::valueOf, SensorBehavior.Disabled);
        this.Value1 = data.getInt("v1");
        this.Value2 = data.getInt("v2");
    }

    public CompoundTag syncDataTo(CompoundTag data) {
        NBTHelper.nbtSetEnum(data, "behavior", this.Behavior);
        data.putInt("v1", this.Value1);
        data.putInt("v2", this.Value2);
        return data;
    }

    public abstract SensorSetting copy();

    public int getValue(int index) {
        return 0 == index ? this.Value1 : this.Value2;
    }

    @Override
    public boolean test(Reader reader) {
        return ((ISensorType)this.Sensor).isOutput() && this.Behavior.outputTest(((ToIntFunction)this.Sensor).applyAsInt(reader), this.Value1, this.Value2);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.Sensor, this.Behavior, this.Value1, this.Value2});
    }
}

