/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.client.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import java.util.Arrays;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public interface IMultiblockModelBuilder {
    public static ModelResourceLocation getModelResourceLocation(ResourceLocationBuilder modelRoot, String modelName) {
        Preconditions.checkNotNull((Object)modelRoot, (Object)"Model root must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)modelName) ? 1 : 0) != 0, (Object)"Model name must not be null or empty");
        return ModelResourceLocation.standalone((ResourceLocation)modelRoot.buildWithSuffix(modelName));
    }

    public void build();

    public ResourceLocationBuilder getModelRoot();

    public void addBlock(int var1, ModelResourceLocation var2, boolean var3, ModelResourceLocation ... var4);

    default public ModelResourceLocation getBlockStateResourceLocation(MultiblockPartBlock<?, ?> part) {
        return new ModelResourceLocation(BuiltInRegistries.BLOCK.getKey(part), "");
    }

    default public ModelResourceLocation getModelResourceLocation(String modelName) {
        return IMultiblockModelBuilder.getModelResourceLocation(this.getModelRoot(), modelName);
    }

    default public void addBlock(MultiblockPartBlock<?, ?> part, boolean hasGeneralQuads, String ... additionalVariants) {
        ModelResourceLocation[] additionalModels = new ModelResourceLocation[additionalVariants.length];
        Arrays.setAll(additionalModels, idx -> this.getModelResourceLocation(additionalVariants[idx]));
        this.addBlock(part.getPartType().getByteHashCode(), this.getBlockStateResourceLocation(part), hasGeneralQuads, additionalModels);
    }
}

