/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material.impl;

import mekanism.common.tags.MekanismTags;
import mekanism.tools.common.ToolsTags;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class SteelMaterialDefaults
implements BaseMekanismMaterial {
    @Override
    public int getShieldDurability() {
        return 448;
    }

    @Override
    public float getAxeDamage() {
        return 7.0f;
    }

    @Override
    public float getAxeAtkSpeed() {
        return -3.0f;
    }

    public int getUses() {
        return 500;
    }

    public float getSpeed() {
        return 8.0f;
    }

    public float getAttackDamageBonus() {
        return 3.0f;
    }

    public int getEnchantmentValue() {
        return 16;
    }

    @Override
    public float toughness() {
        return 2.0f;
    }

    @Override
    public int getDurabilityForType(@NotNull ArmorItem.Type armorType) {
        return switch (armorType) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.BOOTS -> 260;
            case ArmorItem.Type.LEGGINGS -> 300;
            case ArmorItem.Type.CHESTPLATE, ArmorItem.Type.BODY -> 320;
            case ArmorItem.Type.HELMET -> 220;
        };
    }

    @Override
    public int getDefense(@NotNull ArmorItem.Type armorType) {
        return switch (armorType) {
            case ArmorItem.Type.BOOTS, ArmorItem.Type.HELMET -> 3;
            case ArmorItem.Type.LEGGINGS -> 6;
            case ArmorItem.Type.CHESTPLATE -> 8;
            default -> 0;
        };
    }

    @Override
    @NotNull
    public String getConfigCommentName() {
        return "Steel";
    }

    @Override
    @NotNull
    public String getRegistryPrefix() {
        return "steel";
    }

    @NotNull
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return ToolsTags.Blocks.INCORRECT_FOR_STEEL_TOOL;
    }

    @Override
    @NotNull
    public Holder<SoundEvent> equipSound() {
        return SoundEvents.ARMOR_EQUIP_IRON;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return Ingredient.of((TagKey)MekanismTags.Items.INGOTS_STEEL);
    }

    @Override
    public float knockbackResistance() {
        return 0.0f;
    }
}

