/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material;

import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.ModConfigSpec;

@NothingNullByDefault
public class MaterialCreator
implements BaseMekanismMaterial {
    private final BaseMekanismMaterial fallBack;
    private final CachedIntValue shieldDurability;
    private final CachedFloatValue swordDamage;
    private final CachedFloatValue swordAtkSpeed;
    private final CachedFloatValue shovelDamage;
    private final CachedFloatValue shovelAtkSpeed;
    private final CachedFloatValue axeDamage;
    private final CachedFloatValue axeAtkSpeed;
    private final CachedFloatValue pickaxeDamage;
    private final CachedFloatValue pickaxeAtkSpeed;
    private final CachedFloatValue hoeDamage;
    private final CachedFloatValue hoeAtkSpeed;
    private final CachedFloatValue paxelDamage;
    private final CachedFloatValue paxelAtkSpeed;
    private final CachedFloatValue paxelEfficiency;
    private final CachedIntValue paxelEnchantability;
    private final CachedIntValue paxelMaxUses;
    private final CachedIntValue toolMaxUses;
    private final CachedFloatValue efficiency;
    private final CachedFloatValue attackDamage;
    private final CachedIntValue enchantability;
    private final CachedFloatValue toughness;
    private final CachedFloatValue knockbackResistance;
    private final CachedIntValue bootDurability;
    private final CachedIntValue leggingDurability;
    private final CachedIntValue chestplateDurability;
    private final CachedIntValue helmetDurability;
    private final CachedIntValue bootArmor;
    private final CachedIntValue leggingArmor;
    private final CachedIntValue chestplateArmor;
    private final CachedIntValue helmetArmor;

    public MaterialCreator(IMekanismConfig config, ModConfigSpec.Builder builder, BaseMekanismMaterial materialDefaults) {
        this.fallBack = materialDefaults;
        String toolKey = this.getRegistryPrefix();
        String name = this.getConfigCommentName();
        builder.comment("Material Settings for " + name).push(toolKey);
        this.attackDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Base attack damage of " + name + " items.").defineInRange(toolKey + "AttackDamage", (double)materialDefaults.getAttackDamageBonus(), 0.0, 3.4028234663852886E38));
        Predicate<Object> damageModifierPredicate = value -> {
            if (value instanceof Double) {
                double val = (Double)value;
                float actualValue = val > 3.4028234663852886E38 ? Float.MAX_VALUE : (val < -3.4028234663852886E38 ? -3.4028235E38f : (float)val);
                float baseDamage = this.attackDamage.get();
                return actualValue >= -baseDamage && actualValue <= Float.MAX_VALUE - baseDamage;
            }
            return false;
        };
        this.shieldDurability = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " shields.").defineInRange(toolKey + "ShieldDurability", materialDefaults.getShieldDurability(), 0, Integer.MAX_VALUE));
        this.swordDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " swords.").define(toolKey + "SwordDamage", (Object)materialDefaults.getSwordDamage(), damageModifierPredicate));
        this.swordAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " swords.").define(toolKey + "SwordAtkSpeed", (Object)materialDefaults.getSwordAtkSpeed()));
        this.shovelDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " shovels.").define(toolKey + "ShovelDamage", (Object)materialDefaults.getShovelDamage(), damageModifierPredicate));
        this.shovelAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " shovels.").define(toolKey + "ShovelAtkSpeed", (Object)materialDefaults.getShovelAtkSpeed()));
        this.axeDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " axes.").define(toolKey + "AxeDamage", (Object)materialDefaults.getAxeDamage(), damageModifierPredicate));
        this.axeAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " axes.").define(toolKey + "AxeAtkSpeed", (Object)materialDefaults.getAxeAtkSpeed()));
        this.pickaxeDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " pickaxes.").define(toolKey + "PickaxeDamage", (Object)materialDefaults.getPickaxeDamage(), damageModifierPredicate));
        this.pickaxeAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " pickaxes.").define(toolKey + "PickaxeAtkSpeed", (Object)materialDefaults.getPickaxeAtkSpeed()));
        this.hoeDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " hoes.").define(toolKey + "HoeDamage", (Object)materialDefaults.getHoeDamage(), damageModifierPredicate));
        this.hoeAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " hoes.").define(toolKey + "HoeAtkSpeed", (Object)materialDefaults.getHoeAtkSpeed()));
        this.toolMaxUses = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " tools.").defineInRange(toolKey + "ToolMaxUses", materialDefaults.getUses(), 1, Integer.MAX_VALUE));
        this.efficiency = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Efficiency of " + name + " tools.").define(toolKey + "Efficiency", (Object)materialDefaults.getSpeed()));
        this.paxelDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " paxels.").define(toolKey + "PaxelDamage", (Object)materialDefaults.getPaxelDamage(), damageModifierPredicate));
        this.paxelAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " paxels.").define(toolKey + "PaxelAtkSpeed", (Object)materialDefaults.getPaxelAtkSpeed()));
        this.paxelEfficiency = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Efficiency of " + name + " paxels.").define(toolKey + "PaxelEfficiency", (Object)materialDefaults.getPaxelEfficiency()));
        this.paxelEnchantability = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Natural enchantability factor of " + name + " paxels.").defineInRange(toolKey + "PaxelEnchantability", materialDefaults.getPaxelEnchantability(), 0, Integer.MAX_VALUE));
        this.paxelMaxUses = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " paxels.").defineInRange(toolKey + "PaxelMaxUses", materialDefaults.getPaxelMaxUses(), 1, Integer.MAX_VALUE));
        this.enchantability = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Natural enchantability factor of " + name + " items.").defineInRange(toolKey + "Enchantability", materialDefaults.getEnchantmentValue(), 0, Integer.MAX_VALUE));
        this.toughness = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Base armor toughness value of " + name + " armor.").defineInRange(toolKey + "Toughness", (double)materialDefaults.toughness(), 0.0, 3.4028234663852886E38));
        this.knockbackResistance = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Base armor knockback resistance value of " + name + " armor.").defineInRange(toolKey + "KnockbackResistance", (double)materialDefaults.knockbackResistance(), 0.0, 3.4028234663852886E38));
        this.bootDurability = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " boots.").defineInRange(toolKey + "BootDurability", materialDefaults.getDurabilityForType(ArmorItem.Type.BOOTS), 1, Integer.MAX_VALUE));
        this.leggingDurability = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " leggings.").defineInRange(toolKey + "LeggingDurability", materialDefaults.getDurabilityForType(ArmorItem.Type.LEGGINGS), 1, Integer.MAX_VALUE));
        this.chestplateDurability = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " chestplates.").defineInRange(toolKey + "ChestplateDurability", materialDefaults.getDurabilityForType(ArmorItem.Type.CHESTPLATE), 1, Integer.MAX_VALUE));
        this.helmetDurability = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " helmets.").defineInRange(toolKey + "HelmetDurability", materialDefaults.getDurabilityForType(ArmorItem.Type.HELMET), 1, Integer.MAX_VALUE));
        this.bootArmor = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Protection value of " + name + " boots.").defineInRange(toolKey + "BootArmor", materialDefaults.getDefense(ArmorItem.Type.BOOTS), 0, Integer.MAX_VALUE));
        this.leggingArmor = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Protection value of " + name + " leggings.").defineInRange(toolKey + "LeggingArmor", materialDefaults.getDefense(ArmorItem.Type.LEGGINGS), 0, Integer.MAX_VALUE));
        this.chestplateArmor = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Protection value of " + name + " chestplates.").defineInRange(toolKey + "ChestplateArmor", materialDefaults.getDefense(ArmorItem.Type.CHESTPLATE), 0, Integer.MAX_VALUE));
        this.helmetArmor = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Protection value of " + name + " helmets.").defineInRange(toolKey + "HelmetArmor", materialDefaults.getDefense(ArmorItem.Type.HELMET), 0, Integer.MAX_VALUE));
        builder.pop();
    }

    @Override
    public int getShieldDurability() {
        return this.shieldDurability.get();
    }

    @Override
    public float getSwordDamage() {
        return this.swordDamage.get();
    }

    @Override
    public float getSwordAtkSpeed() {
        return this.swordAtkSpeed.get();
    }

    @Override
    public float getShovelDamage() {
        return this.shovelDamage.get();
    }

    @Override
    public float getShovelAtkSpeed() {
        return this.shovelAtkSpeed.get();
    }

    @Override
    public float getAxeDamage() {
        return this.axeDamage.get();
    }

    @Override
    public float getAxeAtkSpeed() {
        return this.axeAtkSpeed.get();
    }

    @Override
    public float getPickaxeDamage() {
        return this.pickaxeDamage.get();
    }

    @Override
    public float getPickaxeAtkSpeed() {
        return this.pickaxeAtkSpeed.get();
    }

    @Override
    public float getHoeDamage() {
        return this.hoeDamage.get();
    }

    @Override
    public float getHoeAtkSpeed() {
        return this.hoeAtkSpeed.get();
    }

    @Override
    public int getPaxelMaxUses() {
        return this.paxelMaxUses.get();
    }

    @Override
    public float getPaxelEfficiency() {
        return this.paxelEfficiency.get();
    }

    @Override
    public float getPaxelDamage() {
        return this.paxelDamage.get();
    }

    @Override
    public float getPaxelAtkSpeed() {
        return this.paxelAtkSpeed.get();
    }

    public int getUses() {
        return this.toolMaxUses.get();
    }

    public float getSpeed() {
        return this.efficiency.get();
    }

    public float getAttackDamageBonus() {
        return this.attackDamage.get();
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.fallBack.getIncorrectBlocksForDrops();
    }

    @Override
    public int getDurabilityForType(ArmorItem.Type armorType) {
        return switch (armorType) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.BOOTS -> this.bootDurability.get();
            case ArmorItem.Type.LEGGINGS -> this.leggingDurability.get();
            case ArmorItem.Type.CHESTPLATE, ArmorItem.Type.BODY -> this.chestplateDurability.get();
            case ArmorItem.Type.HELMET -> this.helmetDurability.get();
        };
    }

    @Override
    public int getDefense(ArmorItem.Type armorType) {
        return switch (armorType) {
            case ArmorItem.Type.BOOTS -> this.bootArmor.get();
            case ArmorItem.Type.LEGGINGS -> this.leggingArmor.get();
            case ArmorItem.Type.CHESTPLATE -> this.chestplateArmor.get();
            case ArmorItem.Type.HELMET -> this.helmetArmor.get();
            default -> 0;
        };
    }

    public int getEnchantmentValue() {
        return this.enchantability.get();
    }

    @Override
    public boolean burnsInFire() {
        return this.fallBack.burnsInFire();
    }

    @Override
    public float toughness() {
        return this.toughness.get();
    }

    @Override
    public Holder<SoundEvent> equipSound() {
        return this.fallBack.equipSound();
    }

    public Ingredient getRepairIngredient() {
        return this.fallBack.getRepairIngredient();
    }

    @Override
    public String getConfigCommentName() {
        return this.fallBack.getConfigCommentName();
    }

    @Override
    public String getRegistryPrefix() {
        return this.fallBack.getRegistryPrefix();
    }

    @Override
    public int getPaxelEnchantability() {
        return this.paxelEnchantability.get();
    }

    @Override
    public float knockbackResistance() {
        return this.knockbackResistance.get();
    }
}

