/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SetOfItemStack
extends ObjectLinkedOpenCustomHashSet<ItemStack> {
    private static final Comparator<? super ItemStack> COMPARE_STACKS = Comparator.comparing(stack -> SetOfItemStack.namespace(stack.getItem())).thenComparing(stack -> stack.getHoverName().getString());

    public SetOfItemStack() {
        super((Hash.Strategy)new ItemStackHashingStrategy());
    }

    public SetOfItemStack(Collection<? extends ItemStack> collection) {
        super(collection, (Hash.Strategy)new ItemStackHashingStrategy());
    }

    public List<ItemStack> sortedList() {
        return this.stream().sorted(COMPARE_STACKS).toList();
    }

    private static String namespace(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getNamespace();
    }

    private record ItemStackHashingStrategy() implements Hash.Strategy<ItemStack>
    {
        public int hashCode(ItemStack stack) {
            return ItemStack.hashItemAndComponents((ItemStack)stack);
        }

        public boolean equals(ItemStack o1, ItemStack o2) {
            return ItemStack.isSameItemSameComponents((ItemStack)o1, (ItemStack)o2);
        }
    }
}

