/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import dev.ftb.mods.ftblibrary.snbt.SNBTNet;
import dev.ftb.mods.ftblibrary.snbt.SNBTTagProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public class SNBTCompoundTag
extends CompoundTag {
    public static final StreamCodec<FriendlyByteBuf, SNBTCompoundTag> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, SNBTCompoundTag>(){

        public SNBTCompoundTag decode(FriendlyByteBuf object) {
            return SNBTNet.readCompound(object);
        }

        public void encode(FriendlyByteBuf object, SNBTCompoundTag object2) {
            SNBTNet.write(object, (Tag)object2);
        }
    };
    private HashMap<String, SNBTTagProperties> properties;
    boolean singleLine = false;

    public static SNBTCompoundTag of(@Nullable Tag tag) {
        if (tag instanceof SNBTCompoundTag) {
            return (SNBTCompoundTag)tag;
        }
        if (tag instanceof CompoundTag) {
            SNBTCompoundTag tag1 = new SNBTCompoundTag();
            for (String s : ((CompoundTag)tag).getAllKeys()) {
                tag1.put(s, ((CompoundTag)tag).get(s));
            }
            return tag1;
        }
        return new SNBTCompoundTag();
    }

    public SNBTCompoundTag() {
        super(new LinkedHashMap());
    }

    SNBTTagProperties getOrCreateProperties(String key) {
        SNBTTagProperties p;
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if ((p = this.properties.get(key)) == null) {
            p = new SNBTTagProperties();
            this.properties.put(key, p);
        }
        return p;
    }

    SNBTTagProperties getProperties(String key) {
        SNBTTagProperties p;
        if (this.properties != null && (p = this.properties.get(key)) != null) {
            return p;
        }
        return SNBTTagProperties.DEFAULT;
    }

    public void comment(String key, String ... comment) {
        if (comment.length > 0) {
            this.comment(key, String.join((CharSequence)"\n", comment));
        }
    }

    public void comment(String key, String comment) {
        String s;
        String string = s = comment == null ? "" : comment.trim();
        if (!s.isEmpty()) {
            this.getOrCreateProperties((String)key).comment = comment;
        }
    }

    public String getComment(String key) {
        return this.getProperties((String)key).comment;
    }

    public void singleLine() {
        this.singleLine = true;
    }

    public void singleLine(String key) {
        this.getOrCreateProperties((String)key).singleLine = true;
    }

    public void putBoolean(String key, boolean value) {
        this.getOrCreateProperties((String)key).valueType = value ? 2 : 1;
        super.putBoolean(key, value);
    }

    public boolean isBoolean(String key) {
        int t = this.getProperties((String)key).valueType;
        return t == 2 || t == 1;
    }

    public SNBTCompoundTag getCompound(String string) {
        return SNBTCompoundTag.of(this.get(string));
    }

    public void putNumber(String key, Number number) {
        if (number instanceof Double) {
            this.putDouble(key, number.doubleValue());
        } else if (number instanceof Float) {
            this.putFloat(key, number.floatValue());
        } else if (number instanceof Long) {
            this.putLong(key, number.longValue());
        } else if (number instanceof Integer) {
            this.putInt(key, number.intValue());
        } else if (number instanceof Short) {
            this.putShort(key, number.shortValue());
        } else if (number instanceof Byte) {
            this.putByte(key, number.byteValue());
        } else if (number.toString().contains(".")) {
            this.putDouble(key, number.doubleValue());
        } else {
            this.putInt(key, number.intValue());
        }
    }

    public void putNull(String key) {
        this.put(key, (Tag)EndTag.INSTANCE);
    }

    @Nullable
    public ListTag getNullableList(String key, byte type) {
        Tag tag = this.get(key);
        return tag instanceof ListTag && (((ListTag)tag).isEmpty() || type == 0 || ((ListTag)tag).getElementType() == type) ? (ListTag)tag : null;
    }

    public <T extends Tag> List<T> getList(String key, Class<T> type) {
        Tag tag = this.get(key);
        if (!(tag instanceof CollectionTag)) {
            return Collections.emptyList();
        }
        CollectionTag l = (CollectionTag)tag;
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tag> list = new ArrayList<Tag>(l.size());
        for (Tag t : l) {
            if (!type.isAssignableFrom(t.getClass())) continue;
            list.add(t);
        }
        return list;
    }
}

