/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.trait.IAttunementItem;
import net.blay09.mods.waystones.api.trait.IFOVOnUse;
import net.blay09.mods.waystones.api.trait.IResetUseOnDamage;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.item.ScrollItemBase;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BoundScrollItem
extends ScrollItemBase
implements IResetUseOnDamage,
IFOVOnUse,
IAttunementItem {
    public BoundScrollItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return WaystonesConfig.getActive().general.scrollUseTime;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        if (!world.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Optional<Waystone> boundTo = this.getWaystoneAttunedTo(player.getServer(), (Player)player, stack);
            boundTo.ifPresent(targetWaystone -> WaystonesAPI.createDefaultTeleportContext((Entity)player, targetWaystone, it -> it.setWarpItem(stack)).mapLeft(WaystonesAPI::tryTeleport).ifLeft(it -> {
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }));
        }
        return stack;
    }

    @Override
    public Optional<Waystone> getWaystoneAttunedTo(MinecraftServer server, Player player, ItemStack itemStack) {
        return Optional.ofNullable((UUID)itemStack.get((DataComponentType)ModComponents.attunement.get())).map(attunement -> new WaystoneProxy(server, (UUID)attunement));
    }

    @Override
    public void setWaystoneAttunedTo(ItemStack itemStack, @Nullable Waystone waystone) {
        if (waystone != null) {
            itemStack.set((DataComponentType)ModComponents.attunement.get(), (Object)waystone.getWaystoneUid());
        } else {
            itemStack.remove((DataComponentType)ModComponents.attunement.get());
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        Player player = Balm.getProxy().getClientPlayer();
        if (player == null) {
            return;
        }
        Optional<Waystone> boundTo = this.getWaystoneAttunedTo(player.getServer(), player, itemStack);
        boundTo.ifPresent(it -> {
            MutableComponent boundToValueComponent = it.getName().copy().withStyle(ChatFormatting.AQUA);
            list.add((Component)Component.translatable((String)"tooltip.waystones.bound_to", (Object[])new Object[]{boundToValueComponent}).withStyle(ChatFormatting.GRAY));
        });
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }
}

