/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.TeleportDestination;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.error.WaystoneTeleportError;
import net.blay09.mods.waystones.api.event.WaystoneTeleportEvent;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WaystonesConfigData;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.network.message.TeleportEffectMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WaystoneTeleportManager {
    public static Collection<? extends Entity> findPets(Entity entity) {
        return entity.level().getEntitiesOfClass(TamableAnimal.class, new AABB(entity.blockPosition()).inflate(10.0), pet -> entity.getUUID().equals(pet.getOwnerUUID()) && !pet.isOrderedToSit() && !WaystonePermissionManager.isEntityDeniedTeleports((Entity)pet));
    }

    public static List<Mob> findLeashedAnimals(Entity player) {
        return player.level().getEntitiesOfClass(Mob.class, new AABB(player.blockPosition()).inflate(10.0), e -> player.equals((Object)e.getLeashHolder()));
    }

    public static Either<List<Entity>, WaystoneTeleportError> doTeleport(WaystoneTeleportContext context) {
        MinecraftServer server = context.getEntity().getServer();
        if (server == null) {
            return Either.right((Object)new WaystoneTeleportError.NotOnServer());
        }
        return WaystoneTeleportManager.resolveDestination(server, context.getTargetWaystone()).flatMap(it -> WaystoneTeleportManager.doTeleport(context, it));
    }

    public static Either<List<Entity>, WaystoneTeleportError> doTeleport(WaystoneTeleportContext context, TeleportDestination destination) {
        ServerLevel sourceLevel = (ServerLevel)context.getEntity().level();
        List<Entity> teleportedEntities = WaystoneTeleportManager.teleportEntityAndAttached(context.getEntity(), context, destination);
        context.getAdditionalEntities().forEach(additionalEntity -> teleportedEntities.addAll(WaystoneTeleportManager.teleportEntityAndAttached(additionalEntity, context, destination)));
        BlockPos sourcePos = context.getEntity().blockPosition();
        ServerLevel targetLevel = (ServerLevel)destination.level();
        BlockPos targetPos = BlockPos.containing((Position)destination.location());
        BlockEntity targetTileEntity = targetLevel.getBlockEntity(targetPos);
        if (targetTileEntity instanceof WarpPlateBlockEntity) {
            WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)targetTileEntity;
            teleportedEntities.forEach(warpPlate::markEntityForCooldown);
        }
        if (context.playsSound()) {
            sourceLevel.playSound(context.getEntity(), sourcePos, SoundEvents.PORTAL_TRAVEL, SoundSource.PLAYERS, 0.01f, 1.0f);
            targetLevel.playSound(null, targetPos, SoundEvents.PORTAL_TRAVEL, SoundSource.PLAYERS, 0.05f, 1.0f);
        }
        if (context.playsEffect()) {
            teleportedEntities.forEach(additionalEntity -> Balm.getNetworking().sendToTracking(sourceLevel, sourcePos, (CustomPacketPayload)new TeleportEffectMessage(sourcePos)));
            Balm.getNetworking().sendToTracking(targetLevel, targetPos, (CustomPacketPayload)new TeleportEffectMessage(targetPos));
        }
        if (targetTileEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)targetTileEntity;
            teleportedEntities.forEach(waystoneBlockEntity::applyModifierEffects);
        }
        return Either.left(teleportedEntities);
    }

    private static List<Entity> teleportEntityAndAttached(Entity entity, WaystoneTeleportContext context, TeleportDestination destination) {
        ArrayList<Entity> teleportedEntities = new ArrayList<Entity>();
        ServerLevel targetLevel = (ServerLevel)destination.level();
        Vec3 targetLocation = destination.location();
        Direction targetDirection = destination.direction();
        Entity mount = entity.getVehicle();
        Entity teleportedMount = null;
        if (mount != null) {
            teleportedMount = WaystoneTeleportManager.teleportEntity(mount, targetLevel, targetLocation, targetDirection);
            teleportedEntities.add(teleportedMount);
        }
        List<Mob> leashedEntities = context.getLeashedEntities();
        ArrayList teleportedLeashedEntities = new ArrayList();
        leashedEntities.forEach(leashedEntity -> {
            Entity teleportedLeashedEntity = WaystoneTeleportManager.teleportEntity((Entity)leashedEntity, targetLevel, targetLocation, targetDirection);
            teleportedEntities.add(teleportedLeashedEntity);
            teleportedLeashedEntities.add(teleportedLeashedEntity);
        });
        Entity teleportedEntity = WaystoneTeleportManager.teleportEntity(entity, targetLevel, targetLocation, targetDirection);
        teleportedEntities.add(teleportedEntity);
        teleportedLeashedEntities.forEach(teleportedLeashedEntity -> {
            if (teleportedLeashedEntity instanceof Mob) {
                Mob teleportedLeashedMob = (Mob)teleportedLeashedEntity;
                teleportedLeashedMob.setLeashedTo(teleportedEntity, true);
            }
        });
        if (teleportedMount != null) {
            // empty if block
        }
        return teleportedEntities;
    }

    private static Entity teleportEntity(Entity entity, ServerLevel targetWorld, Vec3 targetPos3d, Direction direction) {
        float yaw = direction.toYRot();
        double x = targetPos3d.x;
        double y = targetPos3d.y;
        double z = targetPos3d.z;
        if (entity instanceof ServerPlayer) {
            ChunkPos chunkPos = new ChunkPos(BlockPos.containing((double)x, (double)y, (double)z));
            targetWorld.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkPos, 1, (Object)entity.getId());
            entity.stopRiding();
            if (((ServerPlayer)entity).isSleeping()) {
                ((ServerPlayer)entity).stopSleepInBed(true, true);
            }
            if (targetWorld == entity.level()) {
                ((ServerPlayer)entity).connection.teleport(x, y, z, yaw, entity.getXRot(), Collections.emptySet());
            } else {
                ((ServerPlayer)entity).teleportTo(targetWorld, x, y, z, yaw, entity.getXRot());
            }
            entity.setYHeadRot(yaw);
        } else {
            float pitch = Mth.clamp((float)entity.getXRot(), (float)-90.0f, (float)90.0f);
            if (targetWorld == entity.level()) {
                entity.moveTo(x, y, z, yaw, pitch);
                entity.setYHeadRot(yaw);
            } else {
                entity.unRide();
                Entity oldEntity = entity;
                entity = entity.getType().create((Level)targetWorld);
                if (entity == null) {
                    return oldEntity;
                }
                entity.restoreFrom(oldEntity);
                entity.moveTo(x, y, z, yaw, pitch);
                entity.setYHeadRot(yaw);
                oldEntity.setRemoved(Entity.RemovalReason.CHANGED_DIMENSION);
                targetWorld.addDuringTeleport(entity);
            }
        }
        if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).isFallFlying()) {
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            entity.setOnGround(true);
        }
        if (entity instanceof PathfinderMob) {
            ((PathfinderMob)entity).getNavigation().stop();
        }
        WaystoneTeleportManager.sendHackySyncPacketsAfterTeleport(entity);
        return entity;
    }

    private static Either<TeleportDestination, WaystoneTeleportError> resolveDestination(MinecraftServer server, Waystone waystone) {
        ResourceLocation waystoneType;
        ServerLevel level = server.getLevel(waystone.getDimension());
        if (level == null) {
            return Either.right((Object)new WaystoneTeleportError.InvalidDimension(waystone.getDimension()));
        }
        BlockPos pos = waystone.getPos();
        BlockState state = level.getBlockState(pos);
        Direction direction = state.hasProperty((Property)WaystoneBlock.FACING) ? (Direction)state.getValue((Property)WaystoneBlock.FACING) : Direction.NORTH;
        ArrayList directionCandidates = Lists.newArrayList((Object[])new Direction[]{direction, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH});
        for (Direction candidate : directionCandidates) {
            BlockPos offsetPos = pos.relative(candidate);
            BlockPos offsetPosUp = offsetPos.above();
            if (level.getBlockState(offsetPos).isSuffocating((BlockGetter)level, offsetPos) || level.getBlockState(offsetPosUp).isSuffocating((BlockGetter)level, offsetPosUp)) continue;
            direction = candidate;
            break;
        }
        boolean shouldOffsetFacing = !(waystoneType = waystone.getWaystoneType()).equals((Object)WaystoneTypes.WARP_PLATE);
        BlockPos targetPos = shouldOffsetFacing ? pos.relative(direction) : pos;
        Vec3 location = new Vec3((double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5);
        return Either.left((Object)new TeleportDestination((Level)level, location, direction));
    }

    private static void sendHackySyncPacketsAfterTeleport(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.connection.send((Packet)new ClientboundSetExperiencePacket(player.experienceProgress, player.totalExperience, player.experienceLevel));
        }
    }

    public static Either<List<Entity>, WaystoneTeleportError> tryTeleport(WaystoneTeleportContext context) {
        Player player;
        WaystoneTeleportEvent.Pre event = new WaystoneTeleportEvent.Pre(context);
        Balm.getEvents().fireEvent((Object)event);
        if (event.isCanceled()) {
            return Either.right((Object)new WaystoneTeleportError.CancelledByEvent());
        }
        Entity entity = context.getEntity();
        if (!context.getLeashedEntities().isEmpty()) {
            if (WaystonesConfig.getActive().teleports.transportLeashed == WaystonesConfigData.TransportMobs.DISABLED) {
                return Either.right((Object)new WaystoneTeleportError.LeashedWarpDenied());
            }
            for (Mob leashedEntity : context.getLeashedEntities()) {
                if (!WaystonePermissionManager.isEntityDeniedTeleports((Entity)leashedEntity)) continue;
                return Either.right((Object)new WaystoneTeleportError.SpecificLeashedWarpDenied((Entity)leashedEntity));
            }
            if (context.isDimensionalTeleport() && WaystonesConfig.getActive().teleports.transportLeashed == WaystonesConfigData.TransportMobs.SAME_DIMENSION) {
                return Either.right((Object)new WaystoneTeleportError.LeashedDimensionalWarpDenied());
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (!context.getRequirements().canAfford(player) && !player.getAbilities().instabuild) {
                return Either.right((Object)new WaystoneTeleportError.NotEnoughXp());
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            context.getRequirements().consume(player);
        }
        return WaystoneTeleportManager.doTeleport(context).ifLeft(teleportedEntities -> Balm.getEvents().fireEvent((Object)new WaystoneTeleportEvent.Post(context, (List<Entity>)teleportedEntities)));
    }
}

