/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.compat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.client.JourneyMapPlugin;
import journeymap.api.v2.client.event.MappingEvent;
import journeymap.api.v2.common.event.ClientEventRegistry;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointFactory;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.event.WaystoneRemoveReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdateReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WaystonesConfigData;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@JourneyMapPlugin(apiVersion="2.0.0")
public class JourneyMapIntegration
implements IClientPlugin {
    private IClientAPI api;
    private WaypointGroup waystonesGroup;
    private WaypointGroup sharestonesGroup;
    private boolean journeyMapReady;
    private final Map<UUID, String> waystoneToWaypoint = new HashMap<UUID, String>();
    private final Map<String, UUID> waypointToWaystone = new HashMap<String, UUID>();
    private final Map<String, ResourceLocation> waypointTypes = new HashMap<String, ResourceLocation>();
    private final List<Runnable> scheduledJobsWhenReady = new ArrayList<Runnable>();
    private static JourneyMapIntegration instance;

    public JourneyMapIntegration() {
        instance = this;
        Balm.getEvents().onEvent(WaystonesListReceivedEvent.class, this::onWaystonesListReceived);
        Balm.getEvents().onEvent(WaystoneUpdateReceivedEvent.class, this::onWaystoneUpdateReceived);
        Balm.getEvents().onEvent(WaystoneRemoveReceivedEvent.class, this::onWaystoneRemoveReceived);
    }

    public void initialize(IClientAPI iClientAPI) {
        this.api = iClientAPI;
        ClientEventRegistry.MAPPING_EVENT.subscribe("waystones", this::onMappingEvent);
        this.waystonesGroup = WaypointFactory.createWaypointGroup((String)"waystones", (String)"waystones");
        this.sharestonesGroup = WaypointFactory.createWaypointGroup((String)"waystones", (String)"sharestones");
    }

    @Nullable
    public static JourneyMapIntegration getInstance() {
        return instance;
    }

    public String getModId() {
        return "waystones";
    }

    public void onMappingEvent(MappingEvent event) {
        if (event.getStage() == MappingEvent.Stage.MAPPING_STARTED) {
            this.journeyMapReady = true;
            for (Runnable scheduledJob : this.scheduledJobsWhenReady) {
                scheduledJob.run();
            }
            this.scheduledJobsWhenReady.clear();
        }
    }

    public void onWaystonesListReceived(WaystonesListReceivedEvent event) {
        if (JourneyMapIntegration.shouldManageWaypoints() && this.isSupportedWaystoneType(event.getWaystoneType())) {
            this.runWhenJourneyMapIsReady(() -> this.updateAllWaypoints(event.getWaystoneType(), event.getWaystones()));
        }
    }

    private boolean isSupportedWaystoneType(ResourceLocation waystoneType) {
        return waystoneType.equals((Object)WaystoneTypes.WAYSTONE) || WaystoneTypes.isSharestone(waystoneType);
    }

    private static boolean shouldManageWaypoints() {
        WaystonesConfigData config = WaystonesConfig.getActive();
        if (config.compatibility.preferJourneyMapIntegrationMod && Balm.isModLoaded((String)"jmi")) {
            return false;
        }
        return config.compatibility.journeyMap;
    }

    public void onWaystoneUpdateReceived(WaystoneUpdateReceivedEvent event) {
        if (JourneyMapIntegration.shouldManageWaypoints() && this.isSupportedWaystoneType(event.getWaystone().getWaystoneType())) {
            this.runWhenJourneyMapIsReady(() -> this.updateWaypoint(event.getWaystone()));
        }
    }

    public void onWaystoneRemoveReceived(WaystoneRemoveReceivedEvent event) {
        if (JourneyMapIntegration.shouldManageWaypoints() && this.isSupportedWaystoneType(event.getWaystoneType())) {
            this.runWhenJourneyMapIsReady(() -> this.removeWaypoint(event.getWaystoneId()));
        }
    }

    private void runWhenJourneyMapIsReady(Runnable runnable) {
        if (this.journeyMapReady) {
            runnable.run();
        } else {
            this.scheduledJobsWhenReady.add(runnable);
        }
    }

    private void updateAllWaypoints(ResourceLocation waystoneType, List<Waystone> waystones) {
        HashSet<UUID> stillExistingIds = new HashSet<UUID>();
        for (Waystone waystone : waystones) {
            stillExistingIds.add(waystone.getWaystoneUid());
            this.updateWaypoint(waystone);
        }
        List waypoints = this.api.getWaypoints("waystones");
        for (Waypoint waypoint : waypoints) {
            UUID waystoneUid = this.waypointToWaystone.get(waypoint.getGuid());
            ResourceLocation type = this.waypointTypes.get(waypoint.getGuid());
            if (!waystoneType.equals((Object)type) || stillExistingIds.contains(waystoneUid)) continue;
            this.api.removeWaypoint("waystones", waypoint);
            this.waystoneToWaypoint.remove(waystoneUid);
            this.waypointToWaystone.remove(waypoint.getGuid());
            this.waypointTypes.remove(waypoint.getGuid());
        }
    }

    private void removeWaypoint(UUID waystoneId) {
        String waypointId = this.waystoneToWaypoint.get(waystoneId);
        if (waypointId != null) {
            Waypoint waypoint = this.api.getWaypoint("waystones", waypointId);
            if (waypoint != null) {
                this.api.removeWaypoint("waystones", waypoint);
                this.waypointTypes.remove(waypoint.getGuid());
            }
            this.waystoneToWaypoint.remove(waystoneId);
            this.waypointToWaystone.remove(waypointId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateWaypoint(Waystone waystone) {
        try {
            String waypointId = this.waystoneToWaypoint.get(waystone.getWaystoneUid());
            Waypoint oldWaypoint = waypointId != null ? this.api.getWaypoint("waystones", waypointId) : null;
            Component waystoneName = waystone.hasName() ? waystone.getName() : Component.translatable((String)"waystones.map.untitled_waystone");
            Waypoint waypoint = WaypointFactory.createClientWaypoint((String)"waystones", (BlockPos)waystone.getPos(), (String)waystoneName.getString(), waystone.getDimension(), (boolean)false);
            if (oldWaypoint != null) {
                waypoint.setEnabled(oldWaypoint.isEnabled());
                waypoint.setColor(oldWaypoint.getColor());
                waypoint.setIconColor(oldWaypoint.getIconColor());
                this.api.removeWaypoint("waystones", oldWaypoint);
            }
            this.api.addWaypoint("waystones", waypoint);
            this.waystoneToWaypoint.put(waystone.getWaystoneUid(), waypoint.getGuid());
            this.waypointToWaystone.put(waypoint.getGuid(), waystone.getWaystoneUid());
            this.waypointTypes.put(waypoint.getGuid(), waystone.getWaystoneType());
            WaypointGroup group = this.getWaystoneGroup(waystone);
            if (group == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private WaypointGroup getWaystoneGroup(Waystone waystone) {
        if (WaystoneTypes.isSharestone(waystone.getWaystoneType())) {
            return this.sharestonesGroup;
        }
        return this.waystonesGroup;
    }
}

