/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.compat;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.event.WaystoneInitializedEvent;
import net.blay09.mods.waystones.api.event.WaystoneRemovedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdatedEvent;
import net.blay09.mods.waystones.api.event.WaystonesLoadedEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class BlueMapIntegration {
    private final Map<ResourceKey<Level>, LevelMarkers> levelMarkersByDimension = new HashMap<ResourceKey<Level>, LevelMarkers>();
    private BlueMapAPI api;

    public BlueMapIntegration() {
        BlueMapAPI.onEnable(api -> {
            this.api = api;
            for (LevelMarkers levelMarkers : this.levelMarkersByDimension.values()) {
                levelMarkers.update((BlueMapAPI)api);
            }
        });
        BlueMapAPI.onDisable(api -> {
            this.api = null;
        });
        Balm.getEvents().onEvent(WaystonesLoadedEvent.class, this::onWaystonesLoaded);
        Balm.getEvents().onEvent(WaystoneInitializedEvent.class, this::onWaystoneInitialized);
        Balm.getEvents().onEvent(WaystoneUpdatedEvent.class, this::onWaystoneUpdated);
        Balm.getEvents().onEvent(WaystoneRemovedEvent.class, this::onWaystoneRemoved);
    }

    private void onWaystoneInitialized(WaystoneInitializedEvent event) {
        ResourceKey<Level> dimensionId = event.getWaystone().getDimension();
        LevelMarkers levelMarkers = this.levelMarkersByDimension.computeIfAbsent(dimensionId, LevelMarkers::new);
        levelMarkers.addWaystoneMarker(event.getWaystone());
        if (this.api != null) {
            levelMarkers.update(this.api);
        }
    }

    private void onWaystoneUpdated(WaystoneUpdatedEvent event) {
        ResourceKey<Level> dimensionId = event.getWaystone().getDimension();
        LevelMarkers levelMarkers = this.levelMarkersByDimension.computeIfAbsent(dimensionId, LevelMarkers::new);
        levelMarkers.addWaystoneMarker(event.getWaystone());
        if (this.api != null) {
            levelMarkers.update(this.api);
        }
    }

    private void onWaystoneRemoved(WaystoneRemovedEvent event) {
        ResourceKey<Level> dimensionId = event.getWaystone().getDimension();
        LevelMarkers levelMarkers = this.levelMarkersByDimension.computeIfAbsent(dimensionId, LevelMarkers::new);
        levelMarkers.removeWaystoneMarker(event.getWaystone());
        if (this.api != null) {
            levelMarkers.update(this.api);
        }
    }

    private void onWaystonesLoaded(WaystonesLoadedEvent event) {
        Map<ResourceKey, List<Waystone>> waystonesByDimension = event.getWaystoneManager().getWaystones().filter(BlueMapIntegration::isSupportedWaystoneType).collect(Collectors.groupingBy(Waystone::getDimension));
        for (Map.Entry<ResourceKey, List<Waystone>> entry : waystonesByDimension.entrySet()) {
            LevelMarkers levelMarkers = this.levelMarkersByDimension.computeIfAbsent((ResourceKey<Level>)entry.getKey(), LevelMarkers::new);
            levelMarkers.createFromWaystones(entry.getValue());
            if (this.api == null) continue;
            levelMarkers.update(this.api);
        }
    }

    public static String getMarkerId(Waystone waystone) {
        return waystone.getWaystoneUid().toString();
    }

    public static POIMarker createWaystoneMarker(Waystone waystone) {
        return ((POIMarker.Builder)((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().label(waystone.getName().getString())).position((double)waystone.getPos().getX(), (double)waystone.getPos().getY(), (double)waystone.getPos().getZ())).maxDistance(1000.0)).build();
    }

    private static boolean isSupportedWaystoneType(Waystone waystone) {
        return BlueMapIntegration.isSupportedWaystoneType(waystone.getWaystoneType());
    }

    private static boolean isSupportedWaystoneType(ResourceLocation waystoneType) {
        return waystoneType.equals((Object)WaystoneTypes.WAYSTONE) || WaystoneTypes.isSharestone(waystoneType);
    }

    private static class LevelMarkers {
        private final MarkerSet waystoneMarkers = MarkerSet.builder().label("Waystones").build();
        private final MarkerSet sharestoneMarkers = MarkerSet.builder().label("Sharestones").build();
        private final ResourceKey<Level> level;

        private LevelMarkers(ResourceKey<Level> level) {
            this.level = level;
        }

        public void update(BlueMapAPI api) {
            api.getWorld(this.level).ifPresent(world -> {
                for (BlueMapMap map : world.getMaps()) {
                    map.getMarkerSets().put("waystones:waystones", this.waystoneMarkers);
                    map.getMarkerSets().put("waystones:sharestones", this.sharestoneMarkers);
                }
            });
        }

        public void createFromWaystones(List<Waystone> waystones) {
            this.waystoneMarkers.getMarkers().clear();
            this.sharestoneMarkers.getMarkers().clear();
            for (Waystone waystone : waystones) {
                this.addWaystoneMarker(waystone);
            }
        }

        public void addWaystoneMarker(Waystone waystone) {
            POIMarker marker = BlueMapIntegration.createWaystoneMarker(waystone);
            String markerId = BlueMapIntegration.getMarkerId(waystone);
            if (WaystoneTypes.isSharestone(waystone.getWaystoneType())) {
                this.sharestoneMarkers.put(markerId, (Marker)marker);
            } else {
                this.waystoneMarkers.put(markerId, (Marker)marker);
            }
        }

        public void removeWaystoneMarker(Waystone waystone) {
            String markerId = BlueMapIntegration.getMarkerId(waystone);
            if (WaystoneTypes.isSharestone(waystone.getWaystoneType())) {
                this.sharestoneMarkers.remove(markerId);
            } else {
                this.waystoneMarkers.remove(markerId);
            }
        }
    }
}

