/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WaystoneBlock
extends WaystoneBlockBase {
    public static final MapCodec<WaystoneBlock> CODEC = WaystoneBlock.simpleCodec(WaystoneBlock::new);
    private static final VoxelShape LOWER_SHAPE = Shapes.or((VoxelShape)WaystoneBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{WaystoneBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), WaystoneBlock.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), WaystoneBlock.box((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)}).optimize();
    private static final VoxelShape UPPER_SHAPE = Shapes.or((VoxelShape)WaystoneBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (VoxelShape[])new VoxelShape[]{WaystoneBlock.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), WaystoneBlock.box((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), WaystoneBlock.box((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), WaystoneBlock.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)}).optimize();

    public WaystoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean canSilkTouch() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE : LOWER_SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WaystoneBlockEntity(pos, state);
    }

    @Override
    protected InteractionResult handleActivation(Level world, BlockPos pos, Player player, WaystoneBlockEntityBase blockEntity, Waystone waystone) {
        boolean isActivated = PlayerWaystoneManager.isWaystoneActivated(player, waystone);
        if (isActivated) {
            if (!world.isClientSide) {
                blockEntity.getSelectionMenuProvider().ifPresent(menuProvider -> Balm.getNetworking().openGui(player, menuProvider));
            }
        } else {
            PlayerWaystoneManager.activateWaystone(player, waystone);
            if (!world.isClientSide) {
                MutableComponent nameComponent = waystone.getName().copy().withStyle(ChatFormatting.WHITE);
                MutableComponent chatComponent = Component.translatable((String)"chat.waystones.waystone_activated", (Object[])new Object[]{nameComponent}).withStyle(ChatFormatting.YELLOW);
                player.sendSystemMessage((Component)chatComponent);
                WaystoneSyncManager.sendActivatedWaystones(player);
                world.playSound(null, pos, SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 0.2f, 1.0f);
            }
            this.notifyObserversOfAction(world, pos);
            if (world.isClientSide) {
                for (int i = 0; i < 32; ++i) {
                    world.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5 + (world.random.nextDouble() - 0.5) * 2.0, (double)(pos.getY() + 3), (double)pos.getZ() + 0.5 + (world.random.nextDouble() - 0.5) * 2.0, 0.0, -5.0, 0.0);
                    world.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5 + (world.random.nextDouble() - 0.5) * 2.0, (double)(pos.getY() + 4), (double)pos.getZ() + 0.5 + (world.random.nextDouble() - 0.5) * 2.0, 0.0, -5.0, 0.0);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.nextFloat() < 0.75f) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            LocalPlayer player = Minecraft.getInstance().player;
            if (blockEntity instanceof WaystoneBlockEntity && PlayerWaystoneManager.isWaystoneActivated((Player)Objects.requireNonNull(player), ((WaystoneBlockEntity)blockEntity).getWaystone())) {
                world.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 1.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 1.5, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 1.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 1.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

