/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.handler.glfw;

import bre2el.fpsreducer.handler.WakeupEventHandler;
import net.minecraft.client.Minecraft;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;

public class InputEventHandler {
    public static InputEventHandler INSTANCE = new InputEventHandler();
    public CursorPosEventHandler CURSORPOS = new CursorPosEventHandler();
    public MouseButtonEventHandler MOUSEBUTTON = new MouseButtonEventHandler();
    public ScrollEventHandler SCROLL = new ScrollEventHandler();
    private long lastEventNanoSec;
    private boolean eventInIdle;

    private InputEventHandler() {
    }

    public void addCallbacks() {
        this.CURSORPOS.addCallback();
        this.MOUSEBUTTON.addCallback();
        this.SCROLL.addCallback();
    }

    public long getLastEventNanoSec() {
        return this.lastEventNanoSec;
    }

    public long updateLastEventNanoSec() {
        this.lastEventNanoSec = System.nanoTime();
        return this.lastEventNanoSec;
    }

    public void clearInputEventInIdle() {
        this.eventInIdle = false;
    }

    public boolean isInputEventInIdle() {
        return this.eventInIdle;
    }

    public void detectInputEvent() {
        if (WakeupEventHandler.INSTANCE.cancelableWaitEvents) {
            this.eventInIdle = true;
        }
    }

    public class CursorPosEventHandler
    extends GLFWCursorPosCallback {
        private long lastEventNanoSec;
        private GLFWCursorPosCallback origCursorPosCallback;

        public void addCallback() {
            long handle = Minecraft.getInstance().getWindow().getWindow();
            this.origCursorPosCallback = GLFW.glfwSetCursorPosCallback((long)handle, (GLFWCursorPosCallbackI)this);
        }

        public void invoke(long window, double posx, double posy) {
            this.lastEventNanoSec = InputEventHandler.this.updateLastEventNanoSec();
            InputEventHandler.this.detectInputEvent();
            this.origCursorPosCallback.invoke(window, posx, posy);
        }

        public long getLastEventNanoSec() {
            return this.lastEventNanoSec;
        }
    }

    public class MouseButtonEventHandler
    extends GLFWMouseButtonCallback {
        private int pressCount;
        private long lastEventNanoSec;
        private GLFWMouseButtonCallback origMouseButtonCallback;

        public void addCallback() {
            long handle = Minecraft.getInstance().getWindow().getWindow();
            this.origMouseButtonCallback = GLFW.glfwSetMouseButtonCallback((long)handle, (GLFWMouseButtonCallbackI)this);
        }

        public void invoke(long window, int button, int action, int mods) {
            this.lastEventNanoSec = InputEventHandler.this.updateLastEventNanoSec();
            if (action == 1) {
                ++this.pressCount;
            }
            if (action == 0) {
                --this.pressCount;
            }
            InputEventHandler.this.detectInputEvent();
            this.origMouseButtonCallback.invoke(window, button, action, mods);
        }

        public boolean isButtonPressed() {
            return this.pressCount > 0;
        }

        public long getLastEventNanoSec() {
            return this.lastEventNanoSec;
        }
    }

    public class ScrollEventHandler
    extends GLFWScrollCallback {
        private long lastEventNanoSec;
        private GLFWScrollCallback origScrollCallback;

        public void addCallback() {
            long handle = Minecraft.getInstance().getWindow().getWindow();
            this.origScrollCallback = GLFW.glfwSetScrollCallback((long)handle, (GLFWScrollCallbackI)this);
        }

        public void invoke(long window, double xoffset, double yoffset) {
            this.lastEventNanoSec = InputEventHandler.this.updateLastEventNanoSec();
            InputEventHandler.this.detectInputEvent();
            this.origScrollCallback.invoke(window, xoffset, yoffset);
        }

        public long getLastEventNanoSec() {
            return this.lastEventNanoSec;
        }
    }
}

