/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.config;

import bre2el.fpsreducer.config.CommonConfig;
import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.util.Logger;
import bre2el.fpsreducer.util.Reflection;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.ConfigFileTypeHandler;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PlayerConfig
extends CommonConfig {
    private static final ModConfigSpec playerSpec;
    private static final Player PLAYER;
    private static boolean configLoaded;
    public static final String configFilename;
    private static ModContainer activeContainer;

    public static void registerConfig(IEventBus modEventBus, ModContainer modContainer) {
        File configDir = FMLPaths.CONFIGDIR.get().resolve("fpsreducer").toFile();
        if (configDir.getParentFile() != null) {
            configDir.mkdirs();
        }
        if (PlayerConfig.isConfigFileExist()) {
            modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)playerSpec, "fpsreducer" + File.separator + configFilename);
        } else {
            activeContainer = ModLoadingContext.get().getActiveContainer();
        }
        modEventBus.register(PlayerConfig.class);
    }

    public static boolean isConfigFileExist() {
        String filename = "fpsreducer" + File.separator + configFilename;
        File configFile = FMLPaths.CONFIGDIR.get().resolve(filename).toFile();
        return configFile.exists();
    }

    public static String getPlayerConfigFileName() {
        String playerHashStr = DigestUtils.md5Hex((String)Minecraft.getInstance().getUser().getProfileId().toString());
        return "player-" + playerHashStr + ".toml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateConfig() {
        ModConfig modConfig = new ModConfig(ModConfig.Type.CLIENT, (IConfigSpec)playerSpec, activeContainer, "fpsreducer" + File.separator + configFilename);
        Player player = PLAYER;
        synchronized (player) {
            CommentedFileConfig configData = (CommentedFileConfig)ConfigFileTypeHandler.TOML.reader(FMLPaths.CONFIGDIR.get()).apply(modConfig);
            try {
                Reflection.setPrivateField(modConfig, "configData", configData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            playerSpec.setConfig((CommentedConfig)configData);
            PlayerConfig.PLAYER.configData = modConfig.getConfigData();
            PLAYER.readFromConfigData();
            PLAYER.setInitialValues();
            modConfig.save();
        }
        Config.initCurrentConfig();
        configLoaded = true;
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getType() == ModConfig.Type.CLIENT) {
            ModConfig modConfig = configEvent.getConfig();
            if (modConfig.getSpec() == playerSpec) {
                PlayerConfig.PLAYER.configData = modConfig.getConfigData();
                PLAYER.readFromConfigData();
                Logger.debug("Player config file loaded.");
                configLoaded = true;
            }
            Config.initCurrentConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        if (configEvent.getConfig().getType() == ModConfig.Type.CLIENT) {
            ModConfig modConfig = configEvent.getConfig();
            if (configLoaded && modConfig.getSpec() == playerSpec) {
                Player player = PLAYER;
                synchronized (player) {
                    if (modConfig.getConfigData() instanceof CommentedFileConfig) {
                        PLAYER.readFromConfigData();
                        Logger.debug("Player config file got changed on the file system.");
                    }
                }
            }
        }
    }

    static {
        configFilename = PlayerConfig.getPlayerConfigFileName();
        Pair playerSpecPair = new ModConfigSpec.Builder().configure(Player::new);
        playerSpec = (ModConfigSpec)playerSpecPair.getRight();
        Config.PLAYER = PLAYER = (Player)playerSpecPair.getLeft();
    }

    public static class Player
    extends CommonConfig.Common {
        public boolean usePlayerConfig;
        private final ModConfigSpec.BooleanValue usePlayerConfigVal;

        Player(ModConfigSpec.Builder builder) {
            super(builder);
            builder.comment("Player options").push("player");
            this.usePlayerConfigVal = builder.comment("Use player config file.").translation("fpsreducer.config.usePlayerConfig").define("usePlayerConfig", false);
            builder.pop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readFromConfigData() {
            Player player = this;
            synchronized (player) {
                super.readFromConfigData();
                this.usePlayerConfig = (Boolean)this.usePlayerConfigVal.get();
                this.convertOldValues();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeToConfigData() {
            Player player = this;
            synchronized (player) {
                super.writeToConfigData();
                this.setIfModified(this.usePlayerConfigVal, this.usePlayerConfig);
            }
        }

        private void setInitialValues() {
            if (Config.GLOBAL != null) {
                this.enableFpsReducer = Config.GLOBAL.enableFpsReducer;
                this.waitingTime = Config.GLOBAL.waitingTime;
                this.idleFps = Config.GLOBAL.idleFps;
                this.guiScreenFps = Config.GLOBAL.guiScreenFps;
                this.noActFps = Config.GLOBAL.noActFps;
                this.detectMoving = Config.GLOBAL.detectMoving;
                this.ignoreHoldButton = Config.GLOBAL.ignoreHoldButton;
                this.reducingInGameMenu = Config.GLOBAL.reducingInGameMenu;
                this.reducingInBackground = Config.GLOBAL.reducingInBackground;
                this.suppressSound = Config.GLOBAL.suppressSound;
                this.suppressedVolume = Config.GLOBAL.suppressedVolume;
                this.hudEnabled = Config.GLOBAL.hudEnabled;
                this.profile = Config.GLOBAL.profile;
                for (int i = 0; i < 9; ++i) {
                    this.hudPos[i] = Config.GLOBAL.hudPos[i].copy();
                }
                this.setHudReferencePos(Config.GLOBAL.getHudReferencePos());
                this.hudScale = Config.GLOBAL.hudScale;
                this.hudBehindChatBox = Config.GLOBAL.hudBehindChatBox;
                this.hudInfo = Config.GLOBAL.hudInfo;
                this.writeToConfigData();
            }
        }
    }
}

