/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.ftbquests.jei;

import dev.ftb.mods.ftbquests.registry.ModItems;
import dev.ftb.mods.ftbxmodcompat.ftbquests.jei.FTBQuestsJEIIntegration;
import dev.ftb.mods.ftbxmodcompat.ftbquests.jei.JEIRecipeTypes;
import dev.ftb.mods.ftbxmodcompat.ftbquests.jei.LootCrateCategory;
import dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common.WrappedLootCrate;
import dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common.WrappedLootCrateCache;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.world.item.ItemStack;

public enum LootCrateRecipeManagerPlugin implements IRecipeManagerPlugin
{
    INSTANCE;

    private final WrappedLootCrateCache cache = new WrappedLootCrateCache(crates -> {
        if (FTBQuestsJEIIntegration.runtime != null && !crates.isEmpty()) {
            FTBQuestsJEIIntegration.runtime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, (Collection)crates);
        }
    }, crates -> {
        if (FTBQuestsJEIIntegration.runtime != null && !crates.isEmpty()) {
            FTBQuestsJEIIntegration.runtime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, (Collection)crates);
        }
    });

    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        Object object = focus.getTypedValue().getIngredient();
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (focus.getRole() == RecipeIngredientRole.INPUT ? stack.getItem() == ModItems.LOOTCRATE.get() : focus.getRole() == RecipeIngredientRole.OUTPUT && !this.cache.findCratesWithOutput(stack).isEmpty()) {
                return List.of(JEIRecipeTypes.LOOT_CRATE);
            }
        }
        return List.of();
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        Object object;
        if (recipeCategory instanceof LootCrateCategory && (object = focus.getTypedValue().getIngredient()) instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (stack.getItem() == ModItems.LOOTCRATE.get() && focus.getRole() == RecipeIngredientRole.CATALYST) {
                return this.cache.getWrappedLootCrates();
            }
            return switch (focus.getRole()) {
                case RecipeIngredientRole.INPUT -> this.cache.findCratesWithInput(stack);
                case RecipeIngredientRole.OUTPUT -> this.cache.findCratesWithOutput(stack);
                default -> List.of();
            };
        }
        return List.of();
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        return recipeCategory instanceof LootCrateCategory ? this.cache.getWrappedLootCrates() : List.of();
    }

    public List<WrappedLootCrate> getWrappedLootCrates() {
        return this.cache.getWrappedLootCrates();
    }

    public void refresh() {
        this.cache.refresh();
    }
}

