/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class SyncedEffectMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SyncedEffectMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)"synced_effect"));
    private final BlockPos pos;
    private final Type type;

    public SyncedEffectMessage(BlockPos pos, Type type) {
        this.pos = pos;
        this.type = type;
    }

    public static void encode(FriendlyByteBuf buf, SyncedEffectMessage message) {
        buf.writeLong(message.pos.asLong());
        buf.writeByte(message.type.ordinal());
    }

    public static SyncedEffectMessage decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        Type type = Type.values()[buf.readByte()];
        return new SyncedEffectMessage(pos, type);
    }

    public static void handle(Player player, SyncedEffectMessage message) {
        SimpleParticleType particleType = ParticleTypes.EXPLOSION;
        int particleCount = 1;
        float particleRandomOffset = 1.0f;
        Vec3i particleOffset = Vec3i.ZERO;
        SoundEvent soundEvent = null;
        float volume = 1.0f;
        switch (message.type.ordinal()) {
            case 0: {
                soundEvent = SoundEvents.CHICKEN_EGG;
                particleOffset = new Vec3i(0, 1, 0);
                break;
            }
            case 1: 
            case 2: {
                soundEvent = SoundEvents.ANVIL_USE;
                particleType = ParticleTypes.LARGE_SMOKE;
                particleCount = 10;
                volume = 0.5f;
            }
        }
        if (soundEvent != null) {
            Minecraft.getInstance().level.playLocalSound((double)message.pos.getX(), (double)message.pos.getY(), (double)message.pos.getZ(), soundEvent, SoundSource.BLOCKS, volume, 1.0f, false);
        }
        for (int i = 0; i < particleCount; ++i) {
            float offsetX = (float)particleOffset.getX() + 0.5f + (float)(Math.random() - 0.5) * particleRandomOffset;
            float offsetY = (float)particleOffset.getX() + 0.5f + (float)(Math.random() - 0.5) * particleRandomOffset;
            float offsetZ = (float)particleOffset.getX() + 0.5f + (float)(Math.random() - 0.5) * particleRandomOffset;
            Minecraft.getInstance().level.addParticle((ParticleOptions)particleType, true, (double)((float)message.pos.getX() + offsetX), (double)((float)message.pos.getY() + offsetY), (double)((float)message.pos.getZ() + offsetZ), 0.0, 0.0, 0.0);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Type {
        COW_IN_A_JAR,
        OVEN_UPGRADE,
        FRIDGE_UPGRADE;

    }
}

