/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import net.blay09.mods.cookingforblockheads.menu.KitchenMenu;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CraftRecipeMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<CraftRecipeMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)"craft_recipe"));
    private final ResourceLocation recipeId;
    private final NonNullList<ItemStack> lockedInputs;
    private final boolean craftFullStack;
    private final boolean addToInventory;

    public CraftRecipeMessage(ResourceLocation recipeId, @Nullable NonNullList<ItemStack> lockedInputs, boolean craftFullStack, boolean addToInventory) {
        this.recipeId = recipeId;
        this.lockedInputs = lockedInputs;
        this.craftFullStack = craftFullStack;
        this.addToInventory = addToInventory;
    }

    public static void encode(RegistryFriendlyByteBuf buf, CraftRecipeMessage message) {
        buf.writeResourceLocation(message.recipeId);
        if (message.lockedInputs != null) {
            buf.writeByte(message.lockedInputs.size());
            for (ItemStack itemstack : message.lockedInputs) {
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)itemstack);
            }
        } else {
            buf.writeByte(0);
        }
        buf.writeBoolean(message.craftFullStack);
        buf.writeBoolean(message.addToInventory);
    }

    public static CraftRecipeMessage decode(RegistryFriendlyByteBuf buf) {
        ResourceLocation recipeId = buf.readResourceLocation();
        int lockedInputsCount = buf.readByte();
        NonNullList lockedInputs = NonNullList.createWithCapacity((int)lockedInputsCount);
        for (int i = 0; i < lockedInputsCount; ++i) {
            lockedInputs.add((Object)((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf)));
        }
        boolean craftFullStack = buf.readBoolean();
        boolean addToInventory = buf.readBoolean();
        return new CraftRecipeMessage(recipeId, (NonNullList<ItemStack>)lockedInputs, craftFullStack, addToInventory);
    }

    public static void handle(ServerPlayer player, CraftRecipeMessage message) {
        AbstractContainerMenu container = player.containerMenu;
        if (container instanceof KitchenMenu) {
            KitchenMenu kitchenMenu = (KitchenMenu)container;
            kitchenMenu.craft(message.recipeId, message.lockedInputs, message.craftFullStack, message.addToInventory);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

